/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.invoker;

import com.android.tools.idea.gradle.IdeaGradleProject;
import com.android.tools.idea.gradle.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.invoker.GradleOutputForwarder;
import com.android.tools.idea.gradle.invoker.console.view.GradleConsoleView;
import com.android.tools.idea.gradle.invoker.messages.GradleBuildTreeViewPanel;
import com.android.tools.idea.gradle.output.GradleMessage;
import com.android.tools.idea.gradle.output.GradleProjectAwareMessage;
import com.android.tools.idea.gradle.output.parser.BuildOutputParser;
import com.android.tools.idea.gradle.output.parser.PatternAwareOutputParser;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AppIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.plugins.gradle.service.project.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

class GradleTasksExecutor
extends Task.Backgroundable {
    private static final ExternalSystemTaskNotificationListener GRADLE_LISTENER = new ExternalSystemTaskNotificationListenerAdapter(){};
    private static final long ONE_MINUTE_MS = 60000L;
    private static final Logger LOG = Logger.getInstance(GradleInvoker.class);
    @NonNls
    private static final String CONTENT_NAME = "Gradle Build";
    @NonNls
    private static final String APP_ICON_ID = "compiler";
    private static final Key<Key<?>> CONTENT_ID_KEY = Key.create((String)"CONTENT_ID");
    private static final int BUFFER_SIZE = 2048;
    private static final String GRADLE_RUNNING_MSG_TITLE = "Gradle Running";
    private static final String STOPPING_GRADLE_MSG_TITLE = "Stopping Gradle";
    @NotNull
    private final Key<Key<?>> myContentId;
    @NotNull
    private final Object myMessageViewLock;
    @Nullable
    private GradleBuildTreeViewPanel myErrorTreeView;
    @NotNull
    private final GradleExecutionHelper myHelper;
    @NotNull
    private final List<String> myGradleTasks;
    @NotNull
    private final List<String> myCommandLineArguments;
    @NotNull
    private final GradleInvoker.AfterGradleInvocationTask[] myAfterGradleInvocationTasks;
    private volatile int myErrorCount;
    private volatile int myWarningCount;
    @NotNull
    private volatile ProgressIndicator myIndicator;
    private volatile boolean myMessageViewIsPrepared;
    private volatile boolean myMessagesAutoActivated;
    private CloseListener myCloseListener;

    GradleTasksExecutor(@NotNull Project project, @NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments, @NotNull GradleInvoker.AfterGradleInvocationTask[] afterGradleInvocationTasks) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "<init>"));
        }
        if (gradleTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleTasks", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "<init>"));
        }
        if (commandLineArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArguments", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "<init>"));
        }
        if (afterGradleInvocationTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterGradleInvocationTasks", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "<init>"));
        }
        super(project, String.format("Gradle: Executing Tasks %1$s", gradleTasks.toString()), false);
        this.myContentId = Key.create((String)"compile_content");
        this.myMessageViewLock = new Object();
        this.myHelper = new GradleExecutionHelper();
        this.myIndicator = new EmptyProgressIndicator();
        this.myGradleTasks = gradleTasks;
        this.myCommandLineArguments = commandLineArguments;
        this.myAfterGradleInvocationTasks = afterGradleInvocationTasks;
    }

    public String getProcessId() {
        return "GradleTaskInvocation";
    }

    @NotNull
    public DumbModeAction getDumbModeAction() {
        DumbModeAction dumbModeAction = DumbModeAction.WAIT;
        if (dumbModeAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "getDumbModeAction"));
        }
        return dumbModeAction;
    }

    @Nullable
    public Task.NotificationInfo getNotificationInfo() {
        return new Task.NotificationInfo(this.myErrorCount > 0 ? "Gradle Invocation (errors)" : "Gradle Invocation (success)", "Gradle Invocation Finished", this.myErrorCount + " Errors, " + this.myWarningCount + " Warnings", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "run"));
        }
        this.myIndicator = indicator;
        ProjectManager projectManager = ProjectManager.getInstance();
        Project project = this.getNotNullProject();
        this.myCloseListener = new CloseListener();
        projectManager.addProjectManagerListener(project, (ProjectManagerListener)this.myCloseListener);
        Semaphore semaphore = ((CompilerManagerImpl)CompilerManager.getInstance((Project)project)).getCompilationSemaphore();
        boolean acquired = false;
        try {
            try {
                while (!acquired) {
                    acquired = semaphore.tryAcquire(300L, TimeUnit.MILLISECONDS);
                    if (!indicator.isCanceled()) continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!this.isHeadless()) {
                this.addIndicatorDelegate();
            }
            this.invokeGradleTasks();
        }
        finally {
            try {
                indicator.stop();
                projectManager.removeProjectManagerListener(project, (ProjectManagerListener)this.myCloseListener);
            }
            finally {
                if (acquired) {
                    semaphore.release();
                }
            }
        }
    }

    private void addIndicatorDelegate() {
        if (this.myIndicator instanceof ProgressIndicatorEx) {
            ProgressIndicatorEx indicator = (ProgressIndicatorEx)this.myIndicator;
            indicator.addStateDelegate((ProgressIndicatorEx)new ProgressIndicatorStateDelegate());
        }
    }

    private void closeView() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = GradleTasksExecutor.this.myMessageViewLock;
                synchronized (object) {
                    if (GradleTasksExecutor.this.myErrorTreeView != null && !GradleTasksExecutor.this.getNotNullProject().isDisposed()) {
                        this.addStatisticsMessage(CompilerBundle.message((String)"statistics.error.count", (Object[])new Object[]{GradleTasksExecutor.this.myErrorCount}));
                        this.addStatisticsMessage(CompilerBundle.message((String)"statistics.warnings.count", (Object[])new Object[]{GradleTasksExecutor.this.myWarningCount}));
                        GradleTasksExecutor.this.addMessage(new GradleMessage(GradleMessage.Kind.INFO, "See complete output in console"), new OpenGradleConsole());
                        GradleTasksExecutor.this.myErrorTreeView.selectFirstMessage();
                    }
                }
            }

            private void addStatisticsMessage(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor$2", "addStatisticsMessage"));
                }
                GradleTasksExecutor.this.addMessage(new GradleMessage(GradleMessage.Kind.STATISTICS, text), null);
            }
        }, ModalityState.NON_MODAL);
    }

    private void invokeGradleTasks() {
        final Project project = this.getNotNullProject();
        final GradleExecutionSettings executionSettings = GradleUtil.getGradleExecutionSettings(project);
        final String projectPath = project.getBasePath();
        Function<ProjectConnection, Void> executeTasksFunction = new Function<ProjectConnection, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void fun(ProjectConnection connection) {
                String gradleOutput;
                Stopwatch stopwatch = Stopwatch.createStarted();
                GradleConsoleView consoleView = GradleConsoleView.getInstance(project);
                consoleView.clear();
                GradleTasksExecutor.this.addMessage(new GradleMessage(GradleMessage.Kind.INFO, "Gradle tasks " + GradleTasksExecutor.this.myGradleTasks), null);
                ExternalSystemTaskId id = ExternalSystemTaskId.create((ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project);
                BuildMode buildMode = BuildSettings.getInstance(project).getBuildMode();
                List<String> jvmArgs = GradleUtil.getGradleInvocationJvmArgs(new File(projectPath), buildMode);
                LOG.info("Build JVM args: " + jvmArgs);
                String executingTasksText = "Executing tasks: " + GradleTasksExecutor.this.myGradleTasks + SystemProperties.getLineSeparator() + SystemProperties.getLineSeparator();
                consoleView.print(executingTasksText, ConsoleViewContentType.NORMAL_OUTPUT);
                GradleOutputForwarder output = new GradleOutputForwarder(consoleView);
                BuildException buildError = null;
                try {
                    AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
                    ArrayList commandLineArgs = Lists.newArrayList((Object[])buildConfiguration.getCommandLineOptions());
                    if (buildConfiguration.USE_CONFIGURATION_ON_DEMAND && !commandLineArgs.contains("--configure-on-demand")) {
                        commandLineArgs.add("--configure-on-demand");
                    }
                    if (!commandLineArgs.contains("--parallel") && CompilerWorkspaceConfiguration.getInstance((Project)project).PARALLEL_COMPILATION) {
                        commandLineArgs.add("--parallel");
                    }
                    commandLineArgs.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
                    commandLineArgs.addAll(GradleTasksExecutor.this.myCommandLineArguments);
                    LOG.info("Build command line options: " + commandLineArgs);
                    BuildLauncher launcher = connection.newBuild();
                    GradleExecutionHelper.prepare((LongRunningOperation)launcher, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)GRADLE_LISTENER, jvmArgs, (List)commandLineArgs, (ProjectConnection)connection);
                    File javaHome = DefaultSdks.getDefaultJavaHome();
                    if (javaHome != null) {
                        launcher.setJavaHome(javaHome);
                    }
                    launcher.forTasks(ArrayUtil.toStringArray((Collection)GradleTasksExecutor.this.myGradleTasks));
                    output.attachTo(launcher);
                    launcher.run();
                    gradleOutput = output.toString();
                }
                catch (BuildException e) {
                    String gradleOutput2;
                    try {
                        buildError = e;
                        gradleOutput2 = output.toString();
                    }
                    catch (Throwable throwable) {
                        String gradleOutput3 = output.toString();
                        ArrayList buildMessages = Lists.newArrayList((Iterable)GradleTasksExecutor.this.showMessages(gradleOutput3));
                        if (GradleTasksExecutor.this.myErrorCount == 0 && buildError != null) {
                            GradleTasksExecutor.this.showBuildException(buildError, output.getStdErr(), buildMessages);
                        }
                        output.close();
                        stopwatch.stop();
                        ApplicationManager.getApplication().invokeLater(new Runnable(stopwatch){
                            final /* synthetic */ Stopwatch val$stopwatch;
                            {
                                this.val$stopwatch = stopwatch;
                            }

                            @Override
                            public void run() {
                                GradleTasksExecutor.this.notifyGradleInvocationCompleted(this.val$stopwatch.elapsed(TimeUnit.MILLISECONDS));
                            }
                        });
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GradleTasksExecutor.this.showMessages();
                            }
                        });
                        boolean buildSuccessful = buildError == null;
                        GradleInvocationResult result = new GradleInvocationResult(GradleTasksExecutor.this.myGradleTasks, buildMessages, buildSuccessful);
                        for (GradleInvoker.AfterGradleInvocationTask task : GradleTasksExecutor.this.myAfterGradleInvocationTasks) {
                            task.execute(result);
                        }
                        throw throwable;
                    }
                    ArrayList buildMessages = Lists.newArrayList((Iterable)GradleTasksExecutor.this.showMessages(gradleOutput2));
                    if (GradleTasksExecutor.this.myErrorCount == 0 && buildError != null) {
                        GradleTasksExecutor.this.showBuildException(buildError, output.getStdErr(), buildMessages);
                    }
                    output.close();
                    stopwatch.stop();
                    ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                    ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                    boolean buildSuccessful = buildError == null;
                    GradleInvocationResult result = new GradleInvocationResult(GradleTasksExecutor.this.myGradleTasks, buildMessages, buildSuccessful);
                    for (GradleInvoker.AfterGradleInvocationTask task : GradleTasksExecutor.this.myAfterGradleInvocationTasks) {
                        task.execute(result);
                    }
                }
                ArrayList buildMessages = Lists.newArrayList((Iterable)GradleTasksExecutor.this.showMessages(gradleOutput));
                if (GradleTasksExecutor.this.myErrorCount == 0 && buildError != null) {
                    GradleTasksExecutor.this.showBuildException(buildError, output.getStdErr(), buildMessages);
                }
                output.close();
                stopwatch.stop();
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                boolean buildSuccessful = buildError == null;
                GradleInvocationResult result = new GradleInvocationResult(GradleTasksExecutor.this.myGradleTasks, buildMessages, buildSuccessful);
                for (GradleInvoker.AfterGradleInvocationTask task : GradleTasksExecutor.this.myAfterGradleInvocationTasks) {
                    task.execute(result);
                }
                return null;
            }
        };
        try {
            Application application;
            Runnable task;
            if (AndroidPlugin.isGuiTestingMode() && (task = (Runnable)(application = ApplicationManager.getApplication()).getUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY)) != null) {
                application.putUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY, null);
                task.run();
            }
            this.myHelper.execute(projectPath, executionSettings, (Function)executeTasksFunction);
        }
        catch (ExternalSystemException e) {
            if (this.myIndicator.isCanceled()) {
                LOG.info("Failed to complete Gradle execution. Project may be closing or already closed.", (Throwable)e);
            }
            final String error = e.getMessage();
            Runnable showErrorTask = new Runnable(){

                @Override
                public void run() {
                    String msg = "Failed to complete Gradle execution.\n\nCause:\n" + error;
                    Messages.showErrorDialog((Project)GradleTasksExecutor.this.myProject, (String)msg, (String)GradleTasksExecutor.GRADLE_RUNNING_MSG_TITLE);
                    if (AndroidStudioSpecificInitializer.isAndroidStudio() && error.startsWith("Supplied javaHome is not a valid folder")) {
                        File androidHome = DefaultSdks.getDefaultAndroidHome();
                        String androidSdkPath = androidHome != null ? androidHome.getPath() : null;
                        SelectSdkDialog selectSdkDialog = new SelectSdkDialog(null, androidSdkPath);
                        selectSdkDialog.setModal(true);
                        if (selectSdkDialog.showAndGet()) {
                            String jdkHome = selectSdkDialog.getJdkHome();
                            DefaultSdks.setDefaultJavaHome(new File(jdkHome));
                        }
                    }
                }
            };
            AppUIUtil.invokeLaterIfProjectAlive((Project)this.getNotNullProject(), (Runnable)showErrorTask);
        }
    }

    @NotNull
    private List<GradleMessage> showMessages(@NotNull String gradleOutput) {
        if (gradleOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleOutput", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "showMessages"));
        }
        Iterable parsers = JpsServiceManager.getInstance().getExtensions(PatternAwareOutputParser.class);
        List compilerMessages = new BuildOutputParser(parsers).parseGradleOutput(gradleOutput);
        for (GradleMessage msg : compilerMessages) {
            this.addMessage(msg, null);
        }
        List list = compilerMessages;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "showMessages"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showBuildException(@NotNull BuildException e, @NotNull String stdErr, @NotNull List<GradleMessage> buildMessages) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "showBuildException"));
        }
        if (stdErr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stdErr", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "showBuildException"));
        }
        if (buildMessages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMessages", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "showBuildException"));
        }
        if (!stdErr.trim().isEmpty()) {
            GradleMessage msg = new GradleMessage(GradleMessage.Kind.ERROR, stdErr);
            buildMessages.add(msg);
            this.addMessage(msg, null);
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            try {
                e.printStackTrace(new PrintStream(out));
                String message = "Internal error:" + SystemProperties.getLineSeparator() + out.toString();
                GradleMessage msg = new GradleMessage(GradleMessage.Kind.ERROR, message);
                buildMessages.add(msg);
                this.addMessage(msg, null);
            }
            finally {
                try {
                    Closeables.close((Closeable)out, (boolean)true);
                }
                catch (IOException ex) {}
            }
        }
    }

    private void addMessage(final @NotNull GradleMessage message, final @Nullable Navigatable navigatable) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "addMessage"));
        }
        this.prepareMessageView();
        switch (message.getKind()) {
            case WARNING: {
                ++this.myWarningCount;
                break;
            }
            case ERROR: {
                ++this.myErrorCount;
            }
        }
        Runnable addMessageTask = new Runnable(){

            @Override
            public void run() {
                GradleTasksExecutor.this.openMessageView();
                GradleTasksExecutor.this.add(message, navigatable);
            }
        };
        UIUtil.invokeLaterIfNeeded((Runnable)addMessageTask);
    }

    private void prepareMessageView() {
        if (!this.myIndicator.isRunning() || this.myMessageViewIsPrepared) {
            return;
        }
        this.myMessageViewIsPrepared = true;
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!GradleTasksExecutor.this.getNotNullProject().isDisposed()) {
                    Object object = GradleTasksExecutor.this.myMessageViewLock;
                    synchronized (object) {
                        if (GradleTasksExecutor.this.myErrorTreeView == null) {
                            GradleTasksExecutor.removeUnpinnedBuildMessages(GradleTasksExecutor.this.getNotNullProject(), null);
                        }
                    }
                }
            }
        });
    }

    static void clearMessageView(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "clearMessageView"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!project.isDisposed()) {
                    GradleTasksExecutor.removeUnpinnedBuildMessages(project, null);
                }
            }
        });
    }

    private static void removeUnpinnedBuildMessages(@NotNull Project project, @Nullable Content toKeep) {
        Content[] contents;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "removeUnpinnedBuildMessages"));
        }
        MessageView messageView = MessageView.SERVICE.getInstance((Project)project);
        for (Content content : contents = messageView.getContentManager().getContents()) {
            if (content.isPinned() || content == toKeep || content.getUserData(CONTENT_ID_KEY) == null) continue;
            messageView.getContentManager().removeContent(content, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMessageView() {
        JComponent component;
        if (this.myIndicator.isCanceled()) {
            return;
        }
        Project project = this.getNotNullProject();
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                return;
            }
            this.myErrorTreeView = new GradleBuildTreeViewPanel(project);
            this.myErrorTreeView.setProcessController(new NewErrorTreeViewPanel.ProcessController(){

                public void stopProcess() {
                }

                public boolean isProcessStopped() {
                    return !GradleTasksExecutor.this.myIndicator.isRunning();
                }
            });
            component = this.myErrorTreeView.getComponent();
        }
        Content content = ContentFactory.SERVICE.getInstance().createContent(component, CONTENT_NAME, true);
        content.putUserData(CONTENT_ID_KEY, this.myContentId);
        MessageView messageView = this.getMessageView();
        ContentManager contentManager = messageView.getContentManager();
        contentManager.addContent(content);
        this.myCloseListener.setContent(contentManager, content);
        GradleTasksExecutor.removeUnpinnedBuildMessages(this.getNotNullProject(), content);
        contentManager.setSelectedContent(content);
    }

    private void activateGradleConsole() {
        ToolWindow window = this.getToolWindowManager().getToolWindow("Gradle Console");
        if (window != null) {
            window.activate(null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(@NotNull GradleMessage message, @Nullable Navigatable navigatable) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "add"));
        }
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null && !this.getNotNullProject().isDisposed()) {
                boolean autoActivate;
                GradleMessage.Kind messageKind = message.getKind();
                int type = GradleTasksExecutor.translateMessageKind(messageKind);
                String[] text = GradleTasksExecutor.getTextOf(message);
                if (navigatable == null) {
                    VirtualFile file = this.findFileFrom(message);
                    this.myErrorTreeView.addMessage(type, text, file, message.getLineNumber() - 1, message.getColumn() - 1, null);
                } else {
                    this.myErrorTreeView.addMessage(type, text, null, navigatable, null, null, null);
                }
                boolean bl = autoActivate = !this.myMessagesAutoActivated && type == 4;
                if (autoActivate) {
                    this.myMessagesAutoActivated = true;
                    this.activateMessageView();
                }
            }
        }
    }

    @NotNull
    private static String[] getTextOf(@NotNull GradleMessage message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "getTextOf"));
        }
        String text = message.getText();
        if (text.indexOf(10) == -1) {
            String[] stringArray = new String[]{text};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "getTextOf"));
            }
            return stringArray;
        }
        ArrayList lines = Lists.newArrayList((Iterable)Splitter.on((char)'\n').split((CharSequence)text));
        String[] stringArray = lines.toArray(new String[lines.size()]);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "getTextOf"));
        }
        return stringArray;
    }

    @Nullable
    private VirtualFile findFileFrom(@NotNull GradleMessage message) {
        String sourcePath;
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "findFileFrom"));
        }
        if (message instanceof GradleProjectAwareMessage) {
            String gradlePath = ((GradleProjectAwareMessage)message).getGradlePath();
            Module module = GradleUtil.findModuleByGradlePath(this.getNotNullProject(), gradlePath);
            if (module != null) {
                AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
                assert (facet != null);
                IdeaGradleProject gradleProject = facet.getGradleProject();
                return gradleProject != null ? gradleProject.getBuildFile() : null;
            }
        }
        if (StringUtil.isEmpty((String)(sourcePath = message.getSourcePath()))) {
            return null;
        }
        return VfsUtil.findFileByIoFile((File)new File(sourcePath), (boolean)true);
    }

    private static int translateMessageKind(@NotNull GradleMessage.Kind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "translateMessageKind"));
        }
        switch (kind) {
            case INFO: {
                return 3;
            }
            case WARNING: {
                return 5;
            }
            case ERROR: {
                return 4;
            }
            case STATISTICS: {
                return 2;
            }
            case SIMPLE: {
                return 1;
            }
        }
        LOG.info("Unknown message kind: " + kind);
        return 0;
    }

    private void notifyGradleInvocationCompleted(long durationMillis) {
        Project project = this.getNotNullProject();
        if (!project.isDisposed()) {
            MessageType messageType;
            String statusMsg = this.createStatusMessage(durationMillis);
            MessageType messageType2 = this.myErrorCount > 0 ? MessageType.ERROR : (messageType = this.myWarningCount > 0 ? MessageType.WARNING : MessageType.INFO);
            if (durationMillis > 60000L) {
                this.getToolWindowManager().notifyByBalloon(ToolWindowId.MESSAGES_WINDOW, messageType, statusMsg);
            }
            CompilerManager.NOTIFICATION_GROUP.createNotification(statusMsg, messageType).notify(this.myProject);
        }
    }

    @NotNull
    private String createStatusMessage(long durationMillis) {
        String message = "Gradle build finished";
        if (this.myErrorCount > 0) {
            message = this.myWarningCount > 0 ? message + String.format(" with %d error(s) and %d warning(s)", this.myErrorCount, this.myWarningCount) : message + String.format(" with %d error(s)", this.myErrorCount);
        } else if (this.myWarningCount > 0) {
            message = message + String.format(" with %d warnings(s)", this.myWarningCount);
        }
        String string = message = message + " in " + StringUtil.formatDuration((long)durationMillis);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "createStatusMessage"));
        }
        return string;
    }

    @NotNull
    private ToolWindowManager getToolWindowManager() {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.getNotNullProject());
        if (toolWindowManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "getToolWindowManager"));
        }
        return toolWindowManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessages() {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null && !this.getNotNullProject().isDisposed()) {
                Content[] contents;
                MessageView messageView = this.getMessageView();
                for (Content content : contents = messageView.getContentManager().getContents()) {
                    if (content.getUserData(CONTENT_ID_KEY) == null) continue;
                    messageView.getContentManager().setSelectedContent(content);
                    return;
                }
            }
        }
    }

    @NotNull
    private MessageView getMessageView() {
        MessageView messageView = MessageView.SERVICE.getInstance((Project)this.getNotNullProject());
        if (messageView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "getMessageView"));
        }
        return messageView;
    }

    @NotNull
    private Project getNotNullProject() {
        assert (this.myProject != null);
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor", "getNotNullProject"));
        }
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateMessageView() {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            ToolWindow window;
            if (this.myErrorTreeView != null && (window = this.getToolWindowManager().getToolWindow(ToolWindowId.MESSAGES_WINDOW)) != null) {
                window.activate(null, false);
            }
        }
    }

    private void cancel() {
        if (!this.myIndicator.isCanceled()) {
            try {
                GradleUtil.stopAllGradleDaemons(false);
            }
            catch (FileNotFoundException e) {
                Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)STOPPING_GRADLE_MSG_TITLE);
            }
            catch (IOException e) {
                String errMsg = "Failed to stop Gradle daemons. Cause: " + e.getMessage();
                Messages.showErrorDialog((Project)this.myProject, (String)errMsg, (String)STOPPING_GRADLE_MSG_TITLE);
            }
            this.myIndicator.cancel();
        }
    }

    private class OpenGradleConsole
    implements Navigatable {
        private OpenGradleConsole() {
        }

        public void navigate(boolean requestFocus) {
            GradleTasksExecutor.this.activateGradleConsole();
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return false;
        }
    }

    private class ProgressIndicatorStateDelegate
    extends AbstractProgressIndicatorExBase {
        private ProgressIndicatorStateDelegate() {
        }

        public void cancel() {
            super.cancel();
            GradleTasksExecutor.this.closeView();
            this.stopAppIconProgress();
        }

        public void stop() {
            super.stop();
            if (!this.isCanceled()) {
                GradleTasksExecutor.this.closeView();
            }
            this.stopAppIconProgress();
        }

        private void stopAppIconProgress() {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    Project project;
                    AppIcon appIcon = AppIcon.getInstance();
                    if (appIcon.hideProgress(project = GradleTasksExecutor.this.getNotNullProject(), (Object)GradleTasksExecutor.APP_ICON_ID)) {
                        if (GradleTasksExecutor.this.myErrorCount > 0) {
                            appIcon.setErrorBadge(project, String.valueOf(GradleTasksExecutor.this.myErrorCount));
                            appIcon.requestAttention(project, true);
                        } else {
                            appIcon.setOkBadge(project, true);
                            appIcon.requestAttention(project, false);
                        }
                    }
                }
            });
        }

        protected void onProgressChange() {
            GradleTasksExecutor.this.prepareMessageView();
        }
    }

    private class CloseListener
    extends ContentManagerAdapter
    implements ProjectManagerListener {
        @NotNull
        private ContentManager myContentManager;
        @Nullable
        private Content myContent;
        private boolean myIsApplicationExitingOrProjectClosing;
        private boolean myUserAcceptedCancel;

        private CloseListener() {
        }

        public void projectOpened(Project project) {
        }

        public boolean canCloseProject(Project project) {
            if (!project.equals(GradleTasksExecutor.this.myProject)) {
                return true;
            }
            if (this.shouldPromptUser()) {
                this.myUserAcceptedCancel = this.askUserToCancelGradleExecution();
                if (!this.myUserAcceptedCancel) {
                    return false;
                }
                GradleTasksExecutor.this.cancel();
                return true;
            }
            return !GradleTasksExecutor.this.myIndicator.isRunning();
        }

        public void projectClosed(Project project) {
            if (project.equals(GradleTasksExecutor.this.myProject) && this.myContent != null) {
                this.myContentManager.removeContent(this.myContent, true);
            }
        }

        public void projectClosing(Project project) {
            if (project.equals(GradleTasksExecutor.this.myProject)) {
                this.myIsApplicationExitingOrProjectClosing = true;
            }
        }

        void setContent(@NotNull ContentManager contentManager, @Nullable Content content) {
            if (contentManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentManager", "com/android/tools/idea/gradle/invoker/GradleTasksExecutor$CloseListener", "setContent"));
            }
            this.myContent = content;
            this.myContentManager = contentManager;
            contentManager.addContentManagerListener((ContentManagerListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contentRemoved(ContentManagerEvent event) {
            if (event.getContent() == this.myContent) {
                Object object = GradleTasksExecutor.this.myMessageViewLock;
                synchronized (object) {
                    Project project = GradleTasksExecutor.this.getNotNullProject();
                    if (GradleTasksExecutor.this.myErrorTreeView != null && !project.isDisposed()) {
                        AppIcon appIcon;
                        GradleTasksExecutor.this.myErrorTreeView.dispose();
                        GradleTasksExecutor.this.myErrorTreeView = null;
                        if (GradleTasksExecutor.this.myIndicator.isRunning()) {
                            GradleTasksExecutor.this.cancel();
                        }
                        if ((appIcon = AppIcon.getInstance()).hideProgress(project, (Object)GradleTasksExecutor.APP_ICON_ID)) {
                            appIcon.setErrorBadge(project, null);
                        }
                    }
                }
                this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
                if (this.myContent != null) {
                    this.myContent.release();
                }
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            if (event.getContent() == this.myContent && !GradleTasksExecutor.this.myIndicator.isCanceled() && this.shouldPromptUser()) {
                this.myUserAcceptedCancel = this.askUserToCancelGradleExecution();
                if (!this.myUserAcceptedCancel) {
                    event.consume();
                }
            }
        }

        private boolean shouldPromptUser() {
            return !this.myUserAcceptedCancel && !this.myIsApplicationExitingOrProjectClosing && GradleTasksExecutor.this.myIndicator.isRunning();
        }

        private boolean askUserToCancelGradleExecution() {
            ProjectManager projectManager = ProjectManager.getInstance();
            ArrayList projectsBeingBuilt = Lists.newArrayList();
            for (Project project : projectManager.getOpenProjects()) {
                BuildMode buildMode;
                if (project.getBasePath().equals(GradleTasksExecutor.this.getNotNullProject().getBasePath()) || (buildMode = BuildSettings.getInstance(project).getBuildMode()) == null) continue;
                projectsBeingBuilt.add("'" + project.getName() + "'");
            }
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append("Gradle is running. Proceed with Project closing?\n\n").append("If you click \"Yes\" Android Studio will stop all the Gradle daemons currently running on your machine.\n").append("Any project builds, either from the command line or in other IDE instances, will stop.");
            if (!projectsBeingBuilt.isEmpty()) {
                msgBuilder.append("\n\nCurrently these projects may be currently being built: ").append(projectsBeingBuilt);
            }
            String msg = msgBuilder.toString();
            int result = Messages.showYesNoDialog((Project)GradleTasksExecutor.this.myProject, (String)msg, (String)GradleTasksExecutor.GRADLE_RUNNING_MSG_TITLE, (Icon)Messages.getQuestionIcon());
            return result == 0;
        }
    }
}

