/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.welcome.FirstRunWizardStep;
import com.android.tools.idea.welcome.SetupEmulatorPath;
import com.android.tools.idea.welcome.WelcomeUIUtils;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MacEmulatorSettingsStep
extends FirstRunWizardStep {
    private static final int MAJOR_TICKS = 4;
    private static final int MINOR_TICKS = 512;
    private static final int MAX_TICK_RESOLUTION = 32;
    private static final int MIN_EMULATOR_MEMORY = 512;
    private static final Logger LOG = Logger.getInstance(MacEmulatorSettingsStep.class);
    private final ScopedStateStore.Key<Integer> myKeyEmulatorMemory;
    private final int myRecommendedMemorySize;
    private JPanel myRoot;
    private JButton myIntelHAXMDocumentationButton;
    private JSlider myMemorySlider;
    private JSpinner myMemorySize;
    private JLabel myUnitLabel;
    private JButton myRecommended;

    public MacEmulatorSettingsStep(ScopedStateStore.Key<Integer> keyEmulatorMemory) {
        super("Emulator Settings");
        this.$$$setupUI$$$();
        this.myUnitLabel.setText(SetupEmulatorPath.UI_UNITS.toString());
        this.myKeyEmulatorMemory = keyEmulatorMemory;
        long memorySize = MacEmulatorSettingsStep.getMemorySize();
        WelcomeUIUtils.makeButtonAHyperlink(this.myIntelHAXMDocumentationButton, "http://www.intel.com/software/android/");
        this.myRecommendedMemorySize = MacEmulatorSettingsStep.setupSliderAndSpinner(memorySize, this.myMemorySlider, this.myMemorySize);
        this.setComponent(this.myRoot);
        this.myRecommended.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacEmulatorSettingsStep.this.myState.put(MacEmulatorSettingsStep.this.myKeyEmulatorMemory, MacEmulatorSettingsStep.this.myRecommendedMemorySize);
            }
        });
    }

    private static int setupSliderAndSpinner(long memorySize, JSlider slider, JSpinner spinner) {
        int recommendedMemorySize = MacEmulatorSettingsStep.getRecommendedMemoryAllocation(memorySize);
        int maxMemory = Math.max(MacEmulatorSettingsStep.getMaxMemoryAllocation(memorySize), recommendedMemorySize);
        int ticks = Math.min(maxMemory / 32, 512);
        slider.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 30));
        slider.setMinimum(512);
        slider.setMaximum(maxMemory);
        slider.setMinorTickSpacing(maxMemory / ticks);
        slider.setMajorTickSpacing(maxMemory / 4);
        Hashtable<Integer, JComponent> labels = new Hashtable<Integer, JComponent>();
        int totalMemory = (int)(memorySize / SetupEmulatorPath.UI_UNITS.getNumberOfBytes());
        int labelSpacing = totalMemory / 4;
        int minDistanceBetweenLabels = labelSpacing / 4;
        for (int i = maxMemory; i >= labelSpacing; i -= labelSpacing) {
            if (Math.abs(i - recommendedMemorySize) <= minDistanceBetweenLabels) continue;
            labels.put(i, new JLabel(MacEmulatorSettingsStep.getMemoryLabel(i)));
        }
        if (recommendedMemorySize > minDistanceBetweenLabels) {
            labels.put(512, new JLabel(MacEmulatorSettingsStep.getMemoryLabel(512)));
        }
        labels.put(recommendedMemorySize, MacEmulatorSettingsStep.createRecommendedSizeLabel(recommendedMemorySize));
        slider.setLabelTable(labels);
        spinner.setModel(new SpinnerNumberModel(512, 512, maxMemory, maxMemory / ticks));
        return recommendedMemorySize;
    }

    private static JComponent createRecommendedSizeLabel(int memorySize) {
        String labelText = String.format("<html><center>%s<br>(Recommended)<center></html>", MacEmulatorSettingsStep.getMemoryLabel(memorySize));
        final Font boldLabelFont = UIUtil.getLabelFont().deriveFont(1);
        return new JLabel(labelText){

            @Override
            public Font getFont() {
                return boldLabelFont;
            }
        };
    }

    private static int getMaxMemoryAllocation(long memorySize) {
        long GB = Storage.Unit.GiB.getNumberOfBytes();
        long maxMemory = memorySize > 4L * GB ? memorySize - 2L * GB : memorySize / 2L;
        return (int)(maxMemory / SetupEmulatorPath.UI_UNITS.getNumberOfBytes());
    }

    private static int getRecommendedMemoryAllocation(long memorySize) {
        long GB = Storage.Unit.GiB.getNumberOfBytes();
        long defaultMemory = memorySize > 4L * GB ? 2L * GB : (memorySize > 2L * GB ? GB : GB / 2L);
        return (int)(defaultMemory / SetupEmulatorPath.UI_UNITS.getNumberOfBytes());
    }

    private static String getMemoryLabel(int memorySize) {
        return new Storage((long)memorySize * SetupEmulatorPath.UI_UNITS.getNumberOfBytes()).toString();
    }

    private static long getMemorySize() {
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Class<?> oracleSpecificMXBean = Class.forName("com.sun.management.OperatingSystemMXBean");
            Method getPhysicalMemorySizeMethod = oracleSpecificMXBean.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            Object result = getPhysicalMemorySizeMethod.invoke((Object)osMXBean, new Object[0]);
            if (result instanceof Number) {
                return ((Number)result).longValue();
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        return 0x800000000L;
    }

    @Override
    public boolean isStepVisible() {
        return SystemInfo.isMac;
    }

    @Override
    public void init() {
        this.myState.put(this.myKeyEmulatorMemory, this.myRecommendedMemorySize);
        this.register(this.myKeyEmulatorMemory, this.myMemorySlider);
        this.register(this.myKeyEmulatorMemory, this.myMemorySize, new SpinnerBinding());
    }

    @Override
    @Nullable
    public JLabel getMessageLabel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMemorySlider;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JLabel jLabel;
        JSpinner jSpinner;
        JButton jButton2;
        JSlider jSlider;
        JPanel jPanel;
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html>We have detected that your system can run the Android emulator in an accelerated performance mode.</html>");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("<html>Please set the maximum amount of RAM available for the Intel\u00ae Hardware Accelerated Execution Manager (HAXM) to use for all x86 emulator instances. You can change these settings at any time by running the Intel\u00ae HAXM installer.</html>");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, new Dimension(700, -1), null));
        this.myMemorySlider = jSlider = new JSlider();
        jSlider.setPaintLabels(true);
        jSlider.setPaintTrack(true);
        jSlider.setMajorTickSpacing(32);
        jSlider.setValueIsAdjusting(false);
        jSlider.setMinorTickSpacing(0);
        jSlider.setPaintTicks(false);
        jSlider.setSnapToTicks(true);
        jSlider.setMaximum(512);
        jPanel.add((Component)jSlider, new GridConstraints(5, 0, 1, 1, 0, 1, 0, 6, null, null, new Dimension(750, -1)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Please refer to the ");
        Component component = jPanel2.add(jLabel4);
        this.myIntelHAXMDocumentationButton = jButton2 = new JButton();
        jButton2.setText("Intel\u00ae HAXM Documentation");
        Component component2 = jPanel2.add(jButton2);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(" for more information.");
        Component component3 = jPanel2.add(jLabel5);
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(6, 0, 1, 1, 4, 2, 0, 3, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("RAM allocation: ");
        jPanel3.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myMemorySize = jSpinner = new JSpinner();
        jPanel3.add((Component)jSpinner, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(100, -1), null));
        this.myUnitLabel = jLabel = new JLabel();
        jLabel.setText("MiB");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRecommended = jButton = new JButton();
        jButton.setText("Use recommended size");
        jPanel3.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private static class SpinnerBinding
    extends ScopedDataBinder.ComponentBinding<Integer, JSpinner> {
        private SpinnerBinding() {
        }

        @Override
        public void setValue(@Nullable Integer newValue, @NotNull JSpinner component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/welcome/MacEmulatorSettingsStep$SpinnerBinding", "setValue"));
            }
            component.setValue(newValue);
        }

        @Override
        @Nullable
        public Integer getValue(@NotNull JSpinner component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/welcome/MacEmulatorSettingsStep$SpinnerBinding", "getValue"));
            }
            return (Integer)component.getValue();
        }

        @Override
        public void addChangeListener(@NotNull ChangeListener listener, @NotNull JSpinner component) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/welcome/MacEmulatorSettingsStep$SpinnerBinding", "addChangeListener"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/welcome/MacEmulatorSettingsStep$SpinnerBinding", "addChangeListener"));
            }
            component.addChangeListener(listener);
        }
    }
}

