/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.welcome.FirstRunWizardStep;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkComponentsStep
extends FirstRunWizardStep {
    private static final ScopedStateStore.Key<BitSet> KEY_SELECTED_COMPONENTS = ScopedStateStore.createKey("selected.components", ScopedStateStore.Scope.STEP, BitSet.class);
    private final SdkComponent[] mySdkComponents;
    private final ScopedStateStore.Key<Boolean> myKeyShouldDownload;
    private JPanel myContents;
    private JBTable myComponentsTable;
    private JTextPane myComponentDescription;
    private JLabel myNeededSpace;
    private JLabel myAvailableSpace;
    private JLabel myErrorMessage;
    private JSplitPane mySplitPane;
    private Set<SdkComponent> myUncheckedComponents;
    private ScopedStateStore.Key<String> mySdkDownloadPathKey;
    private TextFieldWithBrowseButton myPath;
    private boolean myUserEditedPath;

    public SdkComponentsStep(ScopedStateStore.Key<Boolean> keyShouldDownload, ScopedStateStore.Key<String> sdkDownloadPathKey) {
        super("SDK Settings");
        this.$$$setupUI$$$();
        this.myUncheckedComponents = Sets.newHashSet();
        this.myUserEditedPath = false;
        this.myPath.addBrowseFolderListener("Android SDK", "Select Android SDK install directory", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myKeyShouldDownload = keyShouldDownload;
        this.mySdkDownloadPathKey = sdkDownloadPathKey;
        this.myComponentDescription.setEditable(false);
        this.myComponentDescription.setContentType("text/html");
        this.myComponentDescription.setBorder(new EmptyBorder(WizardConstants.STUDIO_WIZARD_INSETS));
        this.mySplitPane.setBorder(null);
        Font labelFont = UIUtil.getLabelFont();
        Font smallLabelFont = labelFont.deriveFont((float)labelFont.getSize() - 1.0f);
        this.myNeededSpace.setFont(smallLabelFont);
        this.myAvailableSpace.setFont(smallLabelFont);
        this.myErrorMessage.setText(null);
        this.myErrorMessage.setForeground((Color)JBColor.red);
        this.mySdkComponents = SdkComponentsStep.createModel();
        DefaultTableModel model = new DefaultTableModel(0, 1){

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                boolean isSelected = (Boolean)aValue;
                SdkComponent sdkComponent = SdkComponentsStep.this.mySdkComponents[row];
                if (isSelected) {
                    SdkComponentsStep.this.select(sdkComponent);
                } else {
                    SdkComponentsStep.this.deselect(sdkComponent);
                }
                this.fireTableRowsUpdated(row, row);
            }
        };
        for (SdkComponent sdkComponent : this.mySdkComponents) {
            model.addRow(new Object[]{sdkComponent});
        }
        this.myComponentsTable.setModel((TableModel)model);
        this.myComponentsTable.setTableHeader(null);
        this.myComponentsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selected = SdkComponentsStep.this.myComponentsTable.getSelectedRow();
                String description = selected >= 0 ? SdkComponentsStep.this.mySdkComponents[selected].myDescription : null;
                SdkComponentsStep.this.myComponentDescription.setText(description);
            }
        });
        TableColumn column = this.myComponentsTable.getColumnModel().getColumn(0);
        column.setCellRenderer(new SdkComponentRenderer());
        column.setCellEditor(new SdkComponentRenderer());
        this.setComponent(this.myContents);
    }

    private static SdkComponent[] createModel() {
        long mb = Storage.Unit.MiB.getNumberOfBytes();
        SdkComponent androidSdk = new SdkComponent("Android Studio + SDK", 684L * mb, null, false);
        SdkComponent sdkPlatform = new SdkComponent("Android SDK Platform", 0L, null, true);
        SdkComponent lmp = new SdkComponent("LMP - Android 5.0 (API 21)", 292L * mb, sdkPlatform, true);
        SdkComponent root = new SdkComponent("Android Emulator", 0L, null, true);
        SdkComponent nexus = new SdkComponent("Nexus", 0L, root, true);
        SdkComponent nexus5 = new SdkComponent("Nexus 5", 2499L * mb, nexus, true);
        SdkComponent performance = new SdkComponent("Performance", 0L, root, true);
        SdkComponent haxm = new SdkComponent("Intel\u00ae HAXM", 0x233333L, performance, true);
        return new SdkComponent[]{androidSdk, sdkPlatform, lmp, root, nexus, nexus5, performance, haxm};
    }

    private static boolean isChild(@Nullable SdkComponent child, @NotNull SdkComponent sdkComponent) {
        if (sdkComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkComponent", "com/android/tools/idea/welcome/SdkComponentsStep", "isChild"));
        }
        return child != null && (child == sdkComponent || SdkComponentsStep.isChild(child.myParent, sdkComponent));
    }

    @Nullable
    private static File getExistingParentFile(@Nullable String path) {
        File file;
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        for (file = new File(path).getAbsoluteFile(); file != null && !file.exists(); file = file.getParentFile()) {
        }
        return file;
    }

    private static String getDiskSpace(@Nullable String path) {
        File[] files;
        File file = SdkComponentsStep.getExistingParentFile(path);
        if (file == null && (files = File.listRoots()).length != 0) {
            file = files[0];
        }
        if (file == null) {
            return "";
        }
        String available = SdkComponentsStep.getSizeLabel(file.getFreeSpace());
        if (SystemInfo.isWindows) {
            while (file.getParent() != null) {
                file = file.getParentFile();
            }
            return String.format("Disk space available on rive %s: %s", file.getName(), available);
        }
        return String.format("Available disk space: %s", available);
    }

    private static String getSizeLabel(long freeSpace) {
        Storage.Unit[] values = Storage.Unit.values();
        Storage.Unit unit = values[values.length - 1];
        for (int i = values.length - 2; unit.getNumberOfBytes() > freeSpace && i >= 0; --i) {
            unit = values[i];
        }
        double space = (double)freeSpace * 1.0 / (double)unit.getNumberOfBytes();
        String formatted = SdkComponentsStep.roundToNumberOfDigits(space, 3);
        return String.format("%s %s", formatted, unit.toString());
    }

    private static String roundToNumberOfDigits(double number, int maxDigits) {
        int digits;
        int multiplier = 1;
        for (digits = maxDigits; digits > 0 && number > (double)multiplier; --digits) {
            multiplier *= 10;
        }
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setGroupingUsed(false);
        numberInstance.setRoundingMode(RoundingMode.HALF_UP);
        numberInstance.setMaximumFractionDigits(digits);
        return numberInstance.format(number);
    }

    @NotNull
    private static String inventDescription(String name, long size) {
        String string = String.format("<html><p>This is a description for <em>%s</em> component</p><p>We know is that it takes <strong>%s</strong> disk space</p></html>", name, SdkComponentsStep.getSizeLabel(size));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/SdkComponentsStep", "inventDescription"));
        }
        return string;
    }

    @Override
    public boolean validate() {
        String error = this.validatePath(this.myState.get(this.mySdkDownloadPathKey));
        this.setErrorHtml(this.myUserEditedPath ? error : null);
        return error == null;
    }

    @Nullable
    private String validatePath(@Nullable String path) {
        if (StringUtil.isEmpty((String)path)) {
            return "Path is empty";
        }
        this.myUserEditedPath = true;
        for (File file = new File(path); file != null && !file.exists(); file = file.getParentFile()) {
            if (PathUtil.isValidFileName((String)file.getName())) continue;
            return "Specified path is not valid";
        }
        return null;
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        this.myAvailableSpace.setText(SdkComponentsStep.getDiskSpace(this.myState.get(this.mySdkDownloadPathKey)));
        BitSet bitSet = this.myState.get(KEY_SELECTED_COMPONENTS);
        long selected = 0L;
        for (int i = 0; i < this.mySdkComponents.length; ++i) {
            if (bitSet != null && !bitSet.get(i)) continue;
            SdkComponent sdkComponent = this.mySdkComponents[i];
            selected += sdkComponent.mySize;
        }
        this.myNeededSpace.setText(String.format("Total disk space required: %s", SdkComponentsStep.getSizeLabel(selected)));
        super.deriveValues(modified);
    }

    private void deselect(SdkComponent sdkComponent) {
        for (SdkComponent child : this.mySdkComponents) {
            if (child.mySize <= 0L || !SdkComponentsStep.isChild(child, sdkComponent)) continue;
            this.myUncheckedComponents.add(child);
        }
    }

    private Iterable<SdkComponent> getChildren(final SdkComponent sdkComponent) {
        return Iterables.filter(Arrays.asList(this.mySdkComponents), (Predicate)new Predicate<SdkComponent>(){

            public boolean apply(@Nullable SdkComponent input) {
                assert (input != null);
                SdkComponent n = input;
                do {
                    if (n != sdkComponent) continue;
                    return true;
                } while ((n = n.myParent) != null);
                return false;
            }
        });
    }

    private void select(SdkComponent sdkComponent) {
        for (SdkComponent child : this.getChildren(sdkComponent)) {
            this.myUncheckedComponents.remove(child);
        }
    }

    @Override
    public void init() {
        this.register(this.mySdkDownloadPathKey, this.myPath);
        this.register(KEY_SELECTED_COMPONENTS, this.myComponentsTable, new ScopedDataBinder.ComponentBinding<BitSet, JBTable>(){

            @Override
            public void setValue(@Nullable BitSet newValue, @NotNull JBTable component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/welcome/SdkComponentsStep$4", "setValue"));
                }
                for (int i = 0; i < SdkComponentsStep.this.mySdkComponents.length; ++i) {
                    component.getModel().setValueAt(newValue == null || newValue.get(i), i, 0);
                }
            }

            @Override
            @Nullable
            public BitSet getValue(@NotNull JBTable component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/welcome/SdkComponentsStep$4", "getValue"));
                }
                BitSet bitSet = new BitSet(SdkComponentsStep.this.mySdkComponents.length);
                int i = 0;
                for (SdkComponent sdkComponent : SdkComponentsStep.this.mySdkComponents) {
                    bitSet.set(i++, sdkComponent.mySize > 0L && !SdkComponentsStep.this.myUncheckedComponents.contains(sdkComponent));
                }
                return bitSet;
            }

            @Override
            public void addActionListener(final @NotNull ActionListener listener, final @NotNull JBTable component) {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/welcome/SdkComponentsStep$4", "addActionListener"));
                }
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/welcome/SdkComponentsStep$4", "addActionListener"));
                }
                component.getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                        ActionEvent event = new ActionEvent(component, 1002, "toggle");
                        listener.actionPerformed(event);
                    }
                });
            }
        });
    }

    @Override
    @NotNull
    public JLabel getMessageLabel() {
        JLabel jLabel = this.myErrorMessage;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/SdkComponentsStep", "getMessageLabel"));
        }
        return jLabel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myComponentsTable;
    }

    private boolean isSelected(SdkComponent sdkComponent) {
        for (SdkComponent child : this.getChildren(sdkComponent)) {
            if (!this.myUncheckedComponents.contains(child)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isStepVisible() {
        return Objects.equal((Object)Boolean.TRUE, (Object)this.myState.get(this.myKeyShouldDownload));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextPane jTextPane;
        JBTable jBTable;
        JSplitPane jSplitPane;
        JPanel jPanel;
        this.myContents = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Select Android SDK components to install:");
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(320);
        jPanel.add((Component)jSplitPane, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 7, null, new Dimension(200, 200), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jSplitPane.setLeftComponent((Component)jBScrollPane);
        this.myComponentsTable = jBTable = new JBTable();
        jBScrollPane.setViewportView((Component)jBTable);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jSplitPane.setRightComponent((Component)jBScrollPane2);
        this.myComponentDescription = jTextPane = new JTextPane();
        jBScrollPane2.setViewportView(jTextPane);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Android SDK Install Location:");
        jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 1, 2, 1, 0, 3, 0, 3, null, null, null));
        this.myNeededSpace = jLabel3 = new JLabel();
        jLabel3.setText("Total disk space required: 5.1Gb");
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myAvailableSpace = jLabel2 = new JLabel();
        jLabel2.setText("Available disk space: 23.0Gb");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myErrorMessage = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContents;
    }

    private final class SdkComponentRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private final JPanel myPanel = new JPanel((LayoutManager)new GridLayoutManager(1, 1));
        private final JCheckBox myCheckBox = new JCheckBox();
        private Border myEmptyBorder;

        public SdkComponentRenderer() {
            this.myCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SdkComponentRenderer.this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setupControl(table, value, isSelected, hasFocus);
            return this.myPanel;
        }

        private void setupControl(JTable table, Object value, boolean isSelected, boolean hasFocus) {
            Color foreground;
            this.myPanel.setBorder(this.getCellBorder(table, isSelected && hasFocus));
            if (isSelected) {
                this.myPanel.setBackground(table.getSelectionBackground());
                foreground = table.getSelectionForeground();
            } else {
                this.myPanel.setBackground(table.getBackground());
                foreground = table.getForeground();
            }
            this.myCheckBox.setForeground(foreground);
            this.myPanel.remove(this.myCheckBox);
            SdkComponent sdkComponent = (SdkComponent)value;
            int indent = 0;
            if (sdkComponent != null) {
                this.myCheckBox.setEnabled(sdkComponent.myCanDeselect);
                this.myCheckBox.setText(sdkComponent.getLabel());
                this.myCheckBox.setSelected(SdkComponentsStep.this.isSelected((SdkComponent)value));
                while (sdkComponent.myParent != null) {
                    ++indent;
                    sdkComponent = sdkComponent.myParent;
                    assert (sdkComponent != null);
                }
            }
            this.myPanel.add((Component)this.myCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, indent * 2));
        }

        private Border getCellBorder(JTable table, boolean isSelectedFocus) {
            Border border;
            Border focusedBorder = UIUtil.getTableFocusCellHighlightBorder();
            if (isSelectedFocus) {
                border = focusedBorder;
            } else {
                if (this.myEmptyBorder == null) {
                    this.myEmptyBorder = new EmptyBorder(focusedBorder.getBorderInsets(table));
                }
                border = this.myEmptyBorder;
            }
            return border;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.setupControl(table, value, true, true);
            return this.myPanel;
        }

        @Override
        public Object getCellEditorValue() {
            return this.myCheckBox.isSelected();
        }
    }

    private static final class SdkComponent {
        @NotNull
        private final String myName;
        private final long mySize;
        @Nullable
        private final SdkComponent myParent;
        private final boolean myCanDeselect;
        private final String myDescription;

        /*
         * WARNING - void declaration
         */
        public SdkComponent(@NotNull String name, long size, @Nullable SdkComponent parent, boolean bl) {
            void canDeselect;
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/welcome/SdkComponentsStep$SdkComponent", "<init>"));
            }
            this(name, size, parent, (boolean)canDeselect, SdkComponentsStep.inventDescription(name, size));
        }

        /*
         * WARNING - void declaration
         */
        public SdkComponent(@NotNull String name, long size, @Nullable SdkComponent parent, boolean canDeselect, @NotNull String string) {
            void description;
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/welcome/SdkComponentsStep$SdkComponent", "<init>"));
            }
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canDeselect", "com/android/tools/idea/welcome/SdkComponentsStep$SdkComponent", "<init>"));
            }
            this.myName = name;
            this.mySize = size;
            this.myParent = parent;
            this.myCanDeselect = canDeselect;
            this.myDescription = description;
        }

        public String toString() {
            return this.myName;
        }

        public String getLabel() {
            return this.mySize == 0L ? this.myName : String.format("%s \u2013 (%s)", this.myName, SdkComponentsStep.getSizeLabel(this.mySize));
        }
    }
}

