/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.DynamicWizardStep;
import com.android.tools.idea.wizard.ImportUIUtil;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicWizardStepWithHeaderAndDescription
extends DynamicWizardStep
implements Disposable {
    protected static final ScopedStateStore.Key<String> KEY_DESCRIPTION = ScopedStateStore.createKey(DynamicWizardStepWithHeaderAndDescription.class + ".description", ScopedStateStore.Scope.STEP, String.class);
    protected static final ScopedStateStore.Key<String> KEY_TITLE = ScopedStateStore.createKey(DynamicWizardStepWithHeaderAndDescription.class + ".title", ScopedStateStore.Scope.STEP, String.class);
    protected static final ScopedStateStore.Key<String> KEY_MESSAGE = ScopedStateStore.createKey(DynamicWizardStepWithHeaderAndDescription.class + ".message", ScopedStateStore.Scope.STEP, String.class);
    private static final String PROPERTY_FOCUS_OWNER = "focusOwner";
    @NotNull
    private final String myTitle;
    @Nullable
    private final String myMessage;
    @Nullable
    private final Disposable myDisposable;
    private PropertyChangeListener myFocusListener;
    private JPanel myRootPane;
    private JBLabel myTitleLabel;
    private JBLabel myMessageLabel;
    private JBLabel myIcon;
    private JLabel myDescriptionText;
    private JBLabel myErrorWarningLabel;
    private JPanel myNorthPanel;
    private JPanel myCustomHeaderPanel;
    private JPanel myTitlePanel;
    private JPanel mySouthPanel;
    private Map<Component, String> myControlDescriptions;

    @Deprecated
    public DynamicWizardStepWithHeaderAndDescription(@NotNull String title, @Nullable String message, @Nullable Icon icon) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription", "<init>"));
        }
        this(title, message, icon, Disposer.newDisposable());
    }

    public DynamicWizardStepWithHeaderAndDescription(@NotNull String title, @Nullable String message, @Nullable Icon icon, @Nullable Disposable parentDisposable) {
        JComponent header;
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myControlDescriptions = new WeakHashMap<Component, String>();
        this.myDisposable = parentDisposable;
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
        this.myTitle = title;
        this.myMessage = message;
        this.myIcon.setIcon(icon);
        int fontHeight = this.myMessageLabel.getFont().getSize();
        this.myTitleLabel.setBorder(BorderFactory.createEmptyBorder(fontHeight, 0, fontHeight, 0));
        this.mySouthPanel.setBorder(new EmptyBorder(WizardConstants.STUDIO_WIZARD_INSETS));
        if (this.getTitleBackgroundColor() != null) {
            this.myTitlePanel.setBackground((Color)this.getTitleBackgroundColor());
            this.myNorthPanel.setBackground((Color)this.getTitleBackgroundColor());
        }
        if (this.getTitleTextColor() != null) {
            this.myTitleLabel.setForeground((Color)this.getTitleTextColor());
            this.myMessageLabel.setForeground((Color)this.getTitleTextColor());
        }
        if ((header = this.getHeader()) != null) {
            this.myCustomHeaderPanel.add((Component)header, "Center");
            this.myCustomHeaderPanel.setVisible(true);
            this.myCustomHeaderPanel.repaint();
            this.myTitlePanel.setBorder(new EmptyBorder(WizardConstants.STUDIO_WIZARD_INSETS));
        } else {
            Insets topSegmentInsets = new Insets(18, WizardConstants.STUDIO_WIZARD_INSETS.left, WizardConstants.STUDIO_WIZARD_INSETS.bottom, WizardConstants.STUDIO_WIZARD_INSETS.right);
            this.myNorthPanel.setBorder(new EmptyBorder(topSegmentInsets));
        }
        Font font = this.myTitleLabel.getFont();
        if (font == null) {
            font = UIUtil.getLabelFont();
        }
        font = new Font(font.getName(), font.getStyle() | 1, font.getSize() + 4);
        this.myTitleLabel.setFont(font);
        this.myErrorWarningLabel.setForeground((Color)JBColor.red);
    }

    protected static CompoundBorder createBodyBorder() {
        int fontSize = UIUtil.getLabelFont().getSize();
        Border insetBorder = BorderFactory.createEmptyBorder(fontSize * 4, fontSize * 2, fontSize * 4, fontSize * 2);
        return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIUtil.getBorderColor()), insetBorder);
    }

    protected void setControlDescription(Component control, @Nullable String description) {
        if (this.myFocusListener == null) {
            this.myFocusListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() instanceof Component) {
                        DynamicWizardStepWithHeaderAndDescription.this.updateDescription((Component)evt.getNewValue());
                    }
                }
            };
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(PROPERTY_FOCUS_OWNER, this.myFocusListener);
        }
        if (StringUtil.isEmpty((String)description)) {
            this.myControlDescriptions.remove(control);
        } else {
            this.myControlDescriptions.put(control, description);
        }
    }

    private String getDescriptionText(Component component) {
        while (component instanceof Component && !this.myControlDescriptions.containsKey(component)) {
            component = component.getParent();
        }
        return component != null ? this.myControlDescriptions.get(component) : "";
    }

    private void updateDescription(Component focusedComponent) {
        this.myState.put(KEY_DESCRIPTION, this.getDescriptionText(focusedComponent));
    }

    public void dispose() {
        if (this.myFocusListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(PROPERTY_FOCUS_OWNER, this.myFocusListener);
        }
    }

    protected final void setBodyComponent(JComponent component) {
        component.setBorder(new EmptyBorder(WizardConstants.STUDIO_WIZARD_INSETS));
        this.myRootPane.add((Component)component, "Center");
    }

    @NotNull
    protected String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription", "getTitle"));
        }
        return string;
    }

    @Override
    public void init() {
        this.myState.put(KEY_TITLE, this.myTitle);
        this.myState.put(KEY_MESSAGE, this.myMessage);
        this.register(KEY_DESCRIPTION, this.getDescriptionText(), new ScopedDataBinder.ComponentBinding<String, JLabel>(){

            @Override
            public void setValue(String newValue, @NotNull JLabel component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$2", "setValue"));
                }
                DynamicWizardStepWithHeaderAndDescription.this.setDescriptionText(newValue);
            }
        });
        this.register(KEY_TITLE, this.myTitleLabel, new ScopedDataBinder.ComponentBinding<String, JBLabel>(){

            @Override
            public void setValue(@Nullable String newValue, @NotNull JBLabel component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$3", "setValue"));
                }
                component.setText(newValue);
            }
        });
        this.register(KEY_MESSAGE, this.myMessageLabel, new ScopedDataBinder.ComponentBinding<String, JLabel>(){

            @Override
            public void setValue(@Nullable String newValue, @NotNull JLabel component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription$4", "setValue"));
                }
                component.setVisible(!StringUtil.isEmpty((String)newValue));
                component.setText(ImportUIUtil.makeHtmlString(newValue));
            }
        });
    }

    protected JLabel getDescriptionText() {
        return this.myDescriptionText;
    }

    protected final void setDescriptionText(@Nullable String templateDescription) {
        this.getDescriptionText().setText(ImportUIUtil.makeHtmlString(templateDescription));
    }

    @Nullable
    protected JBColor getTitleBackgroundColor() {
        return null;
    }

    @Nullable
    protected JBColor getTitleTextColor() {
        return null;
    }

    @Nullable
    protected JComponent getHeader() {
        return null;
    }

    @Override
    @NotNull
    public final JComponent getComponent() {
        JPanel jPanel = this.myRootPane;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    public final JBLabel getMessageLabel() {
        JBLabel jBLabel = this.myErrorWarningLabel;
        if (jBLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStepWithHeaderAndDescription", "getMessageLabel"));
        }
        return jBLabel;
    }

    @Nullable
    protected Disposable getDisposable() {
        return this.myDisposable;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JLabel jLabel;
        JPanel jPanel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myRootPane = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        this.myNorthPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, "North");
        this.myCustomHeaderPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel3).setVisible(false);
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, new Dimension(-1, 100), new Dimension(-1, 100), new Dimension(-1, 100)));
        this.myTitlePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 3, 1, 0, 3, 3, 3, null, null, null));
        this.myTitleLabel = jBLabel4 = new JBLabel();
        jBLabel4.setHorizontalAlignment(10);
        jBLabel4.setText("Wizard Step Title");
        jPanel2.add((Component)jBLabel4, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        this.myMessageLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Wizard step description message");
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 0, 3, 1, 1, 0, 1, 6, new Dimension(-1, 100), new Dimension(-1, 100), new Dimension(-1, 100)));
        this.myIcon = jBLabel2 = new JBLabel();
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 2, 2, 1, 0, 0, 0, 0, null, null, null));
        this.mySouthPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, "South");
        this.myDescriptionText = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myErrorWarningLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPane;
    }
}

