/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.grid;

import com.android.tools.idea.designer.ResizeOperation;
import com.intellij.android.designer.designSurface.TreeDropToOperation;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.graphics.ResizeSelectionDecorator;
import com.intellij.android.designer.designSurface.layout.GridLayoutOperation;
import com.intellij.android.designer.designSurface.layout.actions.GridLayoutSpanOperation;
import com.intellij.android.designer.designSurface.layout.caption.GridHorizontalCaptionOperation;
import com.intellij.android.designer.designSurface.layout.caption.GridVerticalCaptionOperation;
import com.intellij.android.designer.designSurface.layout.grid.GridDecorator;
import com.intellij.android.designer.designSurface.layout.grid.GridSelectionDecorator;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.RadViewLayout;
import com.intellij.android.designer.model.RadViewLayoutWithData;
import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.layout.actions.AllGravityAction;
import com.intellij.android.designer.model.layout.actions.OrientationAction;
import com.intellij.android.designer.model.layout.grid.RadCaptionGridColumn;
import com.intellij.android.designer.model.layout.grid.RadCaptionGridRow;
import com.intellij.android.designer.model.layout.grid.RadGridLayoutComponent;
import com.intellij.designer.componentTree.TreeEditOperation;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.ICaption;
import com.intellij.designer.designSurface.ICaptionDecorator;
import com.intellij.designer.designSurface.ILayoutDecorator;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.StaticDecorator;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadLayout;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RadGridLayout
extends RadViewLayoutWithData
implements ILayoutDecorator,
ICaption,
ICaptionDecorator {
    private static final String[] LAYOUT_PARAMS = new String[]{"GridLayout_Layout", "ViewGroup_MarginLayout"};
    private GridDecorator myGridDecorator;
    private GridSelectionDecorator mySelectionDecorator;
    private RadLayout myCaptionColumnLayout;
    private RadLayout myCaptionRowLayout;

    @Override
    @NotNull
    public String[] getLayoutParams() {
        if (LAYOUT_PARAMS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/grid/RadGridLayout", "getLayoutParams"));
        }
        return LAYOUT_PARAMS;
    }

    public EditOperation processChildOperation(OperationContext context) {
        if (context.isCreate() || context.isPaste() || context.isAdd() || context.isMove()) {
            if (context.isTree()) {
                if (TreeEditOperation.isTarget((RadComponent)this.myContainer, (OperationContext)context)) {
                    return new TreeDropToOperation(this.myContainer, context);
                }
                return null;
            }
            return new GridLayoutOperation(this.myContainer, context);
        }
        if (context.is((Object)"resize_children")) {
            return new ResizeOperation(context);
        }
        if (context.is((Object)"layout_span")) {
            return new GridLayoutSpanOperation(context, this.mySelectionDecorator);
        }
        return null;
    }

    private StaticDecorator getGridDecorator() {
        if (this.myGridDecorator == null) {
            this.myGridDecorator = new GridDecorator(this.myContainer);
        }
        return this.myGridDecorator;
    }

    @Override
    public void addStaticDecorators(List<StaticDecorator> decorators, List<RadComponent> selection) {
        if (selection.contains(this.myContainer)) {
            if (!(this.myContainer.getParent().getLayout() instanceof ILayoutDecorator)) {
                decorators.add(this.getGridDecorator());
            }
        } else {
            for (RadComponent component : selection) {
                if (component.getParent() != this.myContainer) continue;
                decorators.add(this.getGridDecorator());
                return;
            }
            super.addStaticDecorators(decorators, selection);
        }
    }

    @Override
    public ComponentDecorator getChildSelectionDecorator(RadComponent component, List<RadComponent> selection) {
        if (this.mySelectionDecorator == null) {
            this.mySelectionDecorator = new GridSelectionDecorator(DrawingStyle.SELECTION){

                @Override
                public Rectangle getCellBounds(Component layer, RadComponent component) {
                    try {
                        RadGridLayoutComponent parent = (RadGridLayoutComponent)component.getParent();
                        GridInfo gridInfo = parent.getGridInfo();
                        Rectangle cellInfo = RadGridLayoutComponent.getCellInfo(component);
                        return 1.calculateBounds(layer, gridInfo, (RadComponent)parent, component, cellInfo.y, cellInfo.x, cellInfo.height, cellInfo.width);
                    }
                    catch (Throwable e) {
                        return new Rectangle();
                    }
                }
            };
        }
        this.mySelectionDecorator.clear();
        if (selection.size() == 1) {
            GridLayoutSpanOperation.points(this.mySelectionDecorator);
            ResizeOperation.addResizePoints((ResizeSelectionDecorator)this.mySelectionDecorator, (RadViewComponent)selection.get(0));
        } else {
            ResizeOperation.addResizePoints(this.mySelectionDecorator);
        }
        return this.mySelectionDecorator;
    }

    @Override
    public void addContainerSelectionActions(DesignerEditorPanel designer, DefaultActionGroup actionGroup, List<? extends RadViewComponent> selection) {
        super.addContainerSelectionActions(designer, actionGroup, selection);
        actionGroup.add((AnAction)new OrientationAction(designer, (RadViewComponent)this.myContainer, true));
        actionGroup.add((AnAction)new AllGravityAction(designer, selection));
    }

    public ICaption getCaption(RadComponent component) {
        if (this.myContainer == component && this.myContainer.getParent().getLayout() instanceof ICaptionDecorator) {
            return null;
        }
        if (this.myContainer.getChildren().isEmpty()) {
            return null;
        }
        return this;
    }

    @NotNull
    public List<RadComponent> getCaptionChildren(EditableArea mainArea, boolean horizontal) {
        RadGridLayoutComponent container = this.getGridComponent();
        GridInfo gridInfo = container.getGridInfo();
        ArrayList<RadComponent> components = new ArrayList<RadComponent>();
        if (horizontal) {
            int[] lines = gridInfo.vLines;
            boolean[] emptyColumns = gridInfo.emptyColumns;
            for (int i = 0; i < lines.length - 1; ++i) {
                components.add((RadComponent)new RadCaptionGridColumn(mainArea, container, i, lines[i], lines[i + 1] - lines[i], emptyColumns[i]));
            }
        } else {
            int[] lines = gridInfo.hLines;
            boolean[] emptyRows = gridInfo.emptyRows;
            for (int i = 0; i < lines.length - 1; ++i) {
                components.add((RadComponent)new RadCaptionGridRow(mainArea, container, i, lines[i], lines[i + 1] - lines[i], emptyRows[i]));
            }
        }
        ArrayList<RadComponent> arrayList = components;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/grid/RadGridLayout", "getCaptionChildren"));
        }
        return arrayList;
    }

    private RadGridLayoutComponent getGridComponent() {
        return (RadGridLayoutComponent)this.myContainer;
    }

    @NotNull
    public RadLayout getCaptionLayout(final EditableArea mainArea, boolean horizontal) {
        if (horizontal) {
            if (this.myCaptionColumnLayout == null) {
                this.myCaptionColumnLayout = new RadViewLayout(){

                    public EditOperation processChildOperation(OperationContext context) {
                        if (context.isMove()) {
                            return new GridHorizontalCaptionOperation(RadGridLayout.this.getGridComponent(), this.myContainer, context, mainArea);
                        }
                        return null;
                    }
                };
            }
            RadLayout radLayout = this.myCaptionColumnLayout;
            if (radLayout == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/grid/RadGridLayout", "getCaptionLayout"));
            }
            return radLayout;
        }
        if (this.myCaptionRowLayout == null) {
            this.myCaptionRowLayout = new RadViewLayout(){

                public EditOperation processChildOperation(OperationContext context) {
                    if (context.isMove()) {
                        return new GridVerticalCaptionOperation(RadGridLayout.this.getGridComponent(), this.myContainer, context, mainArea);
                    }
                    return null;
                }
            };
        }
        RadLayout radLayout = this.myCaptionRowLayout;
        if (radLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/grid/RadGridLayout", "getCaptionLayout"));
        }
        return radLayout;
    }
}

