/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.IdeaSVNConfigFile;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.commandLine.BaseCommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNURL;

public class ProxyModule
extends BaseCommandRuntimeModule {
    private static final Logger LOG = Logger.getInstance(ProxyModule.class);

    public ProxyModule(@NotNull CommandRuntime runtime) {
        if (runtime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtime", "org/jetbrains/idea/svn/commandLine/ProxyModule", "<init>"));
        }
        super(runtime);
    }

    @Override
    public void onStart(@NotNull Command command) throws SvnBindException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/ProxyModule", "onStart"));
        }
        if (this.myAuthenticationService.haveDataForTmpConfig()) {
            this.setupProxy(command);
        }
    }

    private void setupProxy(@NotNull Command command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/ProxyModule", "setupProxy"));
        }
        SVNURL repositoryUrl = command.getRepositoryUrl();
        if (repositoryUrl != null) {
            Proxy proxy = AuthenticationService.getIdeaDefinedProxy(repositoryUrl);
            if (proxy != null) {
                String hostGroup = this.ensureGroupForHost(command, repositoryUrl.getHost());
                InetSocketAddress address = (InetSocketAddress)proxy.address();
                command.put("--config-option");
                command.put(String.format("servers:%s:http-proxy-host=%s", hostGroup, address.getHostName()));
                command.put("--config-option");
                command.put(String.format("servers:%s:http-proxy-port=%s", hostGroup, address.getPort()));
            }
        } else {
            LOG.info("Configured proxy should be used, but repository url is null for command - " + command.getText());
        }
    }

    @NotNull
    private String ensureGroupForHost(@NotNull Command command, @NotNull String host) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/ProxyModule", "ensureGroupForHost"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/idea/svn/commandLine/ProxyModule", "ensureGroupForHost"));
        }
        IdeaSVNConfigFile configFile = new IdeaSVNConfigFile(this.myAuthenticationService.getSpecialConfigDir());
        String groupName = SvnAuthenticationManager.getGroupForHost(host, configFile);
        if (StringUtil.isEmptyOrSpaces((String)groupName)) {
            groupName = IdeaSVNConfigFile.getNewGroupName(host, configFile);
            command.put("--config-option");
            command.put(String.format("servers:groups:%s=%s*", groupName, host));
        }
        String string = groupName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/ProxyModule", "ensureGroupForHost"));
        }
        return string;
    }
}

