/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import org.w3c.dom.Attr;

public class PrivateResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("PrivateResource", "Using private resources", "Private resources should not be referenced; the may not be present everywhere, and even where they are they may disappear without notice.\n\nTo fix this, copy the resource into your own project. You can find the platform resources under `$ANDROID_SK/platforms/android-$VERSION/data/res/.`", Category.CORRECTNESS, 3, Severity.FATAL, new Implementation(PrivateResourceDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        String value = attribute.getNodeValue();
        if (value.startsWith("@*android:")) {
            context.report(ISSUE, attribute, context.getLocation(attribute), "Illegal resource reference: `@*android` resources are private and not always present");
        }
    }
}

