/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit.TestsPattern;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class PatternConfigurationProducer
extends JUnitConfigurationProducer {
    protected boolean setupConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PsiElement[] elements = PatternConfigurationProducer.collectPatternElements(context, classes);
        if (classes.size() <= 1) {
            return false;
        }
        sourceElement.set((Object)elements[0]);
        JUnitConfiguration.Data data = configuration.getPersistentData();
        data.setPatterns(classes);
        data.TEST_OBJECT = "pattern";
        data.setScope(this.setupPackageConfiguration(context, configuration, data.getScope()));
        configuration.setGeneratedName();
        return true;
    }

    protected Module findModule(JUnitConfiguration configuration, Module contextModule) {
        Set<String> patterns = configuration.getPersistentData().getPatterns();
        return PatternConfigurationProducer.findModule(configuration, contextModule, patterns);
    }

    public static Module findModule(ModuleBasedConfiguration configuration, Module contextModule, Set<String> patterns) {
        return JavaExecutionUtil.findModule((Module)contextModule, patterns, (Project)configuration.getProject(), (Condition)new Condition<PsiClass>(){

            public boolean value(PsiClass psiClass) {
                return JUnitUtil.isTestClass((PsiClass)psiClass);
            }
        });
    }

    static Set<PsiElement> collectTestMembers(PsiElement[] psiElements, boolean checkAbstract) {
        LinkedHashSet<PsiElement> foundMembers = new LinkedHashSet<PsiElement>();
        for (PsiElement psiElement : psiElements) {
            PsiPackage aPackage;
            if (psiElement instanceof PsiClassOwner) {
                PsiClass[] classes;
                for (PsiClass aClass : classes = ((PsiClassOwner)psiElement).getClasses()) {
                    if (!JUnitUtil.isTestClass((PsiClass)aClass)) continue;
                    foundMembers.add((PsiElement)aClass);
                }
                continue;
            }
            if (psiElement instanceof PsiClass) {
                if (!JUnitUtil.isTestClass((PsiClass)((PsiClass)psiElement))) continue;
                foundMembers.add(psiElement);
                continue;
            }
            if (psiElement instanceof PsiMethod) {
                if (JUnitUtil.getTestMethod((PsiElement)psiElement, (boolean)checkAbstract) == null) continue;
                foundMembers.add(psiElement);
                continue;
            }
            if (!(psiElement instanceof PsiDirectory) || (aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement)) == null) continue;
            foundMembers.add((PsiElement)aPackage);
        }
        return foundMembers;
    }

    public static boolean isMultipleElementsSelected(ConfigurationContext context) {
        if (TestsUIUtil.isMultipleSelectionImpossible((DataContext)context.getDataContext())) {
            return false;
        }
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PsiElement[] elements = PatternConfigurationProducer.collectPatternElements(context, classes);
        return elements != null && PatternConfigurationProducer.collectTestMembers(elements, false).size() > 1;
    }

    private static PsiElement[] collectPatternElements(ConfigurationContext context, LinkedHashSet<String> classes) {
        DataContext dataContext = context.getDataContext();
        Location[] locations = (Location[])Location.DATA_KEYS.getData(dataContext);
        if (locations != null) {
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            for (Location location : locations) {
                PsiElement psiElement = location.getPsiElement();
                classes.add(PatternConfigurationProducer.getQName(psiElement, location));
                elements.add(psiElement);
            }
            return elements.toArray(new PsiElement[elements.size()]);
        }
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (elements != null) {
            for (PsiElement psiClass : PatternConfigurationProducer.collectTestMembers(elements, true)) {
                classes.add(PatternConfigurationProducer.getQName(psiClass));
            }
            return elements;
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (files != null) {
            ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
            PsiManager psiManager = PsiManager.getInstance((Project)context.getProject());
            for (VirtualFile file : files) {
                PsiFile psiFile = psiManager.findFile(file);
                if (!(psiFile instanceof PsiClassOwner)) continue;
                for (PsiElement psiMember : PatternConfigurationProducer.collectTestMembers((PsiElement[])((PsiClassOwner)psiFile).getClasses(), true)) {
                    classes.add(((PsiClass)psiMember).getQualifiedName());
                }
                psiFiles.add(psiFile);
            }
            return psiFiles.toArray(new PsiElement[psiFiles.size()]);
        }
        return null;
    }

    public static String getQName(PsiElement psiMember) {
        return PatternConfigurationProducer.getQName(psiMember, null);
    }

    public static String getQName(PsiElement psiMember, Location location) {
        if (psiMember instanceof PsiClass) {
            return ((PsiClass)psiMember).getQualifiedName();
        }
        if (psiMember instanceof PsiMember) {
            PsiClass containingClass;
            PsiClass psiClass = containingClass = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : ((PsiMember)psiMember).getContainingClass();
            assert (containingClass != null);
            return containingClass.getQualifiedName() + "," + ((PsiMember)psiMember).getName();
        }
        if (psiMember instanceof PsiPackage) {
            return ((PsiPackage)psiMember).getQualifiedName();
        }
        assert (false);
        return null;
    }

    @Override
    public boolean isConfigurationFromContext(JUnitConfiguration unitConfiguration, ConfigurationContext context) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PatternConfigurationProducer.collectPatternElements(context, classes);
        TestObject testobject = unitConfiguration.getTestObject();
        return testobject instanceof TestsPattern && Comparing.equal(classes, unitConfiguration.getPersistentData().getPatterns());
    }
}

