/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser;

import com.android.tools.idea.gradle.output.GradleMessage;
import com.android.tools.idea.gradle.output.parser.OutputLineReader;
import com.android.tools.idea.gradle.output.parser.ParsingFailedException;
import com.android.tools.idea.gradle.output.parser.PatternAwareOutputParser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BuildOutputParser {
    private Iterable<? extends PatternAwareOutputParser> myParsers;

    public BuildOutputParser(Iterable<? extends PatternAwareOutputParser> parsers) {
        this.myParsers = parsers;
    }

    @NotNull
    public List<GradleMessage> parseGradleOutput(@NotNull String output) {
        String line;
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/android/tools/idea/gradle/output/parser/BuildOutputParser", "parseGradleOutput"));
        }
        OutputLineReader outputReader = new OutputLineReader(output);
        if (outputReader.getLineCount() == 0) {
            List<GradleMessage> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/parser/BuildOutputParser", "parseGradleOutput"));
            }
            return list;
        }
        ArrayList messages = Lists.newArrayList();
        while ((line = outputReader.readLine()) != null) {
            if (line.isEmpty()) continue;
            boolean handled = false;
            for (PatternAwareOutputParser patternAwareOutputParser : this.myParsers) {
                try {
                    if (!patternAwareOutputParser.parse(line, outputReader, messages)) continue;
                    handled = true;
                    break;
                }
                catch (ParsingFailedException e) {
                    List<GradleMessage> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/parser/BuildOutputParser", "parseGradleOutput"));
                    }
                    return list;
                }
            }
            if (handled) continue;
            messages.add(new GradleMessage(GradleMessage.Kind.SIMPLE, line));
        }
        ArrayList arrayList = messages;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/output/parser/BuildOutputParser", "parseGradleOutput"));
        }
        return arrayList;
    }
}

