/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogProvider;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitVcs;
import git4idea.cherrypick.GitCherryPicker;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import icons.Git4ideaIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitCherryPickAction
extends DumbAwareAction {
    private static final String NAME = "Cherry-Pick";
    private static final Logger LOG = Logger.getInstance(GitCherryPickAction.class);
    @NotNull
    private final GitPlatformFacade myPlatformFacade;
    @NotNull
    private final Git myGit = (Git)ServiceManager.getService(Git.class);
    @NotNull
    private final Set<Hash> myIdsInProgress;

    public GitCherryPickAction() {
        super(NAME, null, Git4ideaIcons.CherryPick);
        this.myPlatformFacade = (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class);
        this.myIdsInProgress = ContainerUtil.newHashSet();
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        final List commits = log.getSelectedDetails();
        for (VcsFullCommitDetails commit : commits) {
            this.myIdsInProgress.add((Hash)commit.getId());
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        this.myPlatformFacade.getChangeListManager(project).blockModalNotifications();
        new Task.Backgroundable(project, "Cherry-picking", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/cherrypick/GitCherryPickAction$1", "run"));
                }
                try {
                    Map commitsInRoots = GitCherryPickAction.sortCommits(GitCherryPickAction.this.groupCommitsByRoots(project, commits));
                    new GitCherryPicker(project, GitCherryPickAction.this.myGit, GitCherryPickAction.this.myPlatformFacade, GitCherryPickAction.isAutoCommit(project)).cherryPick(commitsInRoots);
                }
                catch (Throwable throwable) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitCherryPickAction.this.myPlatformFacade.getChangeListManager(project).unblockModalNotifications();
                            for (VcsFullCommitDetails commit : commits) {
                                GitCherryPickAction.this.myIdsInProgress.remove(commit.getId());
                            }
                        }
                    });
                    throw throwable;
                }
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }.queue();
    }

    @NotNull
    private static Map<GitRepository, List<VcsFullCommitDetails>> sortCommits(Map<GitRepository, List<VcsFullCommitDetails>> groupedCommits) {
        for (List<VcsFullCommitDetails> gitCommits : groupedCommits.values()) {
            Collections.reverse(gitCommits);
        }
        Map<GitRepository, List<VcsFullCommitDetails>> map = groupedCommits;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPickAction", "sortCommits"));
        }
        return map;
    }

    @NotNull
    private Map<GitRepository, List<VcsFullCommitDetails>> groupCommitsByRoots(@NotNull Project project, @NotNull List<? extends VcsFullCommitDetails> commits) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/cherrypick/GitCherryPickAction", "groupCommitsByRoots"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/cherrypick/GitCherryPickAction", "groupCommitsByRoots"));
        }
        HashMap groupedCommits = ContainerUtil.newHashMap();
        for (VcsFullCommitDetails vcsFullCommitDetails : commits) {
            GitRepository repository = (GitRepository)this.myPlatformFacade.getRepositoryManager(project).getRepositoryForRoot(vcsFullCommitDetails.getRoot());
            if (repository == null) {
                LOG.info("No repository found for commit " + vcsFullCommitDetails);
                continue;
            }
            List commitsInRoot = (List)groupedCommits.get(repository);
            if (commitsInRoot == null) {
                commitsInRoot = ContainerUtil.newArrayList();
                groupedCommits.put(repository, commitsInRoot);
            }
            commitsInRoot.add(vcsFullCommitDetails);
        }
        HashMap hashMap = groupedCommits;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPickAction", "groupCommitsByRoots"));
        }
        return hashMap;
    }

    private static boolean isAutoCommit(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/cherrypick/GitCherryPickAction", "isAutoCommit"));
        }
        return GitVcsSettings.getInstance(project).isAutoCommitOnCherryPick();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/cherrypick/GitCherryPickAction", "update"));
        }
        super.update(e);
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        Project project = GitCherryPickAction.getEventProject((AnActionEvent)e);
        if (project == null || log == null || !GitCherryPickAction.logHasGitRoots(log)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List details = log.getSelectedDetails();
        if (this.notFromGitAndProject(project, details)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabled(this.enabled(project, log, details));
        e.getPresentation().setText(GitCherryPickAction.isAutoCommit(project) ? NAME : "Cherry-Pick...");
    }

    public static boolean logHasGitRoots(@NotNull VcsLog log) {
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "git4idea/cherrypick/GitCherryPickAction", "logHasGitRoots"));
        }
        return ContainerUtil.find((Iterable)log.getLogProviders(), (Condition)new Condition<VcsLogProvider>(){

            public boolean value(VcsLogProvider logProvider) {
                return logProvider.getSupportedVcs().equals((Object)GitVcs.getKey());
            }
        }) != null;
    }

    private boolean notFromGitAndProject(@NotNull Project project, @NotNull List<VcsFullCommitDetails> details) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/cherrypick/GitCherryPickAction", "notFromGitAndProject"));
        }
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "git4idea/cherrypick/GitCherryPickAction", "notFromGitAndProject"));
        }
        final Object manager = this.myPlatformFacade.getRepositoryManager(project);
        return ContainerUtil.and(details, (Condition)new Condition<VcsFullCommitDetails>(){

            public boolean value(VcsFullCommitDetails commit) {
                GitRepository repository = (GitRepository)manager.getRepositoryForRoot(commit.getRoot());
                return repository != null && manager.isExternal((Repository)repository);
            }
        });
    }

    private boolean enabled(@NotNull Project project, @NotNull VcsLog log, @NotNull List<VcsFullCommitDetails> commits) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/cherrypick/GitCherryPickAction", "enabled"));
        }
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "git4idea/cherrypick/GitCherryPickAction", "enabled"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/cherrypick/GitCherryPickAction", "enabled"));
        }
        if (commits.isEmpty()) {
            return false;
        }
        for (VcsFullCommitDetails commit : commits) {
            if (this.myIdsInProgress.contains(commit.getId())) {
                return false;
            }
            GitRepository repository = (GitRepository)this.myPlatformFacade.getRepositoryManager(project).getRepositoryForRoot(commit.getRoot());
            if (repository == null) {
                return false;
            }
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            Collection containingBranches = log.getContainingBranches((Hash)commit.getId());
            if (currentBranch == null || containingBranches == null || !containingBranches.contains(currentBranch.getName())) continue;
            return false;
        }
        return true;
    }
}

