/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.text.ParseException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitPushTarget
implements PushTarget {
    private static final Logger LOG = Logger.getInstance(GitPushTarget.class);
    @NotNull
    private final GitRemoteBranch myRemoteBranch;
    private final boolean myIsNewBranchCreated;

    GitPushTarget(@NotNull GitRemoteBranch remoteBranch, boolean isNewBranchCreated) {
        if (remoteBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteBranch", "git4idea/push/GitPushTarget", "<init>"));
        }
        this.myRemoteBranch = remoteBranch;
        this.myIsNewBranchCreated = isNewBranchCreated;
    }

    @NotNull
    GitRemoteBranch getBranch() {
        GitRemoteBranch gitRemoteBranch = this.myRemoteBranch;
        if (gitRemoteBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTarget", "getBranch"));
        }
        return gitRemoteBranch;
    }

    public boolean hasSomethingToPush() {
        return this.isNewBranchCreated();
    }

    boolean isNewBranchCreated() {
        return this.myIsNewBranchCreated;
    }

    @NotNull
    static GitPushTarget parse(@NotNull GitRepository repository, @Nullable String remoteName, @NotNull String branchName) throws ParseException {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushTarget", "parse"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/push/GitPushTarget", "parse"));
        }
        if (remoteName == null) {
            throw new ParseException("No remotes defined", -1);
        }
        if (!GitRefNameValidator.getInstance().checkInput(branchName)) {
            throw new ParseException("Invalid destination branch name: " + branchName, -1);
        }
        GitRemote remote = GitPushTarget.findRemote(repository.getRemotes(), remoteName);
        if (remote == null) {
            LOG.error("Remote [" + remoteName + "] is not found among " + repository.getRemotes());
            throw new ParseException("Invalid remote: " + remoteName, -1);
        }
        GitRemoteBranch existingRemoteBranch = GitPushTarget.findRemoteBranch(repository, remote, branchName);
        if (existingRemoteBranch != null) {
            GitPushTarget gitPushTarget = new GitPushTarget(existingRemoteBranch, false);
            if (gitPushTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTarget", "parse"));
            }
            return gitPushTarget;
        }
        GitStandardRemoteBranch rb = new GitStandardRemoteBranch(remote, branchName, GitBranch.DUMMY_HASH);
        GitPushTarget gitPushTarget = new GitPushTarget(rb, true);
        if (gitPushTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTarget", "parse"));
        }
        return gitPushTarget;
    }

    @Nullable
    private static GitRemote findRemote(@NotNull Collection<GitRemote> remotes, final @NotNull String candidate) {
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/push/GitPushTarget", "findRemote"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "git4idea/push/GitPushTarget", "findRemote"));
        }
        return (GitRemote)ContainerUtil.find(remotes, (Condition)new Condition<GitRemote>(){

            public boolean value(GitRemote remote) {
                return remote.getName().equals(candidate);
            }
        });
    }

    @Nullable
    static GitRemoteBranch findRemoteBranch(@NotNull GitRepository repository, final @NotNull GitRemote remote, final @NotNull String nameAtRemote) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushTarget", "findRemoteBranch"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/push/GitPushTarget", "findRemoteBranch"));
        }
        if (nameAtRemote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameAtRemote", "git4idea/push/GitPushTarget", "findRemoteBranch"));
        }
        return (GitRemoteBranch)ContainerUtil.find(repository.getBranches().getRemoteBranches(), (Condition)new Condition<GitRemoteBranch>(){

            public boolean value(GitRemoteBranch remoteBranch) {
                return remoteBranch.getRemote().equals(remote) && remoteBranch.getNameForRemoteOperations().equals(GitBranchUtil.stripRefsPrefix(nameAtRemote));
            }
        });
    }
}

