/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.ui.ExtraEditControl;
import com.intellij.dvcs.push.ui.PushTargetTextField;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitRemoteBranch;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitPushTargetPanel
extends PushTargetPanel<GitPushTarget> {
    private static final Logger LOG = Logger.getInstance(GitPushTargetPanel.class);
    private static final Comparator<GitRemoteBranch> REMOTE_BRANCH_COMPARATOR = new MyRemoteBranchComparator();
    private static final String SEPARATOR = " : ";
    private static final String NO_REMOTES = "No remotes";
    private final GitRepository myRepository;
    private final PushTargetTextField myTargetTextField;
    private final JLabel myRemoteLabel;
    @Nullable
    private GitPushTarget myCurrentTarget;
    @Nullable
    private Runnable myFireOnChangeAction;
    @NotNull
    private ExtraEditControl myEditRemoteControl;

    public GitPushTargetPanel(@NotNull GitRepository repository, @Nullable GitPushTarget defaultTarget) {
        String initialRemote;
        String initialBranch;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushTargetPanel", "<init>"));
        }
        this.myRepository = repository;
        this.myCurrentTarget = defaultTarget;
        if (defaultTarget == null) {
            initialBranch = "";
            initialRemote = NO_REMOTES;
        } else {
            initialBranch = GitPushTargetPanel.getTextFieldText(defaultTarget);
            initialRemote = GitPushTargetPanel.getRemoteLabelText(defaultTarget.getBranch().getRemote().getName());
        }
        this.myEditRemoteControl = new ExtraEditControl(){

            public void click(@NotNull MouseEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/push/GitPushTargetPanel$1", "click"));
                }
                GitPushTargetPanel.this.showRemoteSelector(event);
            }
        };
        this.myTargetTextField = new PushTargetTextField(repository.getProject(), GitPushTargetPanel.getTargetNames(this.myRepository), initialBranch);
        this.myRemoteLabel = new JBLabel(initialRemote);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add(this.myRemoteLabel, "West");
        this.add((Component)this.myTargetTextField, "Center");
        this.updateTextField();
    }

    private void updateTextField() {
        this.myTargetTextField.setVisible(!this.myRepository.getRemotes().isEmpty());
    }

    private void showRemoteSelector(@NotNull MouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/push/GitPushTargetPanel", "showRemoteSelector"));
        }
        List<String> remotes = this.getRemotes();
        if (remotes.size() <= 1) {
            return;
        }
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(null, remotes){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                GitPushTargetPanel.this.myRemoteLabel.setText(GitPushTargetPanel.getRemoteLabelText(selectedValue));
                if (GitPushTargetPanel.this.myFireOnChangeAction != null) {
                    GitPushTargetPanel.this.myFireOnChangeAction.run();
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }
        });
        popup.show(new RelativePoint(event));
    }

    @NotNull
    private List<String> getRemotes() {
        List list = ContainerUtil.map(this.myRepository.getRemotes(), (Function)new Function<GitRemote, String>(){

            public String fun(GitRemote remote) {
                return remote.getName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getRemotes"));
        }
        return list;
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "git4idea/push/GitPushTargetPanel", "render"));
        }
        String targetName = this.myTargetTextField.getText();
        if (StringUtil.isEmptyOrSpaces((String)targetName)) {
            renderer.append(NO_REMOTES, SimpleTextAttributes.ERROR_ATTRIBUTES, (Object)this);
        } else {
            String currentRemote = this.myRemoteLabel.getText();
            if (this.getRemotes().size() > 1) {
                renderer.append(currentRemote, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES, (Object)this.myEditRemoteControl);
            } else {
                renderer.append(currentRemote, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            GitPushTarget target = this.getValue();
            if (target.isNewBranchCreated()) {
                renderer.append("+", SimpleTextAttributes.SYNTHETIC_ATTRIBUTES, (Object)this);
            }
            renderer.append(target.getBranch().getNameForRemoteOperations(), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES, (Object)this);
        }
    }

    @NotNull
    public GitPushTarget getValue() {
        GitPushTarget gitPushTarget = (GitPushTarget)ObjectUtils.assertNotNull((Object)this.myCurrentTarget);
        if (gitPushTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getValue"));
        }
        return gitPushTarget;
    }

    @NotNull
    private static String getTextFieldText(@Nullable GitPushTarget target) {
        String string = target != null ? target.getBranch().getNameForRemoteOperations() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getTextFieldText"));
        }
        return string;
    }

    private static String getRemoteLabelText(@NotNull String selectedValue) {
        if (selectedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedValue", "git4idea/push/GitPushTargetPanel", "getRemoteLabelText"));
        }
        return selectedValue + SEPARATOR;
    }

    public void fireOnCancel() {
        this.myTargetTextField.setText(GitPushTargetPanel.getTextFieldText(this.myCurrentTarget));
    }

    public void fireOnChange() {
        String remoteName = this.getEnteredRemote();
        String branchName = this.myTargetTextField.getText();
        try {
            this.myCurrentTarget = GitPushTarget.parse(this.myRepository, remoteName, branchName);
        }
        catch (ParseException e) {
            LOG.error("Invalid remote name shouldn't be allowed. [" + remoteName + ", " + branchName + "]", (Throwable)e);
        }
    }

    @Nullable
    public ValidationInfo verify() {
        try {
            String remoteLabel = this.getEnteredRemote();
            GitPushTarget.parse(this.myRepository, remoteLabel, this.myTargetTextField.getText());
            return null;
        }
        catch (ParseException e) {
            return new ValidationInfo(e.getMessage(), (JComponent)this.myTargetTextField);
        }
    }

    public void setFireOnChangeAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "git4idea/push/GitPushTargetPanel", "setFireOnChangeAction"));
        }
        this.myFireOnChangeAction = action;
    }

    @Nullable
    private String getEnteredRemote() {
        String text = this.myRemoteLabel.getText();
        return text.equals(NO_REMOTES) ? null : text.replace(SEPARATOR, "");
    }

    @NotNull
    public static List<String> getTargetNames(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushTargetPanel", "getTargetNames"));
        }
        List remoteBranches = ContainerUtil.sorted(repository.getBranches().getRemoteBranches(), REMOTE_BRANCH_COMPARATOR);
        List list = ContainerUtil.map((Collection)remoteBranches, (Function)new Function<GitRemoteBranch, String>(){

            public String fun(GitRemoteBranch branch) {
                return branch.getNameForRemoteOperations();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getTargetNames"));
        }
        return list;
    }

    private static class MyRemoteBranchComparator
    implements Comparator<GitRemoteBranch> {
        private MyRemoteBranchComparator() {
        }

        @Override
        public int compare(GitRemoteBranch o1, GitRemoteBranch o2) {
            String remoteName2;
            String remoteName1 = o1.getRemote().getName();
            int remoteComparison = remoteName1.compareTo(remoteName2 = o2.getRemote().getName());
            if (remoteComparison != 0) {
                if (remoteName1.equals("origin")) {
                    return -1;
                }
                if (remoteName2.equals("origin")) {
                    return 1;
                }
                return remoteComparison;
            }
            return o1.getNameForLocalOperations().compareTo(o2.getNameForLocalOperations());
        }
    }
}

