/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMultiRootBranchConfig
extends DvcsMultiRootBranchConfig<GitRepository> {
    public GitMultiRootBranchConfig(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/ui/branch/GitMultiRootBranchConfig", "<init>"));
        }
        super(repositories);
    }

    @NotNull
    public Collection<String> getLocalBranchNames() {
        Collection<String> collection = GitBranchUtil.getCommonBranches(this.myRepositories, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitMultiRootBranchConfig", "getLocalBranchNames"));
        }
        return collection;
    }

    @NotNull
    Collection<String> getRemoteBranches() {
        Collection<String> collection = GitBranchUtil.getCommonBranches(this.myRepositories, false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitMultiRootBranchConfig", "getRemoteBranches"));
        }
        return collection;
    }

    @Nullable
    public String getTrackedBranch(@NotNull String branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/ui/branch/GitMultiRootBranchConfig", "getTrackedBranch"));
        }
        String trackedName = null;
        for (GitRepository repository : this.myRepositories) {
            GitRemoteBranch tracked = GitMultiRootBranchConfig.getTrackedBranch(repository, branch);
            if (tracked == null) {
                return null;
            }
            if (trackedName == null) {
                trackedName = tracked.getNameForLocalOperations();
                continue;
            }
            if (trackedName.equals(tracked.getNameForLocalOperations())) continue;
            return null;
        }
        return trackedName;
    }

    @NotNull
    public Collection<String> getTrackingBranches(@NotNull String remoteBranch) {
        if (remoteBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteBranch", "git4idea/ui/branch/GitMultiRootBranchConfig", "getTrackingBranches"));
        }
        Collection trackingBranches = null;
        for (GitRepository repository : this.myRepositories) {
            Collection tb = GitMultiRootBranchConfig.getTrackingBranches(repository, remoteBranch);
            if (trackingBranches == null) {
                trackingBranches = tb;
                continue;
            }
            trackingBranches = ContainerUtil.intersection(trackingBranches, tb);
        }
        Collection<String> collection = trackingBranches == null ? Collections.emptyList() : trackingBranches;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitMultiRootBranchConfig", "getTrackingBranches"));
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getTrackingBranches(@NotNull GitRepository repository, @NotNull String remoteBranch) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/ui/branch/GitMultiRootBranchConfig", "getTrackingBranches"));
        }
        if (remoteBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteBranch", "git4idea/ui/branch/GitMultiRootBranchConfig", "getTrackingBranches"));
        }
        ArrayList<String> trackingBranches = new ArrayList<String>(1);
        for (GitBranchTrackInfo trackInfo : repository.getBranchTrackInfos()) {
            if (!remoteBranch.equals(trackInfo.getRemote().getName() + "/" + trackInfo.getRemoteBranch())) continue;
            trackingBranches.add(trackInfo.getLocalBranch().getName());
        }
        ArrayList<String> arrayList = trackingBranches;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitMultiRootBranchConfig", "getTrackingBranches"));
        }
        return arrayList;
    }

    @Nullable
    private static GitRemoteBranch getTrackedBranch(@NotNull GitRepository repository, @NotNull String branchName) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/ui/branch/GitMultiRootBranchConfig", "getTrackedBranch"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitMultiRootBranchConfig", "getTrackedBranch"));
        }
        GitLocalBranch branch = GitBranchUtil.findLocalBranchByName(repository, branchName);
        return branch == null ? null : branch.findTrackedBranch(repository);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (GitRepository repository : this.myRepositories) {
            sb.append(repository.getPresentableUrl()).append(":").append(repository.getCurrentBranch()).append(":").append(repository.getState());
        }
        return sb.toString();
    }
}

