/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.actions.AbstractActionFromEditGroup;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvsoperations.cvsWatch.WatcherInfo;
import com.intellij.cvsSupport2.cvsoperations.cvsWatch.WatchersOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsWatch.ui.WatchersPanel;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.actions.VcsContext;
import java.util.List;
import javax.swing.Icon;

public class ViewWatchersAction
extends AbstractActionFromEditGroup {
    private WatchersOperation myWatchersOperation;

    @Override
    protected String getTitle(VcsContext context) {
        return CvsBundle.getViewEditorsOperationName();
    }

    @Override
    protected CvsHandler getCvsHandler(CvsContext context) {
        this.myWatchersOperation = new WatchersOperation(context.getSelectedFiles());
        return new CommandCvsHandler(CvsBundle.message((String)"operation.name.veiw.watchers", (Object[])new Object[0]), this.myWatchersOperation);
    }

    @Override
    protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
        super.onActionPerformed(context, tabbedWindow, successfully, handler);
        if (successfully) {
            List<WatcherInfo> watchers = this.myWatchersOperation.getWatchers();
            String filePath = CvsVfsUtil.getFileFor(context.getSelectedFile()).getAbsolutePath();
            if (watchers.isEmpty()) {
                Messages.showMessageDialog((String)CvsBundle.message((String)"message.error.no.watchers.for.file", (Object[])new Object[]{filePath}), (String)CvsBundle.message((String)"message.error.no.watchers.for.file.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            } else {
                tabbedWindow.addTab(CvsBundle.message((String)"message.watchers.for.file", (Object[])new Object[]{filePath}), new WatchersPanel(watchers), true, true, true, true, null, "cvs.watchers");
                tabbedWindow.ensureVisible(context.getProject());
            }
        }
    }
}

