/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsContent;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperation;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDateImpl;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.file.FileObject;

public class GetFileContentOperation
extends LocalPathIndifferentOperation {
    @NonNls
    private static final String VERS_PREFIX = "VERS:";
    private static final byte NOT_LOADED = 0;
    private static final byte FILE_NOT_FOUND = 1;
    private static final byte DELETED = 2;
    private static final byte SUCCESSFULLY_LOADED = 3;
    private static final byte LOADING = 4;
    private byte myState;
    private final FileContentReader myReader;
    private byte[] myFileBytes;
    private String myRevision;
    private final String myModuleName;
    private final CvsRootProvider myRoot;
    private CvsRevisionNumber myCvsRevisionNumber;
    private final RevisionOrDate myRevisionOrDate;

    public String getRevisionString() {
        if (this.myCvsRevisionNumber != null) {
            return this.myCvsRevisionNumber.asString();
        }
        if (this.myRevisionOrDate != null) {
            return this.myRevisionOrDate.toString();
        }
        return CvsBundle.message((String)"cvs.unknown.revision.presentation", (Object[])new Object[0]);
    }

    public static GetFileContentOperation createForFile(VirtualFile file, RevisionOrDate revisionOrDate) throws CannotFindCvsRootException {
        File ioFile = CvsVfsUtil.getFileFor(file);
        return new GetFileContentOperation(new File(GetFileContentOperation.getPathInRepository(file)), CvsRootProvider.createOn(ioFile), revisionOrDate);
    }

    public static GetFileContentOperation createForFile(@NotNull VirtualFile file) throws CannotFindCvsRootException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cvsSupport2/cvsoperations/cvsContent/GetFileContentOperation", "createForFile"));
        }
        return GetFileContentOperation.createForFile(file, RevisionOrDateImpl.createOn(file));
    }

    public static GetFileContentOperation createForFile(FilePath filePath) throws CannotFindCvsRootException {
        String pathInRepository = CvsEntriesManager.getInstance().getRepositoryFor(filePath.getVirtualFileParent()) + "/" + filePath.getName();
        return new GetFileContentOperation(new File(pathInRepository), CvsRootProvider.createOn(filePath.getIOFile()), RevisionOrDateImpl.createOn(filePath.getVirtualFileParent(), filePath.getName()));
    }

    public GetFileContentOperation(File cvsFile, CvsEnvironment environment, @NotNull RevisionOrDate revisionOrDate) {
        if (revisionOrDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionOrDate", "com/intellij/cvsSupport2/cvsoperations/cvsContent/GetFileContentOperation", "<init>"));
        }
        super(environment);
        this.myState = 0;
        this.myReader = new FileContentReader();
        this.myFileBytes = null;
        this.myRevisionOrDate = revisionOrDate;
        this.myRoot = CvsRootProvider.createOn(null, environment);
        this.myModuleName = cvsFile.getPath().replace(File.separatorChar, '/');
        this.myCvsRevisionNumber = this.myRevisionOrDate.getCvsRevisionNumber();
    }

    private static String getPathInRepository(VirtualFile file) {
        return CvsUtil.getModuleName(file);
    }

    @Override
    protected Collection<CvsRootProvider> getAllCvsRoots() {
        return Collections.singleton(this.myRoot);
    }

    public CvsRootProvider getRoot() {
        return this.myRoot;
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        this.myState = (byte)4;
        this.myRoot.changeAdminRootTo(new File("."));
        this.myRoot.changeLocalRootTo(new File("."));
        CheckoutCommand command = new CheckoutCommand(null);
        command.setRecursive(false);
        command.addModule(this.myModuleName);
        command.setPrintToOutput(true);
        this.myRevisionOrDate.setForCommand((Command)command);
        return command;
    }

    public String getRevision() {
        if (!this.isLoaded()) {
            return this.myRevisionOrDate.getRevision();
        }
        return this.myRevision;
    }

    public synchronized byte[] getFileBytes() {
        if (this.myFileBytes == null) {
            this.myFileBytes = this.loadFileBytes();
        }
        return this.myFileBytes;
    }

    @Nullable
    public synchronized byte[] tryGetFileBytes() {
        if (this.myFileBytes == null && this.myState == 4) {
            this.myFileBytes = this.loadFileBytes();
        }
        return this.myFileBytes;
    }

    public boolean isDeleted() {
        if (this.myState == 4) {
            this.getFileBytes();
        }
        return this.myState == 2;
    }

    private synchronized byte[] loadFileBytes() {
        if (this.myState != 4) {
            LOG.error("state = " + String.valueOf(this.myState));
        }
        if (this.myReader.isEmpty()) {
            this.myState = (byte)2;
            return null;
        }
        this.myState = (byte)3;
        return this.myReader.getReadContent();
    }

    @Override
    public void gotEntry(FileObject abstractFileObject, Entry entry) {
        super.gotEntry(abstractFileObject, entry);
        if (entry == null) {
            this.myState = (byte)2;
            this.myFileBytes = ArrayUtil.EMPTY_BYTE_ARRAY;
        } else {
            this.myRevision = entry.getRevision();
            this.myCvsRevisionNumber = new CvsRevisionNumber(this.myRevision);
        }
    }

    public boolean fileNotFound() {
        this.tryGetFileBytes();
        return this.myState == 1;
    }

    public boolean isLoaded() {
        return this.myState != 0;
    }

    public CvsRevisionNumber getRevisionNumber() {
        LOG.assertTrue(this.myCvsRevisionNumber != null);
        return this.myCvsRevisionNumber;
    }

    @Override
    protected String getOperationName() {
        return "checkout";
    }

    @Override
    public void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
        super.messageSent(message, byteMessage, error, tagged);
        if (!error) {
            this.myReader.messageSent(byteMessage, tagged);
        } else if (message.startsWith(VERS_PREFIX)) {
            String version;
            this.myRevision = version = message.substring(5).trim();
            this.myCvsRevisionNumber = new CvsRevisionNumber(version);
        }
    }

    @Override
    public void binaryMessageSent(byte[] bytes) {
        super.binaryMessageSent(bytes);
        this.myReader.binaryMessageSent(bytes);
    }

    @Override
    public boolean runInReadThread() {
        return false;
    }

    @Override
    protected boolean runInExclusiveLock() {
        return false;
    }

    public static class FileContentReader {
        private ByteArrayOutputStream myContent = null;
        private byte[] myBinaryContent = null;
        @NonNls
        private static final String TEXT_MESSAGE_TAG = "text";
        private boolean myLastTagIsText = false;

        public boolean isEmpty() {
            return this.myContent == null && this.myBinaryContent == null;
        }

        public byte[] getReadContent() {
            if (this.myBinaryContent != null) {
                return this.myBinaryContent;
            }
            if (!this.myLastTagIsText && this.myContent.size() > 0) {
                this.myContent.write(10);
            }
            return this.myContent.toByteArray();
        }

        public void messageSent(byte[] byteMessage, boolean tagged) {
            if (this.myContent == null) {
                this.myContent = new ByteArrayOutputStream();
            }
            this.myLastTagIsText = false;
            if (tagged) {
                String tagType = FileContentReader.readTagTypeFrom(byteMessage);
                if (tagType != null && TEXT_MESSAGE_TAG.equals(tagType)) {
                    int textStartPosition = tagType.length();
                    if (this.myContent.size() > 0) {
                        this.myContent.write(10);
                    }
                    this.myContent.write(byteMessage, textStartPosition + 1, byteMessage.length - textStartPosition - 1);
                    this.myLastTagIsText = true;
                }
            } else {
                if (this.myContent.size() > 0) {
                    this.myContent.write(10);
                }
                this.myContent.write(byteMessage, 0, byteMessage.length);
            }
        }

        private static String readTagTypeFrom(byte[] byteMessage) {
            StringBuilder result = new StringBuilder();
            for (byte b : byteMessage) {
                if (b == 32) {
                    return result.toString();
                }
                result.append((char)b);
            }
            return null;
        }

        public void binaryMessageSent(byte[] bytes) {
            this.myBinaryContent = bytes;
        }
    }
}

