/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.editorconfig.Utils;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;

public class EncodingManager
extends FileDocumentManagerAdapter {
    private static final String charsetKey = "charset";
    private final Project myProject;
    private static final Map<String, Charset> encodingMap;
    private boolean isApplyingSettings;

    public EncodingManager(Project project) {
        this.myProject = project;
        this.isApplyingSettings = false;
    }

    public void beforeDocumentSaving(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/editorconfig/configmanagement/EncodingManager", "beforeDocumentSaving"));
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (!this.isApplyingSettings) {
            this.applySettings(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySettings(VirtualFile file) {
        if (file == null) {
            return;
        }
        if (!Utils.isEnabled(CodeStyleSettingsManager.getInstance((Project)this.myProject).getCurrentSettings())) {
            return;
        }
        this.isApplyingSettings = true;
        try {
            String filePath = Utils.getFilePath(this.myProject, file);
            List<EditorConfig.OutPair> outPairs = SettingsProviderComponent.getInstance().getOutPairs(this.myProject, filePath);
            EncodingProjectManager encodingProjectManager = EncodingProjectManager.getInstance((Project)this.myProject);
            String charset = Utils.configValueForKey(outPairs, charsetKey);
            if (!charset.isEmpty()) {
                Charset newCharset = encodingMap.get(charset);
                if (newCharset != null) {
                    if (Comparing.equal((Object)newCharset, (Object)file.getCharset())) {
                        return;
                    }
                    encodingProjectManager.setEncoding(file, newCharset);
                    Utils.appliedConfigMessage(this.myProject, charset, charsetKey, filePath);
                } else {
                    Utils.invalidConfigMessage(this.myProject, charset, charsetKey, filePath);
                }
            }
        }
        finally {
            this.isApplyingSettings = false;
        }
    }

    static {
        HashMap<String, Charset> map = new HashMap<String, Charset>();
        map.put("latin1", Charset.forName("ISO-8859-1"));
        map.put("utf-8", CharsetToolkit.UTF8_CHARSET);
        map.put("utf-16be", CharsetToolkit.UTF_16BE_CHARSET);
        map.put("utf-16le", CharsetToolkit.UTF_16LE_CHARSET);
        encodingMap = Collections.unmodifiableMap(map);
    }
}

