/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import java.io.File;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.impl.IOUtil;
import jetbrains.coverage.report.impl.html.GeneratorPaths;
import jetbrains.coverage.report.impl.html.GeneratorPathsImpl;
import jetbrains.coverage.report.impl.html.LocalGeneratorPaths;
import jetbrains.coverage.report.impl.html.ModuleInfo;
import jetbrains.coverage.report.impl.html.SortOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesLocalPaths
implements LocalGeneratorPaths {
    private static final String EMPTY_MODULE_DIR = ".empty";
    private static final String EMPTY_NS_DIR = ".empty";
    private static final String EMPTY_CLASSNAME = "empty";
    private final File myReportsDir;

    public ModulesLocalPaths(File reportsDir) {
        this.myReportsDir = reportsDir;
    }

    @NotNull
    public File getResourcesPath() {
        File file = this.myReportsDir;
        if (file == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/ModulesLocalPaths.getResourcesPath must not return null");
        }
        return file;
    }

    @NotNull
    protected File getModuleIndexDir() {
        File file = this.myReportsDir;
        if (file == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/ModulesLocalPaths.getModuleIndexDir must not return null");
        }
        return file;
    }

    @NotNull
    protected File getClassesIndexDir(@NotNull ModuleInfo module, @Nullable String namespace) {
        String subDir;
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/ModulesLocalPaths.getClassesIndexDir must not be null");
        }
        String string = subDir = namespace == null ? ".empty" : namespace.trim();
        if (subDir.length() == 0) {
            subDir = ".empty";
        }
        File file = new File(this.getNamespacesIndexDir(module), IOUtil.fixFileName(subDir));
        if (file == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/ModulesLocalPaths.getClassesIndexDir must not return null");
        }
        return file;
    }

    @NotNull
    protected File getNamespacesIndexDir(ModuleInfo module) {
        String subDir = module.getPathNamePrefix().trim();
        if (subDir.length() == 0) {
            subDir = ".empty";
        }
        File file = new File(this.getModuleIndexDir(), IOUtil.fixFileName(subDir));
        if (file == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/ModulesLocalPaths.getNamespacesIndexDir must not return null");
        }
        return file;
    }

    private GeneratorPaths generate(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/ModulesLocalPaths.generate must not be null");
        }
        return new GeneratorPathsImpl(this, path);
    }

    @NotNull
    public GeneratorPaths getModulesIndexPath(@NotNull SortOption order) {
        if (order == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/ModulesLocalPaths.getModulesIndexPath must not be null");
        }
        GeneratorPaths generatorPaths = this.generate(new File(this.getModuleIndexDir(), order.getIndexFileName()));
        if (generatorPaths == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/ModulesLocalPaths.getModulesIndexPath must not return null");
        }
        return generatorPaths;
    }

    @NotNull
    public GeneratorPaths getNamespacesIndexPath(@NotNull ModuleInfo module, @NotNull SortOption order) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/ModulesLocalPaths.getNamespacesIndexPath must not be null");
        }
        if (order == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/ModulesLocalPaths.getNamespacesIndexPath must not be null");
        }
        GeneratorPaths generatorPaths = this.generate(new File(this.getNamespacesIndexDir(module), order.getIndexFileName()));
        if (generatorPaths == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/ModulesLocalPaths.getNamespacesIndexPath must not return null");
        }
        return generatorPaths;
    }

    @NotNull
    public GeneratorPaths getClassesIndexPath(@NotNull ModuleInfo module, @Nullable String namespace, @NotNull SortOption order) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/ModulesLocalPaths.getClassesIndexPath must not be null");
        }
        if (order == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/coverage/report/impl/html/ModulesLocalPaths.getClassesIndexPath must not be null");
        }
        GeneratorPaths generatorPaths = this.generate(new File(this.getClassesIndexDir(module, namespace), order.getIndexFileName()));
        if (generatorPaths == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/ModulesLocalPaths.getClassesIndexPath must not return null");
        }
        return generatorPaths;
    }

    @NotNull
    public GeneratorPaths getClassCoveragePath(@NotNull ModuleInfo module, @Nullable String namespace, @NotNull ClassInfo clazz) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/ModulesLocalPaths.getClassCoveragePath must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/coverage/report/impl/html/ModulesLocalPaths.getClassCoveragePath must not be null");
        }
        File home = new File(this.getClassesIndexDir(module, namespace), ".classes");
        GeneratorPaths generatorPaths = this.generate(new File(home, this.getClassFilename(clazz)));
        if (generatorPaths == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/ModulesLocalPaths.getClassCoveragePath must not return null");
        }
        return generatorPaths;
    }

    private String getClassFilename(ClassInfo cd) {
        String className = cd.getName();
        return IOUtil.fixFileName(className.length() == 0 ? EMPTY_CLASSNAME : className) + ".html";
    }
}

