/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions.generate.equals;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.ui.GenerateEqualsWizard;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.actions.generate.GroovyCodeInsightBundle;
import org.jetbrains.plugins.groovy.actions.generate.GroovyGenerationInfo;
import org.jetbrains.plugins.groovy.actions.generate.equals.GroovyGenerateEqualsHelper;

public class GroovyGenerateEqualsHandler
extends GenerateMembersHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.actions.generate.equals.EqualsGenerateHandler");
    private PsiField[] myEqualsFields = null;
    private PsiField[] myHashCodeFields = null;
    private PsiField[] myNonNullFields = null;
    private static final PsiElementClassMember[] DUMMY_RESULT = new PsiElementClassMember[1];

    public GroovyGenerateEqualsHandler() {
        super("");
    }

    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        boolean needHashCode;
        this.myEqualsFields = null;
        this.myHashCodeFields = null;
        this.myNonNullFields = PsiField.EMPTY_ARRAY;
        GlobalSearchScope scope = aClass.getResolveScope();
        final PsiMethod equalsMethod = GroovyGenerateEqualsHelper.findMethod(aClass, GroovyGenerateEqualsHelper.getEqualsSignature(project, scope));
        final PsiMethod hashCodeMethod = GroovyGenerateEqualsHelper.findMethod(aClass, GroovyGenerateEqualsHelper.getHashCodeSignature());
        boolean needEquals = equalsMethod == null;
        boolean bl = needHashCode = hashCodeMethod == null;
        if (!needEquals && !needHashCode) {
            String text;
            String string = text = aClass instanceof PsiAnonymousClass ? GroovyCodeInsightBundle.message("generate.equals.and.hashcode.already.defined.warning.anonymous", new Object[0]) : GroovyCodeInsightBundle.message("generate.equals.and.hashcode.already.defined.warning", aClass.getQualifiedName());
            if (Messages.showYesNoDialog((Project)project, (String)text, (String)GroovyCodeInsightBundle.message("generate.equals.and.hashcode.already.defined.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                if (!((Boolean)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        try {
                            equalsMethod.delete();
                            hashCodeMethod.delete();
                            return Boolean.TRUE;
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                            return Boolean.FALSE;
                        }
                    }
                })).booleanValue()) {
                    return null;
                }
                needHashCode = true;
                needEquals = true;
            } else {
                return null;
            }
        }
        GenerateEqualsWizard wizard = new GenerateEqualsWizard(project, aClass, needEquals, needHashCode);
        wizard.show();
        if (!wizard.isOK()) {
            return null;
        }
        this.myEqualsFields = wizard.getEqualsFields();
        this.myHashCodeFields = wizard.getHashCodeFields();
        this.myNonNullFields = wizard.getNonNullFields();
        return DUMMY_RESULT;
    }

    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] originalMembers) throws IncorrectOperationException {
        Project project = aClass.getProject();
        boolean useInstanceofToCheckParameterType = CodeInsightSettings.getInstance().USE_INSTANCEOF_ON_EQUALS_PARAMETER;
        GroovyGenerateEqualsHelper helper = new GroovyGenerateEqualsHelper(project, aClass, this.myEqualsFields, this.myHashCodeFields, this.myNonNullFields, useInstanceofToCheckParameterType);
        Collection<PsiMethod> methods = helper.generateMembers();
        List list = ContainerUtil.map2List(methods, (Function)new Function<PsiMethod, PsiGenerationInfo<PsiMethod>>(){

            public PsiGenerationInfo<PsiMethod> fun(PsiMethod s) {
                return new GroovyGenerationInfo<PsiMethod>(s);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/actions/generate/equals/GroovyGenerateEqualsHandler", "generateMemberPrototypes"));
        }
        return list;
    }

    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        return ClassMember.EMPTY_ARRAY;
    }

    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) throws IncorrectOperationException {
        return GenerationInfo.EMPTY_ARRAY;
    }

    protected void cleanup() {
        super.cleanup();
        this.myEqualsFields = null;
        this.myHashCodeFields = null;
        this.myNonNullFields = null;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

