/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class GitTaskHandler
extends VcsTaskHandler {
    private final GitBrancher myBrancher;
    private final GitRepositoryManager myRepositoryManager;
    private final Project myProject;

    public GitTaskHandler(GitBrancher brancher, GitRepositoryManager repositoryManager, Project project) {
        this.myBrancher = brancher;
        this.myRepositoryManager = repositoryManager;
        this.myProject = project;
    }

    public boolean isEnabled(Project project) {
        return !this.myRepositoryManager.getRepositories().isEmpty();
    }

    public VcsTaskHandler.TaskInfo startNewTask(final String taskName) {
        List repositories = this.myRepositoryManager.getRepositories();
        List problems = ContainerUtil.filter((Collection)repositories, (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                return repository.getBranches().findLocalBranch(taskName) != null;
            }
        });
        MultiMap map = new MultiMap();
        if (!problems.isEmpty() && (ApplicationManager.getApplication().isUnitTestMode() || Messages.showDialog((Project)this.myProject, (String)("<html>The following repositories already have specified branch <b>" + taskName + "</b>:<br>" + StringUtil.join((Iterable)problems, (String)"<br>") + ".<br>" + "Do you want to checkout existing branch?"), (String)"Branch Already Exists", (String[])new String[]{Messages.YES_BUTTON, Messages.NO_BUTTON}, (int)0, (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)new DialogWrapper.PropertyDoNotAskOption("git.checkout.existing.branch")) == 0)) {
            this.myBrancher.checkout(taskName, problems, null);
            GitTaskHandler.fillMap(taskName, problems, (MultiMap<String, String>)map);
        }
        repositories.removeAll(problems);
        if (!repositories.isEmpty()) {
            this.myBrancher.checkoutNewBranch(taskName, repositories);
        }
        GitTaskHandler.fillMap(taskName, repositories, (MultiMap<String, String>)map);
        return new VcsTaskHandler.TaskInfo(map);
    }

    private static void fillMap(String taskName, List<GitRepository> repositories, MultiMap<String, String> map) {
        for (GitRepository repository : repositories) {
            map.putValue((Object)taskName, (Object)repository.getPresentableUrl());
        }
    }

    public void switchToTask(VcsTaskHandler.TaskInfo taskInfo, Runnable invokeAfter) {
        for (final String branchName : taskInfo.branches.keySet()) {
            List<GitRepository> repositories = this.getRepositories(taskInfo.branches.get((Object)branchName));
            List notFound = ContainerUtil.filter(repositories, (Condition)new Condition<GitRepository>(){

                public boolean value(GitRepository repository) {
                    return repository.getBranches().findLocalBranch(branchName) == null;
                }
            });
            if (!notFound.isEmpty()) {
                this.myBrancher.checkoutNewBranch(branchName, notFound);
            }
            repositories.removeAll(notFound);
            if (repositories.isEmpty()) continue;
            this.myBrancher.checkout(branchName, repositories, invokeAfter);
        }
    }

    public void closeTask(final VcsTaskHandler.TaskInfo taskInfo, VcsTaskHandler.TaskInfo original) {
        Set branches = original.branches.keySet();
        final AtomicInteger counter = new AtomicInteger(branches.size());
        for (String originalBranch : branches) {
            this.myBrancher.checkout(originalBranch, this.getRepositories(original.branches.get((Object)originalBranch)), new Runnable(){

                @Override
                public void run() {
                    if (counter.decrementAndGet() == 0) {
                        GitTaskHandler.this.merge(taskInfo);
                    }
                }
            });
        }
    }

    private void merge(VcsTaskHandler.TaskInfo taskInfo) {
        for (String featureBranch : taskInfo.branches.keySet()) {
            this.myBrancher.merge(featureBranch, GitBrancher.DeleteOnMergeOption.DELETE, this.getRepositories(taskInfo.branches.get((Object)featureBranch)));
        }
    }

    public VcsTaskHandler.TaskInfo getActiveTask() {
        List repositories = this.myRepositoryManager.getRepositories();
        MultiMap branches = new MultiMap();
        for (GitRepository repository : repositories) {
            GitLocalBranch branch = repository.getCurrentBranch();
            if (branch == null) continue;
            branches.putValue((Object)branch.getName(), (Object)repository.getPresentableUrl());
        }
        return new VcsTaskHandler.TaskInfo(branches);
    }

    public VcsTaskHandler.TaskInfo[] getCurrentTasks() {
        List repositories = this.myRepositoryManager.getRepositories();
        final List names = ContainerUtil.map((Collection)repositories, (Function)new Function<GitRepository, String>(){

            public String fun(GitRepository repository) {
                return repository.getPresentableUrl();
            }
        });
        Collection<String> branches = GitBranchUtil.getCommonBranches(repositories, true);
        return (VcsTaskHandler.TaskInfo[])ContainerUtil.map2Array(branches, VcsTaskHandler.TaskInfo.class, (Function)new Function<String, VcsTaskHandler.TaskInfo>(){

            public VcsTaskHandler.TaskInfo fun(String branchName) {
                MultiMap map = new MultiMap();
                map.put((Object)branchName, (Collection)names);
                return new VcsTaskHandler.TaskInfo(map);
            }
        });
    }

    private List<GitRepository> getRepositories(Collection<String> urls) {
        final List repositories = this.myRepositoryManager.getRepositories();
        return ContainerUtil.mapNotNull(urls, (Function)new NullableFunction<String, GitRepository>(){

            @Nullable
            public GitRepository fun(final String s) {
                return (GitRepository)ContainerUtil.find((Iterable)repositories, (Condition)new Condition<GitRepository>(){

                    public boolean value(GitRepository repository) {
                        return s.equals(repository.getPresentableUrl());
                    }
                });
            }
        });
    }
}

