/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.util.SingleMessageLogger;

public class DefaultBuildConfigurer
implements BuildConfigurer {
    public void configure(GradleInternal gradle) {
        this.maybeInformAboutIncubatingMode(gradle.getStartParameter());
        if (gradle.getStartParameter().isConfigureOnDemand()) {
            gradle.getRootProject().evaluate();
        } else {
            for (Project project : gradle.getRootProject().getAllprojects()) {
                ((ProjectInternal)project).evaluate();
            }
        }
    }

    private void maybeInformAboutIncubatingMode(StartParameter startParameter) {
        if (startParameter.getParallelThreadCount() != 0 && startParameter.isConfigureOnDemand()) {
            SingleMessageLogger.incubatingFeatureUsed("Parallel execution with configuration on demand");
        } else if (startParameter.getParallelThreadCount() != 0) {
            SingleMessageLogger.incubatingFeatureUsed("Parallel execution");
        } else if (startParameter.isConfigureOnDemand()) {
            SingleMessageLogger.incubatingFeatureUsed("Configuration on demand");
        }
    }
}

