/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.TaskNameResolver;
import org.gradle.execution.TaskSelectionException;
import org.gradle.execution.TaskSelectionResult;
import org.gradle.execution.taskpath.ResolvedTaskPath;
import org.gradle.execution.taskpath.TaskPathResolver;
import org.gradle.util.NameMatcher;

public class TaskSelector {
    private final TaskNameResolver taskNameResolver;
    private final GradleInternal gradle;
    private final TaskPathResolver taskPathResolver = new TaskPathResolver();

    public TaskSelector(GradleInternal gradle) {
        this(gradle, new TaskNameResolver());
    }

    public TaskSelector(GradleInternal gradle, TaskNameResolver taskNameResolver) {
        this.taskNameResolver = taskNameResolver;
        this.gradle = gradle;
    }

    public TaskSelection getSelection(String path) {
        return this.getSelection(path, this.gradle.getDefaultProject());
    }

    public TaskSelection getSelection(@Nullable String projectPath, String path) {
        ProjectInternal project = projectPath != null ? this.gradle.getRootProject().findProject(projectPath) : this.gradle.getDefaultProject();
        return this.getSelection(path, project);
    }

    private TaskSelection getSelection(String path, ProjectInternal project) {
        ResolvedTaskPath taskPath = this.taskPathResolver.resolvePath(path, project);
        TaskSelectionResult tasks = this.taskNameResolver.selectWithName(taskPath.getTaskName(), taskPath.getProject(), !taskPath.isQualified());
        if (tasks != null) {
            return new TaskSelection(taskPath.getProject().getPath(), path, tasks);
        }
        Map<String, TaskSelectionResult> tasksByName = this.taskNameResolver.selectAll(taskPath.getProject(), !taskPath.isQualified());
        NameMatcher matcher = new NameMatcher();
        String actualName = matcher.find(taskPath.getTaskName(), tasksByName.keySet());
        if (actualName != null) {
            return new TaskSelection(taskPath.getProject().getPath(), taskPath.getPrefix() + actualName, tasksByName.get(actualName));
        }
        throw new TaskSelectionException(matcher.formatErrorMessage("task", taskPath.getProject()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaskSelection {
        private final String projectPath;
        private final String taskName;
        private final TaskSelectionResult taskSelectionResult;

        public TaskSelection(String projectPath, String taskName, TaskSelectionResult tasks) {
            this.projectPath = projectPath;
            this.taskName = taskName;
            this.taskSelectionResult = tasks;
        }

        public String getProjectPath() {
            return this.projectPath;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public Set<Task> getTasks() {
            LinkedHashSet<Task> result = new LinkedHashSet<Task>();
            this.taskSelectionResult.collectTasks(result);
            return result;
        }
    }
}

