/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskUiUtil {
    private static Logger LOG = Logger.getInstance(TaskUiUtil.class);

    private TaskUiUtil() {
    }

    public static class SimpleComboBoxRenderer<T>
    extends ListCellRendererWrapper<T> {
        private final String myNullDescription;

        public SimpleComboBoxRenderer(@NotNull String nullDescription) {
            if (nullDescription == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullDescription", "com/intellij/tasks/impl/TaskUiUtil$SimpleComboBoxRenderer", "<init>"));
            }
            this.myNullDescription = nullDescription;
        }

        public final void customize(JList list, T value, int index, boolean selected, boolean hasFocus) {
            this.setText(value == null ? this.myNullDescription : this.getDescription(value));
        }

        @NotNull
        protected String getDescription(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/tasks/impl/TaskUiUtil$SimpleComboBoxRenderer", "getDescription"));
            }
            String string = item.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskUiUtil$SimpleComboBoxRenderer", "getDescription"));
            }
            return string;
        }
    }

    public static abstract class ComboBoxUpdater<T>
    extends RemoteFetchTask<List<T>> {
        protected final ComboBox myComboBox;

        public ComboBoxUpdater(@Nullable Project project, @NotNull String title, @NotNull ComboBox comboBox) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/tasks/impl/TaskUiUtil$ComboBoxUpdater", "<init>"));
            }
            if (comboBox == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/intellij/tasks/impl/TaskUiUtil$ComboBoxUpdater", "<init>"));
            }
            super(project, title);
            this.myComboBox = comboBox;
        }

        @Nullable
        public T getExtraItem() {
            return null;
        }

        @Nullable
        public T getSelectedItem() {
            return this.getExtraItem();
        }

        @Override
        protected void updateUI() {
            if (this.myResult != null) {
                this.myComboBox.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray((Collection)((Collection)this.myResult))));
                T extra = this.getExtraItem();
                if (extra != null) {
                    this.myComboBox.insertItemAt(extra, 0);
                }
                this.myComboBox.setSelectedItem(null);
                T selected = this.getSelectedItem();
                if (selected != null) {
                    this.myComboBox.setSelectedItem(selected);
                } else if (this.myComboBox.getItemCount() > 0) {
                    this.myComboBox.setSelectedIndex(0);
                }
            } else {
                this.handleError();
            }
        }

        protected void handleError() {
            this.myComboBox.removeAllItems();
        }
    }

    public static abstract class RemoteFetchTask<T>
    extends Task.Backgroundable {
        protected T myResult;
        protected Exception myException;
        private final ModalityState myModalityState;

        protected RemoteFetchTask(@Nullable Project project, @NotNull String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/tasks/impl/TaskUiUtil$RemoteFetchTask", "<init>"));
            }
            super(project, title);
            this.myModalityState = ModalityState.current();
        }

        public final void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/tasks/impl/TaskUiUtil$RemoteFetchTask", "run"));
            }
            try {
                this.myResult = this.fetch(indicator);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                this.myException = e;
            }
        }

        @Nullable
        public final Task.NotificationInfo notifyFinished() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    RemoteFetchTask.this.updateUI();
                }
            }, this.myModalityState);
            return null;
        }

        @NotNull
        protected abstract T fetch(@NotNull ProgressIndicator var1) throws Exception;

        protected abstract void updateUI();
    }
}

