/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class VarExprent
extends Exprent {
    public static final int STACK_BASE = 10000;
    public static final String VAR_NAMELESS_ENCLOSURE = "<VAR_NAMELESS_ENCLOSURE>";
    private int index;
    private VarType vartype;
    private boolean definition = false;
    private VarProcessor processor;
    private int version = 0;
    private boolean classdef = false;
    private boolean stack = false;

    public VarExprent(int index, VarType vartype, VarProcessor processor) {
        this.type = 12;
        this.index = index;
        this.vartype = vartype;
        this.processor = processor;
    }

    @Override
    public VarType getExprType() {
        return this.getVartype();
    }

    @Override
    public int getExprentUse() {
        return 3;
    }

    @Override
    public List<Exprent> getAllExprents() {
        return new ArrayList<Exprent>();
    }

    @Override
    public Exprent copy() {
        VarExprent var = new VarExprent(this.index, this.getVartype(), this.processor);
        var.setDefinition(this.definition);
        var.setVersion(this.version);
        var.setClassdef(this.classdef);
        var.setStack(this.stack);
        return var;
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        StringBuilder buffer = new StringBuilder();
        tracer.addMapping(this.bytecode);
        if (this.classdef) {
            ClassesProcessor.ClassNode child = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.vartype.value);
            new ClassWriter().classToJava(child, buffer, indent);
        } else {
            String name = null;
            if (this.processor != null) {
                name = this.processor.getVarName(new VarVersionPaar(this.index, this.version));
            }
            if (this.definition) {
                if (this.processor != null && this.processor.getVarFinal(new VarVersionPaar(this.index, this.version)) == 2) {
                    buffer.append("final ");
                }
                buffer.append(ExprProcessor.getCastTypeName(this.getVartype())).append(" ");
            }
            buffer.append(name == null ? "var" + this.index + (this.version == 0 ? "" : "_" + this.version) : name);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof VarExprent)) {
            return false;
        }
        VarExprent ve = (VarExprent)o;
        return this.index == ve.getIndex() && this.version == ve.getVersion() && InterpreterUtil.equalObjects(this.getVartype(), ve.getVartype());
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public VarType getVartype() {
        VarType vt = null;
        if (this.processor != null) {
            vt = this.processor.getVarType(new VarVersionPaar(this.index, this.version));
        }
        if (vt == null || this.vartype != null && this.vartype.type != 17) {
            vt = this.vartype;
        }
        return vt == null ? VarType.VARTYPE_UNKNOWN : vt;
    }

    public void setVartype(VarType vartype) {
        this.vartype = vartype;
    }

    public boolean isDefinition() {
        return this.definition;
    }

    public void setDefinition(boolean definition) {
        this.definition = definition;
    }

    public VarProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(VarProcessor processor) {
        this.processor = processor;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isClassdef() {
        return this.classdef;
    }

    public void setClassdef(boolean classdef) {
        this.classdef = classdef;
    }

    public boolean isStack() {
        return this.stack;
    }

    public void setStack(boolean stack) {
        this.stack = stack;
    }
}

