/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.DecHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class SequenceStatement
extends Statement {
    private SequenceStatement() {
        this.type = 15;
    }

    public SequenceStatement(List<Statement> lst) {
        this();
        this.lastBasicType = lst.get(lst.size() - 1).getLastBasicType();
        for (Statement st : lst) {
            this.stats.addWithKey(st, st.id);
        }
        this.first = (Statement)this.stats.get(0);
    }

    private SequenceStatement(Statement head, Statement tail) {
        this(Arrays.asList(head, tail));
        StatEdge edge;
        List<StatEdge> lstSuccs = tail.getSuccessorEdges(0x40000000);
        if (!lstSuccs.isEmpty() && (edge = lstSuccs.get(0)).getType() == 1 && edge.getDestination() != head) {
            this.post = edge.getDestination();
        }
    }

    public static Statement isHead2Block(Statement head) {
        Statement stat;
        if (head.getLastBasicType() != 2) {
            return null;
        }
        StatEdge edge = null;
        List<StatEdge> lstSuccs = head.getSuccessorEdges(0x40000000);
        if (!lstSuccs.isEmpty()) {
            edge = lstSuccs.get(0);
        }
        if (edge != null && edge.getType() == 1 && (stat = edge.getDestination()) != head && stat.getPredecessorEdges(1).size() == 1 && !stat.isMonitorEnter() && stat.getLastBasicType() == 2 && DecHelper.checkStatementExceptions(Arrays.asList(head, stat))) {
            return new SequenceStatement(head, stat);
        }
        return null;
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        StringBuilder buf = new StringBuilder();
        String indstr = null;
        boolean islabeled = this.isLabeled();
        String new_line_separator = DecompilerContext.getNewLineSeparator();
        buf.append(ExprProcessor.listToJava(this.varDefinitions, indent, tracer));
        if (islabeled) {
            indstr = InterpreterUtil.getIndentString(indent);
            ++indent;
            buf.append(indstr).append("label").append(this.id).append(": {").append(new_line_separator);
            tracer.incrementSourceLine();
        }
        boolean notempty = false;
        for (int i = 0; i < this.stats.size(); ++i) {
            Statement st = (Statement)this.stats.get(i);
            if (i > 0 && notempty) {
                buf.append(new_line_separator);
                tracer.incrementSourceLine();
            }
            String str = ExprProcessor.jmpWrapper(st, indent, false, tracer);
            buf.append(str);
            notempty = str.trim().length() > 0;
        }
        if (islabeled) {
            buf.append(indstr).append("}").append(new_line_separator);
            tracer.incrementSourceLine();
        }
        return buf.toString();
    }

    @Override
    public Statement getSimpleCopy() {
        return new SequenceStatement();
    }
}

