/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.codeStyle.OptionTreeWithPreviewPanel;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class JavaDocFormattingPanel
extends OptionTreeWithPreviewPanel {
    private JCheckBox myEnableCheckBox;
    private final JPanel myJavaDocPanel = new JPanel(new BorderLayout());
    private static final String OTHER_GROUP = ApplicationBundle.message((String)"group.javadoc.other", (Object[])new Object[0]);
    private static final String INVALID_TAGS_GROUP = ApplicationBundle.message((String)"group.javadoc.invalid.tags", (Object[])new Object[0]);
    private static final String BLANK_LINES_GROUP = ApplicationBundle.message((String)"group.javadoc.blank.lines", (Object[])new Object[0]);
    private static final String ALIGNMENT_GROUP = ApplicationBundle.message((String)"group.javadoc.alignment", (Object[])new Object[0]);

    public JavaDocFormattingPanel(CodeStyleSettings settings) {
        super(settings);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.myEnableCheckBox = new JCheckBox(ApplicationBundle.message((String)"checkbox.enable.javadoc.formatting", (Object[])new Object[0]));
        this.myEnableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaDocFormattingPanel.this.update();
            }
        });
        this.myJavaDocPanel.add("Center", this.myPanel);
        this.myJavaDocPanel.add((Component)this.myEnableCheckBox, "North");
    }

    @Override
    public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
        return LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC;
    }

    @Override
    public JComponent getPanel() {
        return this.myJavaDocPanel;
    }

    private void update() {
        JavaDocFormattingPanel.setEnabled(this.getPanel(), this.myEnableCheckBox.isSelected());
        this.myEnableCheckBox.setEnabled(true);
    }

    @Override
    protected void initTables() {
        this.initBooleanField("JD_ALIGN_PARAM_COMMENTS", ApplicationBundle.message((String)"checkbox.align.parameter.descriptions", (Object[])new Object[0]), ALIGNMENT_GROUP);
        this.initBooleanField("JD_ALIGN_EXCEPTION_COMMENTS", ApplicationBundle.message((String)"checkbox.align.thrown.exception.descriptions", (Object[])new Object[0]), ALIGNMENT_GROUP);
        this.initBooleanField("JD_ADD_BLANK_AFTER_DESCRIPTION", ApplicationBundle.message((String)"checkbox.after.description", (Object[])new Object[0]), BLANK_LINES_GROUP);
        this.initBooleanField("JD_ADD_BLANK_AFTER_PARM_COMMENTS", ApplicationBundle.message((String)"checkbox.after.parameter.descriptions", (Object[])new Object[0]), BLANK_LINES_GROUP);
        this.initBooleanField("JD_ADD_BLANK_AFTER_RETURN", ApplicationBundle.message((String)"checkbox.after.return.tag", (Object[])new Object[0]), BLANK_LINES_GROUP);
        this.initBooleanField("JD_KEEP_INVALID_TAGS", ApplicationBundle.message((String)"checkbox.keep.invalid.tags", (Object[])new Object[0]), INVALID_TAGS_GROUP);
        this.initBooleanField("JD_KEEP_EMPTY_PARAMETER", ApplicationBundle.message((String)"checkbox.keep.empty.param.tags", (Object[])new Object[0]), INVALID_TAGS_GROUP);
        this.initBooleanField("JD_KEEP_EMPTY_RETURN", ApplicationBundle.message((String)"checkbox.keep.empty.return.tags", (Object[])new Object[0]), INVALID_TAGS_GROUP);
        this.initBooleanField("JD_KEEP_EMPTY_EXCEPTION", ApplicationBundle.message((String)"checkbox.keep.empty.throws.tags", (Object[])new Object[0]), INVALID_TAGS_GROUP);
        this.initBooleanField("JD_LEADING_ASTERISKS_ARE_ENABLED", ApplicationBundle.message((String)"checkbox.enable.leading.asterisks", (Object[])new Object[0]), OTHER_GROUP);
        this.initBooleanField("JD_USE_THROWS_NOT_EXCEPTION", ApplicationBundle.message((String)"checkbox.use.throws.rather.than.exception", (Object[])new Object[0]), OTHER_GROUP);
        this.initBooleanField("WRAP_COMMENTS", ApplicationBundle.message((String)"checkbox.wrap.at.right.margin", (Object[])new Object[0]), OTHER_GROUP);
        this.initBooleanField("JD_P_AT_EMPTY_LINES", ApplicationBundle.message((String)"checkbox.generate.p.on.empty.lines", (Object[])new Object[0]), OTHER_GROUP);
        this.initBooleanField("JD_KEEP_EMPTY_LINES", ApplicationBundle.message((String)"checkbox.keep.empty.lines", (Object[])new Object[0]), OTHER_GROUP);
        this.initBooleanField("JD_DO_NOT_WRAP_ONE_LINE_COMMENTS", ApplicationBundle.message((String)"checkbox.do.not.wrap.one.line.comments", (Object[])new Object[0]), OTHER_GROUP);
        this.initBooleanField("JD_PRESERVE_LINE_FEEDS", ApplicationBundle.message((String)"checkbox.preserve.line.feeds", (Object[])new Object[0]), OTHER_GROUP);
        this.initBooleanField("JD_PARAM_DESCRIPTION_ON_NEW_LINE", ApplicationBundle.message((String)"checkbox.param.description.on.new.line", (Object[])new Object[0]), OTHER_GROUP);
    }

    @Override
    protected int getRightMargin() {
        return 47;
    }

    @Override
    protected String getPreviewText() {
        return "package sample;\npublic class Sample {\n  /**\n   * This is a method description that is long enough to exceed right margin.\n   *\n   * Another paragraph of the description placed after blank line.\n   * <p/>\n   * Line with manual\n   * line feed.\n   * @param i short named parameter description\n   * @param longParameterName long named parameter description\n   * @param missingDescription\n   * @return return description.\n   * @throws XXXException description.\n   * @throws YException description.\n   * @throws ZException\n   *\n   * @invalidTag   */\n  public abstract String sampleMethod(int i, int longParameterName, int missingDescription) throws XXXException, YException, ZException;\n\n  /** One-line comment */\n  public abstract String sampleMethod2();\n\n  /**\n   * Simple method description\n   * @return\n   */\n  public abstract String sampleMethod3();\n";
    }

    private static void setEnabled(JComponent c, boolean enabled) {
        Component[] children;
        c.setEnabled(enabled);
        for (Component child : children = c.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            JavaDocFormattingPanel.setEnabled((JComponent)child, enabled);
        }
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        super.apply(settings);
        settings.ENABLE_JAVADOC_FORMATTING = this.myEnableCheckBox.isSelected();
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        super.resetImpl(settings);
        this.myEnableCheckBox.setSelected(settings.ENABLE_JAVADOC_FORMATTING);
        this.update();
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        return super.isModified(settings) || this.myEnableCheckBox.isSelected() != settings.ENABLE_JAVADOC_FORMATTING;
    }

    @Override
    @NotNull
    protected final FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.JAVA;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/JavaDocFormattingPanel", "getFileType"));
        }
        return languageFileType;
    }

    @Override
    public boolean setPanelLanguage(Language language) {
        return super.setPanelLanguage(null);
    }

    @Override
    protected void customizeSettings() {
        this.resetDefaultNames();
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)JavaLanguage.INSTANCE);
        if (provider != null) {
            provider.customizeSettings((CodeStyleSettingsCustomizable)this, this.getSettingsType());
        }
    }

    @Override
    protected String getTabTitle() {
        return ApplicationBundle.message((String)"title.javadoc", (Object[])new Object[0]);
    }
}

