/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetCompositeConfigurable
extends CompositeConfigurable<UnnamedConfigurable>
implements SearchableConfigurable {
    private JPanel myRootPanel;
    private JPanel myGeneratorSettingsPanel;
    private JComboBox myEmmetExpandShortcutCombo;
    private static final String SPACE = CodeInsightBundle.message((String)"template.shortcut.space", (Object[])new Object[0]);
    private static final String TAB = CodeInsightBundle.message((String)"template.shortcut.tab", (Object[])new Object[0]);
    private static final String ENTER = CodeInsightBundle.message((String)"template.shortcut.enter", (Object[])new Object[0]);

    public EmmetCompositeConfigurable() {
        this.$$$setupUI$$$();
        this.myEmmetExpandShortcutCombo.addItem(SPACE);
        this.myEmmetExpandShortcutCombo.addItem(TAB);
        this.myEmmetExpandShortcutCombo.addItem(ENTER);
    }

    @Nls
    public String getDisplayName() {
        return XmlBundle.message((String)"emmet.configuration.title", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return this.getId();
    }

    @Nullable
    public JComponent createComponent() {
        List configurables = this.getConfigurables();
        this.myGeneratorSettingsPanel.setLayout((LayoutManager)new GridLayoutManager(configurables.size(), 1, new Insets(0, 0, 10, 0), -1, -1));
        for (int i = 0; i < configurables.size(); ++i) {
            UnnamedConfigurable configurable = (UnnamedConfigurable)configurables.get(i);
            JComponent component = configurable.createComponent();
            assert (component != null);
            this.myGeneratorSettingsPanel.add((Component)component, new GridConstraints(i, 0, 1, 1, 0, 1, 7, 3, new Dimension(-1, -1), new Dimension(-1, -1), new Dimension(-1, -1)));
        }
        this.myGeneratorSettingsPanel.revalidate();
        this.myRootPanel.revalidate();
        return this.myRootPanel;
    }

    @Override
    public void reset() {
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        char shortcut = (char)emmetOptions.getEmmetExpandShortcut();
        if (shortcut == '\t') {
            this.myEmmetExpandShortcutCombo.setSelectedItem(TAB);
        } else if (shortcut == '\n') {
            this.myEmmetExpandShortcutCombo.setSelectedItem(ENTER);
        } else {
            this.myEmmetExpandShortcutCombo.setSelectedItem(SPACE);
        }
        super.reset();
    }

    @Override
    public void apply() throws ConfigurationException {
        EmmetOptions emmetOptions = EmmetOptions.getInstance();
        emmetOptions.setEmmetExpandShortcut(this.getSelectedEmmetExpandShortcut());
        super.apply();
    }

    @Override
    public boolean isModified() {
        return EmmetOptions.getInstance().getEmmetExpandShortcut() != this.getSelectedEmmetExpandShortcut() || super.isModified();
    }

    @Override
    public void disposeUIResources() {
        this.myGeneratorSettingsPanel.removeAll();
        super.disposeUIResources();
    }

    @Override
    protected List<UnnamedConfigurable> createConfigurables() {
        List xmlConfigurables = ContainerUtil.newSmartList((Object[])new Object[0]);
        List configurables = ContainerUtil.newSmartList((Object[])new Object[0]);
        for (ZenCodingGenerator zenCodingGenerator : ZenCodingGenerator.getInstances()) {
            if (zenCodingGenerator instanceof XmlZenCodingGenerator) {
                ContainerUtil.addIfNotNull((Collection)xmlConfigurables, (Object)zenCodingGenerator.createConfigurable());
                continue;
            }
            ContainerUtil.addIfNotNull((Collection)configurables, (Object)zenCodingGenerator.createConfigurable());
        }
        return ContainerUtil.concat((List)xmlConfigurables, (List)configurables);
    }

    private char getSelectedEmmetExpandShortcut() {
        Object selectedItem = this.myEmmetExpandShortcutCombo.getSelectedItem();
        if (TAB.equals(selectedItem)) {
            return '\t';
        }
        if (ENTER.equals(selectedItem)) {
            return '\n';
        }
        return ' ';
    }

    @NotNull
    public String getId() {
        if ("reference.idesettings.emmet" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/EmmetCompositeConfigurable", "getId"));
        }
        return "reference.idesettings.emmet";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myGeneratorSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 1, 1, 6, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/XmlBundle").getString("emmet.expand.abbreviation.with"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myEmmetExpandShortcutCombo = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

