/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddModuleDependencyFix
extends OrderEntryFix {
    private final LinkedHashSet<Module> myModules = new LinkedHashSet();
    private final Module myCurrentModule;
    private final VirtualFile myClassVFile;
    private final PsiClass[] myClasses;
    private final PsiReference myReference;
    private static final Logger LOG = Logger.getInstance((String)("#" + AddModuleDependencyFix.class.getName()));

    public AddModuleDependencyFix(Module currentModule, VirtualFile classVFile, PsiClass[] classes, PsiReference reference) {
        PsiElement psiElement = reference.getElement();
        Project project = psiElement.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiClass aClass : classes) {
            Module classModule;
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || (psiFile = aClass.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null || (classModule = fileIndex.getModuleForFile(virtualFile)) == null || classModule == currentModule || ModuleRootManager.getInstance((Module)currentModule).isDependsOn(classModule)) continue;
            this.myModules.add(classModule);
        }
        this.myCurrentModule = currentModule;
        this.myClassVFile = classVFile;
        this.myClasses = classes;
        this.myReference = reference;
    }

    @NotNull
    public String getText() {
        if (this.myModules.size() == 1) {
            Module module = (Module)ContainerUtil.getFirstItem(this.myModules);
            LOG.assertTrue(module != null);
            String string = QuickFixBundle.message("orderEntry.fix.add.dependency.on.module", module.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddModuleDependencyFix", "getText"));
            }
            return string;
        }
        if ("Add dependency on module..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddModuleDependencyFix", "getText"));
        }
        return "Add dependency on module...";
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("orderEntry.fix.family.add.module.dependency", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddModuleDependencyFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddModuleDependencyFix", "isAvailable"));
        }
        for (Module module : this.myModules) {
            if (!module.isDisposed()) continue;
            return false;
        }
        return !project.isDisposed() && !this.myModules.isEmpty() && !this.myCurrentModule.isDisposed();
    }

    public void invoke(final @NotNull Project project, final @Nullable Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddModuleDependencyFix", "invoke"));
        }
        if (this.myModules.size() == 1) {
            this.addDependencyOnModule(project, editor, (Module)ContainerUtil.getFirstItem(this.myModules));
        } else {
            final JBList list = new JBList(this.myModules);
            list.setCellRenderer((ListCellRenderer)((Object)new ModuleListCellRenderer()));
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Module to Add Dependency on").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable(){

                @Override
                public void run() {
                    Object value = list.getSelectedValue();
                    if (value instanceof Module) {
                        AddModuleDependencyFix.this.addDependencyOnModule(project, editor, (Module)value);
                    }
                }
            }).createPopup();
            if (editor != null) {
                popup.showInBestPositionFor(editor);
            } else {
                popup.showCenteredInCurrentWindow(project);
            }
        }
    }

    private void addDependencyOnModule(final Project project, final Editor editor, final Module module) {
        Runnable doit = new Runnable(){

            @Override
            public void run() {
                boolean test = ModuleRootManager.getInstance((Module)AddModuleDependencyFix.this.myCurrentModule).getFileIndex().isInTestSourceContent(AddModuleDependencyFix.this.myClassVFile);
                ModuleRootModificationUtil.addDependency(AddModuleDependencyFix.this.myCurrentModule, module, test ? DependencyScope.TEST : DependencyScope.COMPILE, false);
                if (editor != null) {
                    ArrayList<PsiClass> targetClasses = new ArrayList<PsiClass>();
                    for (PsiClass psiClass : AddModuleDependencyFix.this.myClasses) {
                        if (ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass) != module) continue;
                        targetClasses.add(psiClass);
                    }
                    new AddImportAction(project, AddModuleDependencyFix.this.myReference, editor, targetClasses.toArray(new PsiClass[targetClasses.size()])).execute();
                }
            }
        };
        Couple circularModules = ModuleCompilerUtil.addingDependencyFormsCircularity((Module)this.myCurrentModule, (Module)module);
        if (circularModules == null) {
            doit.run();
        } else {
            AddModuleDependencyFix.showCircularWarningAndContinue(project, (Pair<Module, Module>)circularModules, module, doit);
        }
    }

    private static void showCircularWarningAndContinue(final Project project, Pair<Module, Module> circularModules, Module classModule, final Runnable doit) {
        final String message = QuickFixBundle.message("orderEntry.fix.circular.dependency.warning", classModule.getName(), ((Module)circularModules.getFirst()).getName(), ((Module)circularModules.getSecond()).getName());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!project.isOpen()) {
                    return;
                }
                int ret = Messages.showOkCancelDialog((Project)project, (String)message, (String)QuickFixBundle.message("orderEntry.fix.title.circular.dependency.warning", new Object[0]), (Icon)Messages.getWarningIcon());
                if (ret == 0) {
                    ApplicationManager.getApplication().runWriteAction(doit);
                }
            }
        });
    }
}

