/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.compiler;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.compiler.RemoveElementQuickFix;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;

public class JavacQuirksInspectionVisitor
extends JavaElementVisitor {
    private static final ElementPattern QUALIFIER_REFERENCE = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiJavaCodeReferenceElement.class)).withSuperParent(2, PsiJavaCodeReferenceElement.class);
    private final ProblemsHolder myHolder;

    public JavacQuirksInspectionVisitor(ProblemsHolder holder) {
        this.myHolder = holder;
    }

    public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer) {
        if (PsiUtil.isLanguageLevel7OrHigher((PsiElement)initializer)) {
            return;
        }
        PsiElement lastElement = PsiTreeUtil.skipSiblingsBackward((PsiElement)initializer.getLastChild(), (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        if (lastElement != null && PsiUtil.isJavaToken((PsiElement)lastElement, (IElementType)JavaTokenType.COMMA)) {
            String message = InspectionsBundle.message((String)"inspection.compiler.javac.quirks.anno.array.comma.problem", (Object[])new Object[0]);
            String fixName = InspectionsBundle.message((String)"inspection.compiler.javac.quirks.anno.array.comma.fix", (Object[])new Object[0]);
            this.myHolder.registerProblem(lastElement, message, new LocalQuickFix[]{new RemoveElementQuickFix(fixName)});
        }
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression) {
        if (PsiUtil.isLanguageLevel7OrHigher((PsiElement)expression)) {
            return;
        }
        PsiTypeElement type = expression.getCastType();
        if (type != null) {
            type.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceParameterList(PsiReferenceParameterList list) {
                    super.visitReferenceParameterList(list);
                    if (list.getFirstChild() != null && QUALIFIER_REFERENCE.accepts((Object)list)) {
                        String message = InspectionsBundle.message((String)"inspection.compiler.javac.quirks.qualifier.type.args.problem", (Object[])new Object[0]);
                        String fixName = InspectionsBundle.message((String)"inspection.compiler.javac.quirks.qualifier.type.args.fix", (Object[])new Object[0]);
                        JavacQuirksInspectionVisitor.this.myHolder.registerProblem((PsiElement)list, message, new LocalQuickFix[]{new RemoveElementQuickFix(fixName)});
                    }
                }
            });
        }
    }

    public void visitIdentifier(PsiIdentifier identifier) {
        super.visitIdentifier(identifier);
        if (PsiUtil.getLanguageLevel((PsiElement)identifier).isAtLeast(LanguageLevel.JDK_1_8) && "_".equals(identifier.getText())) {
            this.myHolder.registerProblem((PsiElement)identifier, JavaErrorMessages.message("underscore.identifier", new Object[0]), new LocalQuickFix[0]);
        }
    }
}

