/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.Job;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JobLauncher {
    public static JobLauncher getInstance() {
        return (JobLauncher)ServiceManager.getService(JobLauncher.class);
    }

    public abstract <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<? extends T> var1, ProgressIndicator var2, boolean var3, @NotNull Processor<T> var4) throws ProcessCanceledException;

    public abstract <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<? extends T> var1, ProgressIndicator var2, boolean var3, boolean var4, @NotNull Processor<T> var5) throws ProcessCanceledException;

    @NotNull
    public abstract <T> AsyncFuture<Boolean> invokeConcurrentlyUnderProgressAsync(@NotNull List<? extends T> var1, ProgressIndicator var2, boolean var3, @NotNull Processor<T> var4);

    @NotNull
    public abstract Job<Void> submitToJobThread(int var1, @NotNull Runnable var2, @Nullable Consumer<Future> var3);

    @NotNull
    public Job<Void> submitToJobThread(int priority, @NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/concurrency/JobLauncher", "submitToJobThread"));
        }
        Job<Void> job = this.submitToJobThread(priority, action, null);
        if (job == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/JobLauncher", "submitToJobThread"));
        }
        return job;
    }
}

