/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.SuperEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.debugger.DefaultMethodInvoker;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MethodEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.MethodEvaluator");
    private final JVMName myClassName;
    private final JVMName myMethodSignature;
    private final String myMethodName;
    private final Evaluator[] myArgumentEvaluators;
    private final Evaluator myObjectEvaluator;
    private final boolean myCheckDefaultInterfaceMethod;

    public MethodEvaluator(Evaluator objectEvaluator, JVMName className, String methodName, JVMName signature, Evaluator[] argumentEvaluators) {
        this(objectEvaluator, className, methodName, signature, argumentEvaluators, false);
    }

    public MethodEvaluator(Evaluator objectEvaluator, JVMName className, String methodName, JVMName signature, Evaluator[] argumentEvaluators, boolean checkDefaultInterfaceMethod) {
        this.myObjectEvaluator = new DisableGC(objectEvaluator);
        this.myClassName = className;
        this.myMethodName = methodName;
        this.myMethodSignature = signature;
        this.myArgumentEvaluators = argumentEvaluators;
        this.myCheckDefaultInterfaceMethod = checkDefaultInterfaceMethod;
    }

    @Override
    public Modifier getModifier() {
        return null;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        if (!context.getDebugProcess().isAttached()) {
            return null;
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        boolean requiresSuperObject = this.myObjectEvaluator instanceof SuperEvaluator || this.myObjectEvaluator instanceof DisableGC && ((DisableGC)this.myObjectEvaluator).getDelegate() instanceof SuperEvaluator;
        Object object = this.myObjectEvaluator.evaluate(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("MethodEvaluator: object = " + object);
        }
        if (object == null) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)new NullPointerException());
        }
        if (!(object instanceof ObjectReference) && !(object instanceof ClassType)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.evaluating.method", (Object[])new Object[]{this.myMethodName}));
        }
        ArrayList<Object> args = new ArrayList<Object>(this.myArgumentEvaluators.length);
        for (Evaluator evaluator : this.myArgumentEvaluators) {
            args.add(evaluator.evaluate(context));
        }
        try {
            ReferenceType referenceType = null;
            if (object instanceof ObjectReference) {
                referenceType = ((ObjectReference)object).referenceType();
            } else if (object instanceof ClassType) {
                ClassType qualifierType = (ClassType)object;
                referenceType = debugProcess.findClass(context, qualifierType.name(), context.getClassLoader());
            } else {
                String className;
                String string = className = this.myClassName != null ? this.myClassName.getName(debugProcess) : null;
                if (className != null) {
                    referenceType = debugProcess.findClass(context, className, context.getClassLoader());
                }
            }
            if (referenceType == null) {
                throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.qualifier", (Object[])new Object[]{this.myMethodName})));
            }
            String signature = this.myMethodSignature != null ? this.myMethodSignature.getName(debugProcess) : null;
            String methodName = DebuggerUtilsEx.methodName(referenceType.name(), this.myMethodName, signature);
            if (object instanceof ClassType) {
                List<Method> list;
                Method jdiMethod;
                if (referenceType instanceof ClassType && (jdiMethod = this.myMethodSignature != null ? ((ClassType)referenceType).concreteMethodByName(this.myMethodName, this.myMethodSignature.getName(debugProcess)) : (Method)((list = referenceType.methodsByName(this.myMethodName)).size() > 0 ? list.get(0) : null)) != null && jdiMethod.isStatic()) {
                    return debugProcess.invokeMethod((EvaluationContext)context, (ClassType)referenceType, jdiMethod, args);
                }
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.static.method", (Object[])new Object[]{methodName}));
            }
            ObjectReference objRef = (ObjectReference)object;
            ReferenceType _refType = referenceType;
            if (requiresSuperObject && referenceType instanceof ClassType) {
                _refType = ((ClassType)referenceType).superclass();
            }
            Method jdiMethod = DebuggerUtils.findMethod((ReferenceType)_refType, (String)this.myMethodName, (String)signature);
            if (signature == null && (jdiMethod == null || jdiMethod.argumentTypeNames().size() != args.size())) {
                for (Method method : _refType.methodsByName(this.myMethodName)) {
                    if (method.argumentTypeNames().size() != args.size()) continue;
                    jdiMethod = method;
                    break;
                }
            }
            if (jdiMethod == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.instance.method", (Object[])new Object[]{methodName}));
            }
            if (requiresSuperObject) {
                return debugProcess.invokeInstanceMethod(context, objRef, jdiMethod, args, 2);
            }
            if (this.myCheckDefaultInterfaceMethod && jdiMethod.declaringType() instanceof InterfaceType) {
                return MethodEvaluator.invokeDefaultMethod(debugProcess, context, objRef, this.myMethodName);
            }
            return debugProcess.invokeMethod((EvaluationContext)context, objRef, jdiMethod, args);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Throwable)e);
            }
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    private static Value invokeDefaultMethod(DebugProcess debugProcess, EvaluationContext evaluationContext, Value obj, String name) throws EvaluateException, ClassNotLoadedException, InvalidTypeException {
        List<Method> methods;
        ClassType invokerClass = (ClassType)debugProcess.findClass(evaluationContext, DefaultMethodInvoker.class.getName(), evaluationContext.getClassLoader());
        if (invokerClass != null && !(methods = invokerClass.methodsByName("invoke")).isEmpty()) {
            return debugProcess.invokeMethod(evaluationContext, invokerClass, methods.get(0), Arrays.asList(obj, ((VirtualMachineProxyImpl)debugProcess.getVirtualMachineProxy()).mirrorOf(name)));
        }
        return null;
    }
}

