/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.ui.CheckboxTree;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class PushLogTreeUtil {
    public static final String EDIT_MODE_PROP = "tree.edit.mode";

    @Nullable
    public static Object getTagAtForRenderer(CheckboxTree.CheckboxTreeCellRenderer renderer, MouseEvent e) {
        JTree tree = (JTree)e.getSource();
        Object tag = null;
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            Rectangle rectangle = tree.getPathBounds(path);
            assert (rectangle != null);
            int dx = e.getX() - rectangle.x;
            TreeNode treeNode = (TreeNode)path.getLastPathComponent();
            int row = tree.getRowForLocation(e.getX(), e.getY());
            tree.getCellRenderer().getTreeCellRendererComponent(tree, treeNode, false, false, true, row, true);
            if (treeNode instanceof RepositoryNode) {
                RepositoryNode repositoryNode = (RepositoryNode)((Object)treeNode);
                int checkBoxWidth = repositoryNode.isCheckboxVisible() ? renderer.getCheckbox().getWidth() : 0;
                tag = renderer.getTextRenderer().getFragmentTagAt(dx - checkBoxWidth);
            } else {
                tag = renderer.getTextRenderer().getFragmentTagAt(dx);
            }
        }
        return tag;
    }
}

