/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Block;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CompositeBlockWrapper
extends AbstractBlockWrapper {
    private List<AbstractBlockWrapper> myChildren;

    public CompositeBlockWrapper(Block block, WhiteSpace whiteSpaceBefore, @Nullable CompositeBlockWrapper parent) {
        super(block, whiteSpaceBefore, parent, block.getTextRange());
    }

    public CompositeBlockWrapper(Block block, WhiteSpace whiteSpaceBefore, CompositeBlockWrapper parent, TextRange textRange) {
        super(block, whiteSpaceBefore, parent, textRange);
    }

    public List<AbstractBlockWrapper> getChildren() {
        return this.myChildren;
    }

    public void setChildren(List<AbstractBlockWrapper> children) {
        this.myChildren = children;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.myChildren != null) {
            for (AbstractBlockWrapper wrapper : this.myChildren) {
                assert (wrapper != this);
                wrapper.reset();
            }
        }
    }

    @Override
    protected boolean indentAlreadyUsedBefore(AbstractBlockWrapper child) {
        for (AbstractBlockWrapper childBefore : this.myChildren) {
            if (childBefore == child) {
                return false;
            }
            if (!childBefore.getWhiteSpace().containsLineFeeds()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected IndentData getNumberOfSymbolsBeforeBlock() {
        if (this.myChildren == null || this.myChildren.isEmpty()) {
            return new IndentData(0, 0);
        }
        return this.myChildren.get(0).getNumberOfSymbolsBeforeBlock();
    }

    @Override
    protected LeafBlockWrapper getPreviousBlock() {
        if (this.myChildren == null || this.myChildren.isEmpty()) {
            return null;
        }
        return this.myChildren.get(0).getPreviousBlock();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myChildren = null;
    }

    @Nullable
    public AbstractBlockWrapper getPrevIndentedSibling(AbstractBlockWrapper current) {
        AbstractBlockWrapper candidate = null;
        for (AbstractBlockWrapper child : this.myChildren) {
            if (child.getStartOffset() >= current.getStartOffset()) {
                return candidate;
            }
            if (!child.getWhiteSpace().containsLineFeeds()) continue;
            candidate = child;
        }
        return candidate;
    }
}

