/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserAction;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.Nullable;

public class OpenFileInDefaultBrowserAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Pair<OpenInBrowserRequest, WebBrowserUrlProvider> result = BaseOpenInBrowserAction.doUpdate(e);
        if (result == null) {
            return;
        }
        WebBrowserUrlProvider browserUrlProvider = (WebBrowserUrlProvider)result.second;
        String text = this.getTemplatePresentation().getText();
        String description = this.getTemplatePresentation().getDescription();
        if (browserUrlProvider != null) {
            String customDescription = browserUrlProvider.getOpenInBrowserActionDescription(((OpenInBrowserRequest)result.first).getFile());
            if (customDescription != null) {
                description = customDescription;
            }
            if (HtmlUtil.isHtmlFile((PsiElement)((OpenInBrowserRequest)result.first).getFile())) {
                description = description + " (hold Shift to open URL of local file)";
            }
        }
        presentation.setText(text);
        presentation.setDescription(description);
        WebBrowser browser = OpenFileInDefaultBrowserAction.findUsingBrowser();
        if (browser != null) {
            presentation.setIcon(browser.getIcon());
        }
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setVisible(presentation.isEnabled());
        }
    }

    @Nullable
    private static WebBrowser findUsingBrowser() {
        WebBrowser browser;
        String path;
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        DefaultBrowserPolicy defaultBrowserPolicy = browserManager.getDefaultBrowserPolicy();
        if (defaultBrowserPolicy == DefaultBrowserPolicy.FIRST || defaultBrowserPolicy == DefaultBrowserPolicy.SYSTEM && !BrowserLauncherAppless.canUseSystemDefaultBrowserPolicy()) {
            return browserManager.getFirstActiveBrowser();
        }
        if (defaultBrowserPolicy == DefaultBrowserPolicy.ALTERNATIVE && !StringUtil.isEmpty((String)(path = GeneralSettings.getInstance().getBrowserPath())) && (browser = browserManager.findBrowserById(path)) == null) {
            for (WebBrowser item : browserManager.getActiveBrowsers()) {
                if (!path.equals(item.getPath())) continue;
                return item;
            }
        }
        return null;
    }

    public void actionPerformed(AnActionEvent e) {
        BaseOpenInBrowserAction.open(e, OpenFileInDefaultBrowserAction.findUsingBrowser());
    }
}

