/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewBuilderProvider;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.java.JavaFileTreeModel;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ContentBasedFileSubstitutor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClsStructureViewBuilderProvider
implements StructureViewBuilderProvider {
    @Nullable
    public StructureViewBuilder getStructureViewBuilder(@NotNull FileType fileType, @NotNull VirtualFile file, @NotNull Project project) {
        ContentBasedFileSubstitutor[] processors;
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/ide/highlighter/JavaClsStructureViewBuilderProvider", "getStructureViewBuilder"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/highlighter/JavaClsStructureViewBuilderProvider", "getStructureViewBuilder"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/highlighter/JavaClsStructureViewBuilderProvider", "getStructureViewBuilder"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        for (ContentBasedFileSubstitutor processor : processors = (ContentBasedFileSubstitutor[])Extensions.getExtensions((ExtensionPointName)ContentBasedFileSubstitutor.EP_NAME)) {
            PsiStructureViewFactory factory;
            Language language;
            if (!processor.isApplicable(project, file) || (language = processor.obtainLanguageForFile(file)) == null || (factory = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(language)) == null) continue;
            return factory.getStructureViewBuilder(psiFile);
        }
        final PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        if (javaFile == null) {
            return null;
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                JavaFileTreeModel javaFileTreeModel = new JavaFileTreeModel((PsiClassOwner)javaFile, editor);
                if (javaFileTreeModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/JavaClsStructureViewBuilderProvider$1", "createStructureViewModel"));
                }
                return javaFileTreeModel;
            }
        };
    }
}

