/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.jarFinder.SourceSearchException;
import com.intellij.jarFinder.SourceSearcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SonatypeSourceSearcher
extends SourceSearcher {
    private static final Logger LOG = Logger.getInstance(SonatypeSourceSearcher.class);

    @Override
    @Nullable
    public String findSourceJar(@NotNull ProgressIndicator indicator, @NotNull String artifactId, @NotNull String version) throws SourceSearchException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/SonatypeSourceSearcher", "findSourceJar"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/intellij/jarFinder/SonatypeSourceSearcher", "findSourceJar"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/jarFinder/SonatypeSourceSearcher", "findSourceJar"));
        }
        try {
            indicator.setIndeterminate(true);
            indicator.setText("Connecting to https://oss.sonatype.org");
            indicator.checkCanceled();
            String url = "https://oss.sonatype.org/service/local/lucene/search?collapseresults=true&c=sources&a=" + artifactId + "&v=" + version;
            List artifactList = XPath.newInstance((String)"/searchNGResponse/data/artifact").selectNodes((Object)SonatypeSourceSearcher.readDocumentCancelable(indicator, url));
            if (artifactList.isEmpty()) {
                return null;
            }
            if (artifactList.size() != 1) {
                return null;
            }
            Element element = (Element)artifactList.get(0);
            List artifactHintList = XPath.newInstance((String)"artifactHits/artifactHit/artifactLinks/artifactLink/classifier[text()='sources']/../../..").selectNodes((Object)element);
            if (artifactHintList.isEmpty()) {
                return null;
            }
            String groupId = element.getChildTextTrim("groupId");
            String repositoryId = ((Element)artifactHintList.get(0)).getChildTextTrim("repositoryId");
            return "https://oss.sonatype.org/service/local/artifact/maven/redirect?r=" + repositoryId + "&g=" + groupId + "&a=" + artifactId + "&v=" + version + "&e=jar&c=sources";
        }
        catch (JDOMException e) {
            LOG.warn((Throwable)e);
            throw new SourceSearchException("Failed to parse response from server. See log for more details.");
        }
        catch (IOException e) {
            indicator.checkCanceled();
            LOG.warn((Throwable)e);
            throw new SourceSearchException("Connection problem. See log for more details.");
        }
    }
}

