/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DocumentReferenceByLightVirtualFile
implements DocumentReference {
    private LightVirtualFile myFile;

    DocumentReferenceByLightVirtualFile(@NotNull LightVirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/command/impl/DocumentReferenceByLightVirtualFile", "<init>"));
        }
        this.myFile = file;
    }

    @Nullable
    public Document getDocument() {
        return FileDocumentManager.getInstance().getDocument((VirtualFile)this.myFile);
    }

    @NotNull
    public VirtualFile getFile() {
        LightVirtualFile lightVirtualFile = this.myFile;
        if (lightVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/DocumentReferenceByLightVirtualFile", "getFile"));
        }
        return lightVirtualFile;
    }

    public String toString() {
        return this.myFile.toString();
    }
}

