/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooser;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.IApplicationStore;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.InvalidComponentDataException;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.store.ComponentSaveSession;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.components.store.StateStorageBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RoamingTypeDisabled;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentStoreImpl
implements IComponentStore.Reloadable {
    private static final Logger LOG = Logger.getInstance(ComponentStoreImpl.class);
    private final Map<String, Object> myComponents = Collections.synchronizedMap(new THashMap());
    private final List<SettingsSavingComponent> mySettingsSavingComponents = new CopyOnWriteArrayList<SettingsSavingComponent>();

    @Nullable
    protected abstract StateStorage getDefaultsStorage();

    @Override
    public void initComponent(final @NotNull Object component, boolean service) {
        boolean isSerializable;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "initComponent"));
        }
        if (component instanceof SettingsSavingComponent) {
            this.mySettingsSavingComponents.add((SettingsSavingComponent)component);
        }
        boolean bl = isSerializable = component instanceof JDOMExternalizable || component instanceof PersistentStateComponent;
        if (!isSerializable) {
            return;
        }
        try {
            ApplicationManagerEx.getApplicationEx().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (component instanceof PersistentStateComponent) {
                        ComponentStoreImpl.this.initPersistentComponent((PersistentStateComponent)component, false, false);
                    } else {
                        ComponentStoreImpl.this.initJdomExternalizable((JDOMExternalizable)component);
                    }
                }
            });
        }
        catch (StateStorageException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    @Nullable
    public final ComponentSaveSession startSave() {
        StateStorageManager.ExternalizationSession externalizationSession;
        StateStorageManager.ExternalizationSession externalizationSession2 = externalizationSession = this.myComponents.isEmpty() ? null : this.getStateStorageManager().startExternalization();
        if (externalizationSession != null) {
            Object[] names = ArrayUtilRt.toStringArray(this.myComponents.keySet());
            Arrays.sort(names);
            for (Object name : names) {
                Object component = this.myComponents.get(name);
                if (component instanceof PersistentStateComponent) {
                    this.commitPersistentComponent((PersistentStateComponent)component, externalizationSession);
                    continue;
                }
                if (!(component instanceof JDOMExternalizable)) continue;
                externalizationSession.setStateInOldStorage(component, ComponentManagerImpl.getComponentName(component), component);
            }
        }
        return this.createSaveSession(externalizationSession == null ? null : this.getStateStorageManager().startSave(externalizationSession));
    }

    @Nullable
    protected SaveSessionImpl createSaveSession(@Nullable StateStorage.SaveSession storageManagerSaveSession) {
        return storageManagerSaveSession == null ? null : new SaveSessionImpl(storageManagerSaveSession);
    }

    private <T> void commitPersistentComponent(@NotNull PersistentStateComponent<T> persistentStateComponent, @NotNull StateStorageManager.ExternalizationSession session) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentStateComponent", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "commitPersistentComponent"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "commitPersistentComponent"));
        }
        Object state = persistentStateComponent.getState();
        if (state != null) {
            Storage[] storageSpecs = this.getComponentStorageSpecs(persistentStateComponent, StateStorageOperation.WRITE);
            session.setState(storageSpecs, persistentStateComponent, ComponentStoreImpl.getComponentName(persistentStateComponent), state);
        }
    }

    @Nullable
    private String initJdomExternalizable(@NotNull JDOMExternalizable component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "initJdomExternalizable"));
        }
        String componentName = ComponentManagerImpl.getComponentName(component);
        this.doAddComponent(componentName, component);
        if (this.optimizeTestLoading()) {
            return componentName;
        }
        this.loadJdomDefaults(component, componentName);
        StateStorage stateStorage = this.getStateStorageManager().getOldStorage(component, componentName, StateStorageOperation.READ);
        if (stateStorage == null) {
            return null;
        }
        Element element = ComponentStoreImpl.getJdomState(component, componentName, stateStorage);
        if (element == null) {
            return null;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading configuration for " + component.getClass());
            }
            component.readExternal(element);
        }
        catch (InvalidDataException e) {
            throw new InvalidComponentDataException(e);
        }
        this.validateUnusedMacros(componentName, true);
        return componentName;
    }

    private void doAddComponent(String componentName, Object component) {
        Object existing = this.myComponents.get(componentName);
        if (existing != null && existing != component) {
            LOG.error("Conflicting component name '" + componentName + "': " + existing.getClass() + " and " + component.getClass());
        }
        this.myComponents.put(componentName, component);
    }

    private void loadJdomDefaults(@NotNull Object component, @NotNull String componentName) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "loadJdomDefaults"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "loadJdomDefaults"));
        }
        try {
            StateStorage defaultsStorage = this.getDefaultsStorage();
            if (defaultsStorage == null) {
                return;
            }
            Element defaultState = ComponentStoreImpl.getJdomState(component, componentName, defaultsStorage);
            if (defaultState == null) {
                return;
            }
            ((JDOMExternalizable)component).readExternal(defaultState);
        }
        catch (Exception e) {
            LOG.error("Cannot load defaults for " + component.getClass(), (Throwable)e);
        }
    }

    @Nullable
    private static Element getJdomState(Object component, @NotNull String componentName, @NotNull StateStorage defaultsStorage) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getJdomState"));
        }
        if (defaultsStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultsStorage", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getJdomState"));
        }
        ComponentRoamingManager roamingManager = ComponentRoamingManager.getInstance();
        if (component instanceof RoamingTypeDisabled) {
            roamingManager.setRoamingType(componentName, RoamingType.DISABLED);
        }
        return (Element)defaultsStorage.getState(component, componentName, Element.class, null);
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    private void validateUnusedMacros(@Nullable String componentName, boolean service) {
        TrackingPathMacroSubstitutor substitutor;
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode() && service && componentName != null && project.isInitialized() && (substitutor = this.getStateStorageManager().getMacroSubstitutor()) != null) {
            StorageUtil.notifyUnknownMacros(substitutor, project, componentName);
        }
    }

    private <T> String initPersistentComponent(@NotNull PersistentStateComponent<T> component, boolean reloadData, boolean isReinit) {
        Storage[] storageSpecs;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "initPersistentComponent"));
        }
        State spec = ComponentStoreImpl.getStateSpec(component);
        String name = spec.name();
        ComponentRoamingManager.getInstance().setRoamingType(name, spec.roamingType());
        if (!isReinit) {
            this.doAddComponent(name, component);
        }
        if (this.optimizeTestLoading()) {
            return name;
        }
        Class<T> stateClass = ComponentStoreImpl.getComponentStateClass(component);
        Object state = null;
        StateStorage defaultsStorage = this.getDefaultsStorage();
        if (defaultsStorage != null) {
            state = defaultsStorage.getState(component, name, stateClass, null);
        }
        for (Storage storageSpec : storageSpecs = this.getComponentStorageSpecs(component, StateStorageOperation.READ)) {
            StateStorage stateStorage = this.getStateStorageManager().getStateStorage(storageSpec);
            if (stateStorage == null || !stateStorage.hasState(component, name, stateClass, reloadData)) continue;
            state = stateStorage.getState(component, name, stateClass, state);
            break;
        }
        if (state != null) {
            component.loadState(state);
        }
        this.validateUnusedMacros(name, true);
        return name;
    }

    @NotNull
    private static <T> Class<T> getComponentStateClass(@NotNull PersistentStateComponent<T> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentStateComponent", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStateClass"));
        }
        Class<PersistentStateComponent> persistentStateComponentClass = PersistentStateComponent.class;
        Class<?> componentClass = persistentStateComponent.getClass();
        block0: while (true) {
            for (Class<?> anInterface : componentClass.getInterfaces()) {
                if (anInterface.equals(persistentStateComponentClass)) break block0;
            }
            componentClass = componentClass.getSuperclass();
        }
        Type type = ReflectionUtil.resolveVariable(persistentStateComponentClass.getTypeParameters()[0], componentClass);
        assert (type != null);
        Class clazz = ReflectionUtil.getRawType((Type)type);
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStateClass"));
        }
        return clazz;
    }

    @NotNull
    public static String getComponentName(@NotNull PersistentStateComponent<?> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentStateComponent", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentName"));
        }
        String string = ComponentStoreImpl.getStateSpec(persistentStateComponent).name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentName"));
        }
        return string;
    }

    @NotNull
    private static <T> State getStateSpec(@NotNull PersistentStateComponent<T> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentStateComponent", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getStateSpec"));
        }
        Class<?> aClass = persistentStateComponent.getClass();
        State stateSpec = aClass.getAnnotation(State.class);
        if (stateSpec == null) {
            PluginId pluginId = PluginManagerCore.getPluginByClassName(aClass.getName());
            if (pluginId != null) {
                throw new PluginException("No @State annotation found in " + aClass, pluginId);
            }
            throw new RuntimeException("No @State annotation found in " + aClass);
        }
        State state = stateSpec;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getStateSpec"));
        }
        return state;
    }

    @NotNull
    protected <T> Storage[] getComponentStorageSpecs(@NotNull PersistentStateComponent<T> persistentStateComponent, StateStorageOperation operation) throws StateStorageException {
        Storage[] storageArray;
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentStateComponent", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
        }
        State stateSpec = ComponentStoreImpl.getStateSpec(persistentStateComponent);
        Storage[] storages = stateSpec.storages();
        if (storages.length == 1) {
            if (storages == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
            }
            return storages;
        }
        assert (storages.length > 0);
        Class storageChooserClass = stateSpec.storageChooser();
        if (storageChooserClass == StateStorageChooser.class) {
            StateStorageChooser<PersistentStateComponent<?>> defaultStateStorageChooser = this.getDefaultStateStorageChooser();
            if (defaultStateStorageChooser == null) {
                int actualStorageCount = 0;
                for (Storage storage : storages) {
                    if (storage.deprecated()) continue;
                    ++actualStorageCount;
                }
                if (actualStorageCount > 1) {
                    LOG.error("State chooser not specified for: " + persistentStateComponent.getClass());
                }
                if (!storages[0].deprecated()) {
                    boolean othersAreDeprecated = true;
                    for (int i = 1; i < storages.length; ++i) {
                        if (storages[i].deprecated()) continue;
                        othersAreDeprecated = false;
                        break;
                    }
                    if (othersAreDeprecated) {
                        if (storages == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
                        }
                        return storages;
                    }
                }
                Storage[] sorted = Arrays.copyOf(storages, storages.length);
                Arrays.sort(sorted, new Comparator<Storage>(){

                    @Override
                    public int compare(@NotNull Storage o1, @NotNull Storage o2) {
                        if (o1 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl$2", "compare"));
                        }
                        if (o2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl$2", "compare"));
                        }
                        int w1 = o1.deprecated() ? 1 : 0;
                        int w2 = o2.deprecated() ? 1 : 0;
                        return w1 - w2;
                    }
                });
                if (sorted == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
                }
                return sorted;
            }
            Storage[] storageArray2 = defaultStateStorageChooser.selectStorages(storages, persistentStateComponent, operation);
            if (storageArray2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
            }
            return storageArray2;
        }
        try {
            StateStorageChooser storageChooser = (StateStorageChooser)ReflectionUtil.newInstance((Class)storageChooserClass, (Class[])new Class[0]);
            storageArray = storageChooser.selectStorages(storages, persistentStateComponent, operation);
        }
        catch (RuntimeException e) {
            throw new StateStorageException((Throwable)e);
        }
        if (storageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
        }
        return storageArray;
    }

    protected boolean optimizeTestLoading() {
        return false;
    }

    @Nullable
    protected StateStorageChooser<PersistentStateComponent<?>> getDefaultStateStorageChooser() {
        return null;
    }

    protected static void executeSave(@NotNull StateStorage.SaveSession saveSession, @NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
        if (saveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveSession", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "executeSave"));
        }
        if (readonlyFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readonlyFiles", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "executeSave"));
        }
        try {
            saveSession.save();
        }
        catch (ReadOnlyModificationException e) {
            readonlyFiles.add((Pair<StateStorage.SaveSession, VirtualFile>)Pair.create((Object)saveSession, (Object)e.getFile()));
        }
    }

    @Override
    public boolean isReloadPossible(@NotNull Set<String> componentNames) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "isReloadPossible"));
        }
        for (String componentName : componentNames) {
            Object component = this.myComponents.get(componentName);
            if (component == null || component instanceof PersistentStateComponent && ComponentStoreImpl.getStateSpec((PersistentStateComponent)component).reloadable()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public final Collection<String> getNotReloadableComponents(@NotNull Collection<String> componentNames) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getNotReloadableComponents"));
        }
        LinkedHashSet<String> notReloadableComponents = null;
        for (String componentName : componentNames) {
            Object component = this.myComponents.get(componentName);
            if (component == null || component instanceof PersistentStateComponent && ComponentStoreImpl.getStateSpec((PersistentStateComponent)component).reloadable()) continue;
            if (notReloadableComponents == null) {
                notReloadableComponents = new LinkedHashSet<String>();
            }
            notReloadableComponents.add(componentName);
        }
        Set<String> set = notReloadableComponents == null ? Collections.emptySet() : notReloadableComponents;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getNotReloadableComponents"));
        }
        return set;
    }

    @Override
    public final void reinitComponents(@NotNull Set<String> componentNames, boolean reloadData) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponents"));
        }
        this.reinitComponents(componentNames, Collections.<String>emptySet(), reloadData);
    }

    protected boolean reinitComponent(@NotNull String componentName, boolean reloadData) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponent"));
        }
        PersistentStateComponent component = (PersistentStateComponent)this.myComponents.get(componentName);
        if (component == null) {
            return false;
        }
        this.initPersistentComponent(component, reloadData, true);
        return true;
    }

    @NotNull
    protected abstract MessageBus getMessageBus();

    @Override
    @Nullable
    public final Collection<String> reload(@NotNull MultiMap<StateStorage, VirtualFile> changedStorages) {
        if (changedStorages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedStorages", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reload"));
        }
        SmartHashSet componentNames = new SmartHashSet();
        for (StateStorage storage : changedStorages.keySet()) {
            try {
                storage.analyzeExternalChangesAndUpdateIfNeed(changedStorages.get((Object)storage), (Set)componentNames);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (componentNames.isEmpty()) {
            return Collections.emptySet();
        }
        Collection<String> notReloadableComponents = this.getNotReloadableComponents((Collection<String>)componentNames);
        this.reinitComponents((Set<String>)componentNames, notReloadableComponents, false);
        return notReloadableComponents.isEmpty() ? null : notReloadableComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reinitComponents(@NotNull Set<String> componentNames, @NotNull Collection<String> notReloadableComponents, boolean reloadData) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponents"));
        }
        if (notReloadableComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notReloadableComponents", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponents"));
        }
        MessageBus messageBus = this.getMessageBus();
        ((BatchUpdateListener)messageBus.syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateStarted();
        try {
            for (String componentName : componentNames) {
                if (notReloadableComponents.contains(componentName)) continue;
                this.reinitComponent(componentName, reloadData);
            }
        }
        finally {
            ((BatchUpdateListener)messageBus.syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static ReloadComponentStoreStatus reloadStore(@NotNull Collection<Pair<VirtualFile, StateStorage>> changedStorages, @NotNull IComponentStore.Reloadable store) {
        Collection<String> notReloadableComponents;
        if (changedStorages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedStorages", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reloadStore"));
        }
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reloadStore"));
        }
        MultiMap storageToFiles = MultiMap.createLinkedSet();
        for (Pair<VirtualFile, StateStorage> pair : changedStorages) {
            storageToFiles.putValue(pair.second, pair.first);
        }
        boolean willBeReloaded = false;
        AccessToken token = WriteAction.start();
        try {
            notReloadableComponents = store.reload((MultiMap<StateStorage, VirtualFile>)storageToFiles);
        }
        catch (Throwable e) {
            ReloadComponentStoreStatus reloadComponentStoreStatus;
            block17: {
                try {
                    Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                    reloadComponentStoreStatus = ReloadComponentStoreStatus.ERROR;
                    if (willBeReloaded) break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    token.finish();
                }
                for (StateStorage storage : storageToFiles.keySet()) {
                    if (!(storage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)storage).enableSaving();
                }
            }
            ReloadComponentStoreStatus reloadComponentStoreStatus2 = reloadComponentStoreStatus;
            if (reloadComponentStoreStatus2 != null) return reloadComponentStoreStatus2;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reloadStore"));
        }
        token.finish();
        if (ContainerUtil.isEmpty(notReloadableComponents)) {
            ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.SUCCESS;
            ReloadComponentStoreStatus reloadComponentStoreStatus3 = reloadComponentStoreStatus;
            if (reloadComponentStoreStatus3 != null) return reloadComponentStoreStatus3;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reloadStore"));
        }
        willBeReloaded = ComponentStoreImpl.askToRestart(store, notReloadableComponents, changedStorages);
        ReloadComponentStoreStatus reloadComponentStoreStatus = willBeReloaded ? ReloadComponentStoreStatus.RESTART_AGREED : ReloadComponentStoreStatus.RESTART_CANCELLED;
        ReloadComponentStoreStatus reloadComponentStoreStatus4 = reloadComponentStoreStatus;
        if (reloadComponentStoreStatus4 != null) return reloadComponentStoreStatus4;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reloadStore"));
        finally {
            if (!willBeReloaded) {
                for (StateStorage storage : storageToFiles.keySet()) {
                    if (!(storage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)storage).enableSaving();
                }
            }
        }
    }

    public static boolean askToRestart(@NotNull IComponentStore.Reloadable store, @NotNull Collection<String> notReloadableComponents, @Nullable Collection<Pair<VirtualFile, StateStorage>> changedStorages) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "askToRestart"));
        }
        if (notReloadableComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notReloadableComponents", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "askToRestart"));
        }
        StringBuilder message = new StringBuilder();
        String storeName = store instanceof IApplicationStore ? "Application" : "Project";
        message.append(storeName).append(' ');
        message.append("components were changed externally and cannot be reloaded:\n\n");
        int count = 0;
        for (String string : notReloadableComponents) {
            if (count == 10) {
                message.append('\n').append("and ").append(notReloadableComponents.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(string).append('\n');
            ++count;
        }
        message.append("\nWould you like to ");
        if (store instanceof IApplicationStore) {
            message.append(ApplicationManager.getApplication().isRestartCapable() ? "restart" : "shutdown").append(' ');
            message.append(ApplicationNamesInfo.getInstance().getProductName()).append('?');
        } else {
            message.append("reload project?");
        }
        if (Messages.showYesNoDialog((String)message.toString(), (String)(storeName + " Files Changed"), (Icon)Messages.getQuestionIcon()) == 0) {
            if (changedStorages != null) {
                for (Pair pair : changedStorages) {
                    StateStorage storage = (StateStorage)pair.getSecond();
                    if (!(storage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)storage).disableSaving();
                }
            }
            return true;
        }
        return false;
    }

    public static enum ReloadComponentStoreStatus {
        RESTART_AGREED,
        RESTART_CANCELLED,
        ERROR,
        SUCCESS;

    }

    protected class SaveSessionImpl
    implements ComponentSaveSession {
        private final StateStorage.SaveSession myStorageManagerSaveSession;

        public SaveSessionImpl(StateStorage.SaveSession storageManagerSaveSession) {
            this.myStorageManagerSaveSession = storageManagerSaveSession;
        }

        @Override
        @NotNull
        public ComponentSaveSession save(@NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
            if (readonlyFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readonlyFiles", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl$SaveSessionImpl", "save"));
            }
            for (SettingsSavingComponent settingsSavingComponent : ComponentStoreImpl.this.mySettingsSavingComponents) {
                try {
                    settingsSavingComponent.save();
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
            if (this.myStorageManagerSaveSession != null) {
                ComponentStoreImpl.executeSave(this.myStorageManagerSaveSession, readonlyFiles);
            }
            SaveSessionImpl saveSessionImpl = this;
            if (saveSessionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl$SaveSessionImpl", "save"));
            }
            return saveSessionImpl;
        }

        @Override
        public void finishSave() {
            if (this.myStorageManagerSaveSession != null) {
                ComponentStoreImpl.this.getStateStorageManager().finishSave(this.myStorageManagerSaveSession);
            }
        }
    }
}

