/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.JDOMXIncluder;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultsStateStorage
implements StateStorage {
    private final PathMacroManager myPathMacroManager;

    public DefaultsStateStorage(@Nullable PathMacroManager pathMacroManager) {
        this.myPathMacroManager = pathMacroManager;
    }

    @Nullable
    public Element getState(Object component, String componentName) throws StateStorageException {
        URL url = DecodeDefaultsUtil.getDefaults(component, componentName);
        if (url == null) {
            return null;
        }
        try {
            Document document = JDOMUtil.loadDocument((URL)url);
            document = JDOMXIncluder.resolve((Document)document, (String)url.toExternalForm());
            Element documentElement = document.getRootElement();
            if (this.myPathMacroManager != null) {
                this.myPathMacroManager.expandPaths(documentElement);
            }
            return documentElement;
        }
        catch (IOException e) {
            throw new StateStorageException("Error loading state from " + url, (Throwable)e);
        }
        catch (JDOMException e) {
            throw new StateStorageException("Error loading state from " + url, (Throwable)e);
        }
    }

    @Nullable
    public <T> T getState(Object component, @NotNull String componentName, @NotNull Class<T> stateClass, @Nullable T mergeInto) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DefaultsStateStorage", "getState"));
        }
        if (stateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateClass", "com/intellij/openapi/components/impl/stores/DefaultsStateStorage", "getState"));
        }
        return DefaultStateSerializer.deserializeState(this.getState(component, componentName), stateClass, mergeInto);
    }

    public boolean hasState(@Nullable Object component, @NotNull String componentName, Class<?> aClass, boolean reloadData) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DefaultsStateStorage", "hasState"));
        }
        return DecodeDefaultsUtil.getDefaults(component, componentName) != null;
    }

    @NotNull
    public StateStorage.ExternalizationSession startExternalization() {
        throw new UnsupportedOperationException("Method startExternalization not implemented in " + this.getClass());
    }

    public StateStorage.SaveSession startSave(@NotNull StateStorage.ExternalizationSession externalizationSession) {
        if (externalizationSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizationSession", "com/intellij/openapi/components/impl/stores/DefaultsStateStorage", "startSave"));
        }
        return null;
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Collection<VirtualFile> changedFiles, @NotNull Set<String> result) {
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFiles", "com/intellij/openapi/components/impl/stores/DefaultsStateStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/stores/DefaultsStateStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
    }
}

