/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.CustomizeColoredTreeCellRendererReplacement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JTree;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationMessageElement
extends NavigatableMessageElement {
    public static final String MSG_STYLE = "messageStyle";
    public static final String LINK_STYLE = "linkStyle";
    @NotNull
    private final CustomizeColoredTreeCellRenderer myLeftTreeCellRenderer;
    @NotNull
    private final CustomizeColoredTreeCellRenderer myRightTreeCellRenderer;

    public NotificationMessageElement(final @NotNull ErrorTreeElementKind kind, @Nullable GroupingElement parent, String[] message, Navigatable navigatable, String exportText, String rendererTextPrefix) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/openapi/externalSystem/service/notification/NotificationMessageElement", "<init>"));
        }
        super(kind, parent, message, navigatable, exportText, rendererTextPrefix);
        this.myLeftTreeCellRenderer = new CustomizeColoredTreeCellRenderer(){

            public void customizeCellRenderer(SimpleColoredComponent renderer, JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                renderer.setIcon(this.getIcon(kind));
                renderer.setFont(tree.getFont());
                renderer.append(NewErrorTreeRenderer.calcPrefix(NotificationMessageElement.this));
            }

            @NotNull
            private Icon getIcon(@NotNull ErrorTreeElementKind kind2) {
                if (kind2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/openapi/externalSystem/service/notification/NotificationMessageElement$1", "getIcon"));
                }
                Icon icon = AllIcons.General.Mdot_empty;
                switch (kind2) {
                    case INFO: {
                        icon = AllIcons.General.Information;
                        break;
                    }
                    case ERROR: {
                        icon = AllIcons.General.Error;
                        break;
                    }
                    case WARNING: {
                        icon = AllIcons.General.Warning;
                        break;
                    }
                    case NOTE: {
                        icon = AllIcons.General.Tip;
                        break;
                    }
                    case GENERIC: {
                        icon = AllIcons.General.Mdot_empty;
                    }
                }
                Icon icon2 = icon;
                if (icon2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/notification/NotificationMessageElement$1", "getIcon"));
                }
                return icon2;
            }
        };
        this.myRightTreeCellRenderer = new MyCustomizeColoredTreeCellRendererReplacement();
    }

    @Override
    @Nullable
    public CustomizeColoredTreeCellRenderer getRightSelfRenderer() {
        return this.myRightTreeCellRenderer;
    }

    @Override
    @Nullable
    public CustomizeColoredTreeCellRenderer getLeftSelfRenderer() {
        return this.myLeftTreeCellRenderer;
    }

    protected JEditorPane installJep(@NotNull JEditorPane myEditorPane) {
        if (myEditorPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myEditorPane", "com/intellij/openapi/externalSystem/service/notification/NotificationMessageElement", "installJep"));
        }
        String message = StringUtil.join((String[])this.getText(), (String)"<br>");
        myEditorPane.setEditable(false);
        myEditorPane.setOpaque(false);
        myEditorPane.setEditorKit(UIUtil.getHTMLEditorKit());
        myEditorPane.setHighlighter(null);
        StyleSheet styleSheet = ((HTMLDocument)myEditorPane.getDocument()).getStyleSheet();
        Style style = styleSheet.addStyle(MSG_STYLE, null);
        styleSheet.addStyle(LINK_STYLE, style);
        myEditorPane.setText(message);
        return myEditorPane;
    }

    protected void updateStyle(@NotNull JEditorPane editorPane, @Nullable JTree tree, Object value, boolean selected, boolean hasFocus) {
        if (editorPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorPane", "com/intellij/openapi/externalSystem/service/notification/NotificationMessageElement", "updateStyle"));
        }
        HTMLDocument htmlDocument = (HTMLDocument)editorPane.getDocument();
        Style style = htmlDocument.getStyleSheet().getStyle(MSG_STYLE);
        if (value instanceof LoadingNode) {
            StyleConstants.setForeground(style, (Color)JBColor.GRAY);
        } else if (selected) {
            StyleConstants.setForeground(style, hasFocus ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeTextForeground());
        } else {
            StyleConstants.setForeground(style, UIUtil.getTreeTextForeground());
        }
        if (UIUtil.isUnderGTKLookAndFeel() || UIUtil.isUnderNimbusLookAndFeel() && selected && hasFocus || tree != null && tree.getUI() instanceof WideSelectionTreeUI && ((WideSelectionTreeUI)tree.getUI()).isWideSelection()) {
            editorPane.setOpaque(false);
        } else {
            editorPane.setOpaque(selected && hasFocus);
        }
        htmlDocument.setCharacterAttributes(0, htmlDocument.getLength(), style, false);
    }

    private class MyCustomizeColoredTreeCellRendererReplacement
    extends CustomizeColoredTreeCellRendererReplacement {
        @NotNull
        private final JEditorPane myEditorPane;

        private MyCustomizeColoredTreeCellRendererReplacement() {
            this.myEditorPane = NotificationMessageElement.this.installJep(new JEditorPane());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            NotificationMessageElement.this.updateStyle(this.myEditorPane, tree, value, selected, hasFocus);
            return this.myEditorPane;
        }
    }
}

