/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.labels.SwingActionLink;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class Banner
extends JPanel {
    private final JPanel myLeftPanel = new JPanel(null);
    private final JLabel myProjectIcon = new JLabel();

    Banner(Action action) {
        super(new BorderLayout(10, 0));
        SwingActionLink link = new SwingActionLink(action);
        this.myLeftPanel.setLayout(new BoxLayout(this.myLeftPanel, 0));
        this.myProjectIcon.setIcon(AllIcons.General.ProjectConfigurableBanner);
        this.myProjectIcon.setForeground((Color)JBColor.GRAY);
        this.myProjectIcon.setVisible(false);
        this.add("West", this.myLeftPanel);
        this.add("Center", this.myProjectIcon);
        this.add("East", (Component)link);
        Font font = link.getFont();
        if (font != null) {
            link.setFont(font.deriveFont(1));
        }
    }

    void setText(String ... text) {
        Component[] components = this.myLeftPanel.getComponents();
        int length = text == null ? 0 : text.length;
        for (int i = 0; i < length; ++i) {
            if (i < components.length) {
                components[i].setVisible(true);
                if (!(components[i] instanceof JLabel)) continue;
                ((JLabel)components[i]).setText(text[i]);
                continue;
            }
            JLabel label = new JLabel(text[i]);
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            if (i > 0) {
                label.setIcon(AllIcons.General.Divider);
            }
            this.myLeftPanel.add(label);
        }
        while (length < components.length) {
            components[length++].setVisible(false);
        }
    }

    void setProject(Project project) {
        if (project == null) {
            this.myProjectIcon.setVisible(false);
        } else {
            this.myProjectIcon.setVisible(true);
            this.myProjectIcon.setText(OptionsBundle.message((String)(project.isDefault() ? "configurable.default.project.tooltip" : "configurable.current.project.tooltip"), (Object[])new Object[0]));
        }
    }
}

