/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.IdentityHashMap;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

class ConfigurableEditor
extends AbstractEditor
implements AnActionListener,
AWTEventListener {
    private static final JBColor ERROR_BACKGROUND = new JBColor(0xFFBFBF, 5840671);
    private static final String RESET_NAME = "Reset";
    private static final String RESET_DESCRIPTION = "Rollback changes for this configuration element";
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("SettingsModification", 1000, false, (JComponent)this, (Disposable)this, (JComponent)this);
    private final IdentityHashMap<Configurable, JComponent> myConfigurableContent = new IdentityHashMap();
    private final JLabel myErrorLabel = new JLabel();
    private final AbstractAction myApplyAction;
    private final AbstractAction myResetAction = new AbstractAction("Reset"){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (ConfigurableEditor.this.myConfigurable != null) {
                ConfigurableEditor.this.myConfigurable.reset();
                ConfigurableEditor.this.updateCurrent(ConfigurableEditor.this.myConfigurable, true);
            }
        }
    };
    private Configurable myConfigurable;

    ConfigurableEditor(Disposable parent, Configurable configurable, boolean showApplyButton) {
        super(parent);
        this.myApplyAction = !showApplyButton ? null : new AbstractAction(CommonBundle.getApplyButtonText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConfigurableEditor.this.apply();
            }
        };
        this.myResetAction.putValue("ShortDescription", RESET_DESCRIPTION);
        this.myResetAction.setEnabled(false);
        this.myErrorLabel.setOpaque(true);
        this.myErrorLabel.setVisible(false);
        this.myErrorLabel.setVerticalTextPosition(1);
        this.myErrorLabel.setBorder(BorderFactory.createEmptyBorder(10, 15, 15, 15));
        this.myErrorLabel.setBackground((Color)ERROR_BACKGROUND);
        this.add("South", this.myErrorLabel);
        ActionManager.getInstance().addAnActionListener((AnActionListener)this, (Disposable)this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 56L);
        this.myConfigurable = configurable;
        this.setCurrent(configurable, this.readContent(configurable));
    }

    @Override
    void disposeOnce() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        for (Configurable configurable : this.myConfigurableContent.keySet()) {
            if (configurable == null) continue;
            configurable.disposeUIResources();
        }
        this.myConfigurableContent.clear();
    }

    @Override
    String getHelpTopic() {
        return this.myConfigurable == null ? null : this.myConfigurable.getHelpTopic();
    }

    @Override
    Action getApplyAction() {
        return this.myApplyAction;
    }

    @Override
    Action getResetAction() {
        return this.myResetAction;
    }

    @Override
    boolean apply() {
        return this.setError(ConfigurableEditor.apply(this.myConfigurable));
    }

    void openLink(Configurable configurable) {
        ShowSettingsUtil.getInstance().editConfigurable((Component)this, configurable);
    }

    public final void beforeEditorTyping(char ch, DataContext context) {
    }

    public final void beforeActionPerformed(AnAction action, DataContext context, AnActionEvent event) {
    }

    public final void afterActionPerformed(AnAction action, DataContext context, AnActionEvent event) {
        this.requestUpdate();
    }

    @Override
    public final void eventDispatched(AWTEvent event) {
        switch (event.getID()) {
            case 501: 
            case 502: 
            case 506: {
                MouseEvent me = (MouseEvent)event;
                if (!SwingUtilities.isDescendingFrom(me.getComponent(), this)) break;
                this.requestUpdate();
                break;
            }
            case 401: 
            case 402: {
                KeyEvent ke = (KeyEvent)event;
                if (!SwingUtilities.isDescendingFrom(ke.getComponent(), this)) break;
                this.requestUpdate();
            }
        }
    }

    private void requestUpdate() {
        final Configurable configurable = this.myConfigurable;
        this.myQueue.queue(new Update(this){

            public void run() {
                ConfigurableEditor.this.updateIfCurrent(configurable);
            }

            public boolean isExpired() {
                return ConfigurableEditor.this.myConfigurable != configurable;
            }
        });
    }

    void updateCurrent(Configurable configurable, boolean reset) {
        boolean modified;
        boolean bl = modified = configurable != null && configurable.isModified();
        if (this.myApplyAction != null) {
            this.myApplyAction.setEnabled(modified);
        }
        this.myResetAction.setEnabled(modified);
        if (!modified && reset) {
            this.setError(null);
        }
    }

    private void setCurrent(Configurable configurable, JComponent content) {
        if (this != content.getParent()) {
            this.removeAll();
            this.add("Center", content);
            this.add("South", this.myErrorLabel);
            this.revalidate();
            this.repaint();
        }
        this.updateCurrent(configurable, false);
    }

    final boolean updateIfCurrent(Configurable configurable) {
        if (this.myConfigurable != configurable) {
            return false;
        }
        this.updateCurrent(configurable, false);
        return true;
    }

    final ActionCallback select(final Configurable configurable) {
        this.myConfigurable = configurable;
        JComponent content = this.myConfigurableContent.get(configurable);
        if (content != null) {
            this.setCurrent(configurable, content);
            return ActionCallback.DONE;
        }
        final ActionCallback callback = new ActionCallback();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ConfigurableEditor.this.myDisposed && ConfigurableEditor.this.myConfigurable == configurable) {
                    JComponent content = ConfigurableEditor.this.readContent(configurable);
                    ConfigurableEditor.this.myConfigurableContent.put(configurable, content);
                    ConfigurableEditor.this.setCurrent(configurable, content);
                    callback.setDone();
                } else {
                    callback.setRejected();
                }
            }
        }, ModalityState.any());
        return callback;
    }

    final boolean setError(ConfigurationException exception) {
        if (exception == null) {
            this.myErrorLabel.setVisible(false);
            return true;
        }
        Font font = this.myErrorLabel.getFont();
        if (font != null) {
            this.myErrorLabel.setFont(font.deriveFont(2.0f + (float)font.getSize()));
        }
        this.myErrorLabel.setText("<html><body><strong>Changes were not applied because of the following error</strong>:<br>" + exception.getMessage());
        this.myErrorLabel.setVisible(true);
        return false;
    }

    final JComponent getContent(Configurable configurable) {
        return this.myConfigurableContent.get(configurable);
    }

    final JComponent readContent(final Configurable configurable) {
        JComponent content = this.getContent(configurable);
        if (content != null) {
            return content;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                ConfigurableEditor.this.myConfigurableContent.put(configurable, ConfigurableEditor.this.createContent(configurable));
            }
        });
        return this.getContent(configurable);
    }

    private JComponent createContent(Configurable configurable) {
        JComponent content;
        block6: {
            String description;
            block5: {
                JComponent jComponent = content = configurable == null ? null : configurable.createComponent();
                if (content == null) break block5;
                configurable.reset();
                if (ConfigurableWrapper.cast(MasterDetails.class, (UnnamedConfigurable)configurable) != null) break block6;
                if (ConfigurableWrapper.cast(Configurable.NoMargin.class, (UnnamedConfigurable)configurable) == null) {
                    content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                }
                if (ConfigurableWrapper.cast(Configurable.NoScroll.class, (UnnamedConfigurable)configurable) != null) break block6;
                JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)content, (boolean)true);
                scroll.getVerticalScrollBar().setUnitIncrement(10);
                content = scroll;
                break block6;
            }
            content = new JPanel(new BorderLayout());
            content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            String key = configurable == null ? null : ConfigurableVisitor.ByID.getID(configurable) + ".settings.description";
            String string = description = key == null ? null : ConfigurableEditor.getString(configurable, key);
            if (description == null) {
                description = "Select configuration element in the tree to edit its settings";
                content.add("Center", new JLabel(description, 0));
                content.setPreferredSize(new Dimension(800, 600));
            } else {
                content.add("North", new JLabel(description));
                if (configurable instanceof Configurable.Composite) {
                    Configurable.Composite composite = (Configurable.Composite)configurable;
                    JPanel panel = new JPanel();
                    panel.setLayout(new BoxLayout(panel, 1));
                    content.add("Center", panel);
                    panel.add(Box.createVerticalStrut(10));
                    for (final Configurable current : composite.getConfigurables()) {
                        LinkLabel label = new LinkLabel(current.getDisplayName(), null){

                            public void doClick() {
                                ConfigurableEditor.this.openLink(current);
                            }
                        };
                        label.setBorder(BorderFactory.createEmptyBorder(1, 17, 1, 1));
                        panel.add((Component)label);
                    }
                }
            }
        }
        return content;
    }

    private static String getString(Configurable configurable, String key) {
        try {
            if (configurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                ConfigurableEP ep = wrapper.getExtensionPoint();
                ResourceBundle bundle = AbstractBundle.getResourceBundle((String)ep.bundle, (ClassLoader)ep.getPluginDescriptor().getPluginClassLoader());
                return CommonBundle.message((ResourceBundle)bundle, (String)key, (Object[])new Object[0]);
            }
            return OptionsBundle.message((String)key, (Object[])new Object[0]);
        }
        catch (AssertionError error) {
            return null;
        }
    }

    static ConfigurationException apply(Configurable configurable) {
        if (configurable != null) {
            try {
                configurable.apply();
                UsageTrigger.trigger("ide.settings." + ConvertUsagesUtil.escapeDescriptorName(configurable.getDisplayName()));
            }
            catch (ConfigurationException exception) {
                return exception;
            }
        }
        return null;
    }
}

