/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.ui.border.CustomLineBorder;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SettingsDialog
extends DialogWrapper
implements DataProvider {
    private final String myDimensionServiceKey;
    private final AbstractEditor myEditor;

    public SettingsDialog(Project project, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/options/newEditor/SettingsDialog", "<init>"));
        }
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/openapi/options/newEditor/SettingsDialog", "<init>"));
        }
        super(project, true);
        this.myDimensionServiceKey = key;
        this.myEditor = new ConfigurableEditor(this.myDisposable, configurable, showApplyButton);
        this.init(configurable);
    }

    public SettingsDialog(@NotNull Component parent, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/options/newEditor/SettingsDialog", "<init>"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/options/newEditor/SettingsDialog", "<init>"));
        }
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/openapi/options/newEditor/SettingsDialog", "<init>"));
        }
        super(parent, true);
        this.myDimensionServiceKey = key;
        this.myEditor = new ConfigurableEditor(this.myDisposable, configurable, showApplyButton);
        this.init(configurable);
    }

    public SettingsDialog(@NotNull Project project, @NotNull ConfigurableGroup[] groups, Configurable configurable, String filter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/options/newEditor/SettingsDialog", "<init>"));
        }
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/openapi/options/newEditor/SettingsDialog", "<init>"));
        }
        super(project, true);
        this.myDimensionServiceKey = "SettingsEditor";
        this.myEditor = new SettingsEditor(this.myDisposable, project, groups, configurable, filter);
        this.init(null);
    }

    private void init(Configurable configurable) {
        String name = configurable == null ? null : configurable.getDisplayName();
        this.setTitle(name == null ? CommonBundle.settingsTitle() : name.replaceAll("\n", " "));
        this.init();
    }

    public Object getData(@NonNls String dataId) {
        if (this.myEditor instanceof DataProvider) {
            DataProvider provider = (DataProvider)this.myEditor;
            return provider.getData(dataId);
        }
        return null;
    }

    protected String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    public boolean isTypeAheadEnabled() {
        return true;
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return BorderFactory.createEmptyBorder();
    }

    @Nullable
    protected JComponent createSouthPanel() {
        JComponent panel = super.createSouthPanel();
        if (panel != null) {
            panel.setBorder(BorderFactory.createCompoundBorder((Border)new CustomLineBorder(OnePixelDivider.BACKGROUND, 1, 0, 0, 0), BorderFactory.createEmptyBorder(8, 12, 8, 12)));
        }
        return panel;
    }

    protected JComponent createCenterPanel() {
        return this.myEditor;
    }

    @NotNull
    protected Action[] createActions() {
        Action reset;
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        Action apply = this.myEditor.getApplyAction();
        if (apply != null) {
            actions.add(apply);
        }
        if ((reset = this.myEditor.getResetAction()) != null) {
            actions.add(reset);
        }
        actions.add(this.getHelpAction());
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/newEditor/SettingsDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        String topic = this.myEditor.getHelpTopic();
        if (topic != null) {
            HelpManager.getInstance().invokeHelp(topic);
        }
    }

    protected void doOKAction() {
        if (this.myEditor.apply()) {
            ApplicationManager.getApplication().saveAll();
            super.doOKAction();
        }
    }

    public void doCancelAction(AWTEvent source) {
        if ((source instanceof KeyEvent || source instanceof ActionEvent) && !this.myEditor.cancel()) {
            return;
        }
        super.doCancelAction(source);
    }
}

