/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;

public class JavaProjectRootsUtil {
    public static boolean isOutsideJavaSourceRoot(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        if (psiFile instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
        return !projectFileIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) && !projectFileIndex.isInLibrarySource(file) && !projectFileIndex.isInLibraryClasses(file);
    }

    @NotNull
    public static List<VirtualFile> getSuitableDestinationSourceRoots(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/JavaProjectRootsUtil", "getSuitableDestinationSourceRoots"));
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (ContentEntry entry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                for (SourceFolder sourceFolder : entry.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                    if (JavaProjectRootsUtil.isForGeneratedSources(sourceFolder)) continue;
                    ContainerUtil.addIfNotNull(roots, (Object)sourceFolder.getFile());
                }
            }
        }
        ArrayList<VirtualFile> arrayList = roots;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/JavaProjectRootsUtil", "getSuitableDestinationSourceRoots"));
        }
        return arrayList;
    }

    private static boolean isForGeneratedSources(SourceFolder sourceFolder) {
        JavaSourceRootProperties properties = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
        return properties != null && properties.isForGeneratedSources();
    }

    public static boolean isInGeneratedCode(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/JavaProjectRootsUtil", "isInGeneratedCode"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/JavaProjectRootsUtil", "isInGeneratedCode"));
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = fileIndex.getModuleForFile(file);
        if (module == null) {
            return false;
        }
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file);
        if (sourceRoot == null) {
            return false;
        }
        for (ContentEntry entry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (SourceFolder folder : entry.getSourceFolders()) {
                if (!sourceRoot.equals(folder.getFile())) continue;
                return JavaProjectRootsUtil.isForGeneratedSources(folder);
            }
        }
        return false;
    }

    public static GlobalSearchScope getScopeWithoutGeneratedSources(@NotNull GlobalSearchScope baseScope, @NotNull Project project) {
        if (baseScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "com/intellij/openapi/roots/JavaProjectRootsUtil", "getScopeWithoutGeneratedSources"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/JavaProjectRootsUtil", "getScopeWithoutGeneratedSources"));
        }
        return new NonGeneratedSourceScope(baseScope, project);
    }

    private static class NonGeneratedSourceScope
    extends DelegatingGlobalSearchScope {
        @NotNull
        private final Project myProject;

        private NonGeneratedSourceScope(@NotNull GlobalSearchScope baseScope, @NotNull Project project) {
            if (baseScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "com/intellij/openapi/roots/JavaProjectRootsUtil$NonGeneratedSourceScope", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/JavaProjectRootsUtil$NonGeneratedSourceScope", "<init>"));
            }
            super(baseScope);
            this.myProject = project;
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/JavaProjectRootsUtil$NonGeneratedSourceScope", "contains"));
            }
            return super.contains(file) && !JavaProjectRootsUtil.isInGeneratedCode(file, this.myProject);
        }
    }
}

