/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.ui.configuration.LanguageLevelCombo;
import com.intellij.pom.java.LanguageLevel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class LanguageLevelConfigurable
implements UnnamedConfigurable {
    private LanguageLevelCombo myLanguageLevelCombo;
    private JPanel myPanel = new JPanel(new GridBagLayout());

    public LanguageLevelConfigurable() {
        this.myLanguageLevelCombo = new LanguageLevelCombo();
        this.myLanguageLevelCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object languageLevel = LanguageLevelConfigurable.this.myLanguageLevelCombo.getSelectedItem();
                LanguageLevelConfigurable.this.getLanguageLevelExtension().setLanguageLevel(languageLevel instanceof LanguageLevel ? (LanguageLevel)languageLevel : null);
            }
        });
        this.myLanguageLevelCombo.insertItemAt(LanguageLevelCombo.USE_PROJECT_LANGUAGE_LEVEL, 0);
        this.myPanel.add((Component)new JLabel(ProjectBundle.message((String)"module.module.language.level", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 6, 12, 0), 0, 0));
        this.myPanel.add((Component)((Object)this.myLanguageLevelCombo), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(6, 6, 12, 0), 0, 0));
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.getLanguageLevelExtension().isChanged();
    }

    public void apply() throws ConfigurationException {
        this.getLanguageLevelExtension().commit();
    }

    public void reset() {
        this.myLanguageLevelCombo.setSelectedItem(this.getLanguageLevelExtension().getLanguageLevel());
    }

    public void disposeUIResources() {
        this.myPanel = null;
        this.myLanguageLevelCombo = null;
    }

    public abstract LanguageLevelModuleExtensionImpl getLanguageLevelExtension();
}

