/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.vcs.changes.patch.AutoMatchStrategy;
import com.intellij.openapi.vcs.changes.patch.FilePatchInProgress;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;

class IndividualPiecesStrategy
extends AutoMatchStrategy {
    private boolean mySucceeded = true;

    IndividualPiecesStrategy(VirtualFile baseDir) {
        super(baseDir);
    }

    @Override
    public void acceptPatch(TextFilePatch patch, Collection<VirtualFile> foundByName) {
        if (!this.mySucceeded) {
            return;
        }
        Collection<VirtualFile> variants = this.filterVariants(patch, foundByName);
        if (variants != null && !variants.isEmpty()) {
            FilePatchInProgress filePatchInProgress = new FilePatchInProgress(patch, variants, this.myBaseDir);
            this.myResult.add(filePatchInProgress);
            this.registerFolderDecision(patch.getBeforeName(), filePatchInProgress.getBase());
        } else {
            this.mySucceeded = false;
        }
    }

    @Override
    public void processCreation(TextFilePatch creation) {
        if (!this.mySucceeded) {
            return;
        }
        this.processCreationBasedOnFolderDecisions(creation);
    }

    @Override
    public boolean succeeded() {
        return this.mySucceeded;
    }

    @Override
    public void beforeCreations() {
    }
}

