/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ui.Gray;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class StatusBarUI
extends ComponentUI {
    private static final Dimension MAX_SIZE = new Dimension(Integer.MAX_VALUE, 23);
    private static final Dimension MIN_SIZE = new Dimension(100, 23);
    private static final Border BACKGROUND_PAINTER = new BackgroundPainter();

    public static ComponentUI createUI(JComponent x) {
        return new StatusBarUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle bounds = c.getBounds();
        BACKGROUND_PAINTER.paintBorder(c, g, 0, 0, bounds.width, bounds.height);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return MAX_SIZE;
    }

    private static final class BackgroundPainter
    implements Border {
        private static final Color BORDER_TOP_COLOR = Gray._145;
        private static final Color BORDER2_TOP_COLOR = Gray._255;
        private static final Color BORDER_BOTTOM_COLOR = Gray._255;
        private static final Color BG_COLOR = Gray._238;
        private static final Insets INSETS = new Insets(0, 0, 0, 0);

        private BackgroundPainter() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2d = (Graphics2D)g.create();
            Color background = UIUtil.getPanelBackground();
            g2d.setColor(background);
            g2d.fillRect(0, 0, width, height);
            g2d.setColor(UIUtil.isUnderDarcula() ? BORDER_TOP_COLOR.darker().darker() : BORDER_TOP_COLOR);
            g2d.drawLine(0, 0, width, 0);
            if (!UIUtil.isUnderDarcula()) {
                g2d.setColor(BORDER2_TOP_COLOR);
                g2d.drawLine(0, 1, width, 1);
            }
            g2d.setColor(UIUtil.isUnderDarcula() ? BORDER_BOTTOM_COLOR.darker().darker() : BORDER_BOTTOM_COLOR);
            g2d.drawLine(0, height, width, height);
            g2d.dispose();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

