/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.HashMap;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionToolsConfigurable
extends BaseConfigurable
implements ErrorsConfigurable,
SearchableConfigurable,
Configurable.NoScroll {
    private final CardLayout myLayout;
    private JPanel myPanel;
    public static final String ID = "Errors";
    public static final String DISPLAY_NAME = "Inspections";
    protected JComboBox myProfiles;
    private final Map<String, SingleInspectionProfilePanel> myPanels;
    private JPanel myWholePanel;
    private JButton myAddButton;
    private JButton myDeleteButton;
    private JButton myImportButton;
    private JButton myExportButton;
    private JCheckBox myShareProfileCheckBox;
    private JButton myCopyButton;
    private JBScrollPane myJBScrollPane;
    private final List<String> myDeletedProfiles;
    protected final InspectionProfileManager myProfileManager;
    protected final InspectionProjectProfileManager myProjectProfileManager;
    private static final Logger LOG = Logger.getInstance((String)("#" + InspectionToolsConfigurable.class.getName()));
    private Alarm mySelectionAlarm;

    public InspectionToolsConfigurable(final @NotNull InspectionProjectProfileManager projectProfileManager, InspectionProfileManager profileManager) {
        if (projectProfileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectProfileManager", "com/intellij/profile/codeInspection/ui/InspectionToolsConfigurable", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myLayout = new CardLayout();
        this.myPanels = new HashMap();
        this.myDeletedProfiles = new ArrayList<String>();
        ((InspectionManagerEx)InspectionManager.getInstance((Project)projectProfileManager.getProject())).buildInspectionSearchIndexIfNecessary();
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Set<String> existingProfileNames = InspectionToolsConfigurable.this.myPanels.keySet();
                ModifiableModel model = SingleInspectionProfilePanel.createNewProfile(-1, InspectionToolsConfigurable.this.getSelectedObject(), InspectionToolsConfigurable.this.myWholePanel, "", existingProfileNames, projectProfileManager.getProject());
                if (model != null) {
                    InspectionToolsConfigurable.this.addProfile((InspectionProfileImpl)model);
                    InspectionToolsConfigurable.this.myDeletedProfiles.remove(InspectionToolsConfigurable.getProfilePrefix((Profile)model) + model.getName());
                    InspectionToolsConfigurable.this.myDeleteButton.setEnabled(true);
                }
            }
        });
        this.myDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectionProfileImpl selectedProfile = (InspectionProfileImpl)InspectionToolsConfigurable.this.myProfiles.getSelectedItem();
                ((DefaultComboBoxModel)InspectionToolsConfigurable.this.myProfiles.getModel()).removeElement(selectedProfile);
                InspectionToolsConfigurable.this.myDeletedProfiles.add(InspectionToolsConfigurable.getProfilePrefix(selectedProfile) + selectedProfile.getName());
                InspectionToolsConfigurable.this.myDeleteButton.setEnabled(InspectionToolsConfigurable.this.isDeleteEnabled(selectedProfile));
            }
        });
        final Project project = projectProfileManager.getProject();
        this.myImportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile file) {
                        return file.getFileType().equals(StdFileTypes.XML);
                    }
                };
                descriptor.setDescription("Choose profile file");
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (Component)InspectionToolsConfigurable.this.myWholePanel, null, (Consumer)new Consumer<VirtualFile>(){

                    public void consume(VirtualFile file) {
                        if (file == null) {
                            return;
                        }
                        InspectionProfileImpl profile = new InspectionProfileImpl("TempProfile", InspectionToolRegistrar.getInstance(), (ProfileManager)InspectionToolsConfigurable.this.myProfileManager);
                        try {
                            Element rootElement = JDOMUtil.loadDocument((File)VfsUtilCore.virtualToIoFile((VirtualFile)file)).getRootElement();
                            if (Comparing.strEqual((String)rootElement.getName(), (String)"component")) {
                                rootElement = (Element)rootElement.getChildren().get(0);
                            }
                            HashSet<String> levels = new HashSet<String>();
                            Iterator i$ = rootElement.getChildren("inspection_tool").iterator();
                            while (i$.hasNext()) {
                                Element o;
                                Element inspectElement = o = (Element)i$.next();
                                levels.add(inspectElement.getAttributeValue("level"));
                                for (Element s : inspectElement.getChildren("scope")) {
                                    levels.add(s.getAttributeValue("level"));
                                }
                            }
                            Iterator iterator = levels.iterator();
                            while (iterator.hasNext()) {
                                String level = (String)iterator.next();
                                if (InspectionToolsConfigurable.this.myProfileManager.getOwnSeverityRegistrar().getSeverity(level) == null) continue;
                                iterator.remove();
                            }
                            if (!levels.isEmpty() && Messages.showYesNoDialog((Component)InspectionToolsConfigurable.this.myWholePanel, (String)("Undefined severities detected: " + StringUtil.join(levels, (String)", ") + ". Do you want to create them?"), (String)"Warning", (Icon)Messages.getWarningIcon()) == 0) {
                                for (String level : levels) {
                                    TextAttributes textAttributes = CodeInsightColors.WARNINGS_ATTRIBUTES.getDefaultAttributes();
                                    HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(new HighlightSeverity(level, 50), TextAttributesKey.createTextAttributesKey((String)level));
                                    InspectionToolsConfigurable.this.myProfileManager.getOwnSeverityRegistrar().registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
                                }
                            }
                            profile.readExternal(rootElement);
                            profile.setLocal(true);
                            profile.initInspectionTools(project);
                            if (InspectionToolsConfigurable.this.getProfilePanel(profile) != null && Messages.showOkCancelDialog((Component)InspectionToolsConfigurable.this.myWholePanel, (String)("Profile with name '" + profile.getName() + "' already exists. Do you want to overwrite it?"), (String)"Warning", (Icon)Messages.getInformationIcon()) != 0) {
                                return;
                            }
                            ModifiableModel model = profile.getModifiableModel();
                            model.setModified(true);
                            InspectionToolsConfigurable.this.addProfile((InspectionProfileImpl)model);
                            InspectionToolsConfigurable.this.myDeletedProfiles.remove(InspectionToolsConfigurable.getProfilePrefix(profile) + profile.getName());
                            InspectionToolsConfigurable.this.myDeleteButton.setEnabled(true);
                        }
                        catch (InvalidDataException e1) {
                            LOG.error((Throwable)e1);
                        }
                        catch (JDOMException e1) {
                            LOG.error((Throwable)e1);
                        }
                        catch (IOException e1) {
                            LOG.error((Throwable)e1);
                        }
                    }
                });
            }
        });
        this.myExportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                descriptor.setDescription("Choose directory to store profile file");
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (Component)InspectionToolsConfigurable.this.myWholePanel, null, (Consumer)new Consumer<VirtualFile>(){

                    public void consume(VirtualFile file) {
                        Element element = new Element("inspections");
                        try {
                            SingleInspectionProfilePanel panel = InspectionToolsConfigurable.this.getSelectedPanel();
                            LOG.assertTrue(panel != null);
                            InspectionProfileImpl profile = (InspectionProfileImpl)panel.getSelectedProfile();
                            profile.writeExternal(element);
                            String filePath = FileUtil.toSystemDependentName((String)file.getPath()) + File.separator + FileUtil.sanitizeFileName((String)profile.getName()) + ".xml";
                            if (new File(filePath).isFile() && Messages.showOkCancelDialog((Component)InspectionToolsConfigurable.this.myWholePanel, (String)("File '" + filePath + "' already exist. Do you want to overwrite it?"), (String)"Warning", (Icon)Messages.getQuestionIcon()) != 0) {
                                return;
                            }
                            JDOMUtil.writeDocument((Document)new Document(element), (String)filePath, (String)SystemProperties.getLineSeparator());
                        }
                        catch (WriteExternalException e1) {
                            LOG.error((Throwable)e1);
                        }
                        catch (IOException e1) {
                            LOG.error((Throwable)e1);
                        }
                    }
                });
            }
        });
        this.myCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Set<String> existingProfileNames = InspectionToolsConfigurable.this.myPanels.keySet();
                InspectionProfileImpl model = (InspectionProfileImpl)SingleInspectionProfilePanel.createNewProfile(0, InspectionToolsConfigurable.this.getSelectedObject(), InspectionToolsConfigurable.this.myWholePanel, "", existingProfileNames, project);
                if (model != null) {
                    InspectionProfileImpl modifiableModel = (InspectionProfileImpl)model.getModifiableModel();
                    modifiableModel.setModified(true);
                    InspectionToolsConfigurable.this.addProfile(modifiableModel);
                    InspectionToolsConfigurable.this.myDeletedProfiles.remove(InspectionToolsConfigurable.getProfilePrefix(model) + model.getName());
                    InspectionToolsConfigurable.this.myDeleteButton.setEnabled(true);
                }
            }
        });
        this.myProjectProfileManager = projectProfileManager;
        this.myProfileManager = profileManager;
        this.myJBScrollPane.setBorder(null);
    }

    private void addProfile(InspectionProfileImpl model) {
        String modelName = model.getName();
        SingleInspectionProfilePanel panel = this.createPanel(model, modelName, true);
        this.myPanel.add(modelName, panel);
        if (!this.myPanels.containsKey(InspectionToolsConfigurable.getProfilePrefix(model) + modelName)) {
            ((DefaultComboBoxModel)this.myProfiles.getModel()).addElement(model);
        }
        this.putProfile(model, panel);
        this.myProfiles.setSelectedItem(model);
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return "preferences.inspections";
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/InspectionToolsConfigurable", "getId"));
        }
        return ID;
    }

    public Runnable enableSearch(final String option) {
        return new Runnable(){

            @Override
            public void run() {
                SingleInspectionProfilePanel panel = InspectionToolsConfigurable.this.getSelectedPanel();
                if (panel != null) {
                    panel.setFilter(option);
                }
            }
        };
    }

    public JComponent createComponent() {
        this.myProfiles.setRenderer(new ListCellRendererWrapper<Profile>(){

            public void customize(JList list, Profile value, int index, boolean selected, boolean hasFocus) {
                String profileName = value.getName();
                this.setText(profileName);
                SingleInspectionProfilePanel panel = InspectionToolsConfigurable.this.getProfilePanel(value);
                this.setIcon(panel != null && panel.isProfileShared() ? AllIcons.General.ProjectSettings : AllIcons.General.Settings);
            }
        });
        this.myProfiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectionProfileImpl profile = (InspectionProfileImpl)InspectionToolsConfigurable.this.myProfiles.getSelectedItem();
                if (profile != null) {
                    InspectionToolsConfigurable.this.myDeleteButton.setEnabled(InspectionToolsConfigurable.this.isDeleteEnabled(profile));
                    InspectionToolsConfigurable.this.myLayout.show(InspectionToolsConfigurable.this.myPanel, profile.getName());
                    SingleInspectionProfilePanel panel = InspectionToolsConfigurable.this.getSelectedPanel();
                    if (panel != null) {
                        InspectionToolsConfigurable.this.myShareProfileCheckBox.setSelected(panel.isProfileShared());
                    }
                }
            }
        });
        this.myShareProfileCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleInspectionProfilePanel panel = InspectionToolsConfigurable.this.getSelectedPanel();
                LOG.assertTrue(panel != null, (Object)("No settings panel for: " + InspectionToolsConfigurable.this.getSelectedObject()));
                panel.setProfileShared(InspectionToolsConfigurable.this.myShareProfileCheckBox.isSelected());
                InspectionToolsConfigurable.this.myProfiles.repaint();
            }
        });
        this.myPanel.setLayout(this.myLayout);
        return this.myWholePanel;
    }

    protected abstract InspectionProfileImpl getCurrentProfile();

    public boolean isModified() {
        for (SingleInspectionProfilePanel panel : this.myPanels.values()) {
            if (!panel.isModified()) continue;
            return true;
        }
        if (this.getProfiles().size() != this.myPanels.size()) {
            return true;
        }
        return !this.myDeletedProfiles.isEmpty();
    }

    public void apply() throws ConfigurationException {
        LinkedHashMap<String, SingleInspectionProfilePanel> panels = new LinkedHashMap<String, SingleInspectionProfilePanel>();
        for (String name : this.myPanels.keySet()) {
            if (this.myDeletedProfiles.remove(name)) {
                String profileName = this.getProfilePanel(name).getSelectedProfile().getName();
                this.deleteProfile(profileName);
                continue;
            }
            SingleInspectionProfilePanel panel = this.getProfilePanel(name);
            panel.apply();
            ModifiableModel profile = panel.getSelectedProfile();
            panels.put(InspectionToolsConfigurable.getProfilePrefix((Profile)profile) + profile.getName(), panel);
        }
        this.myPanels.clear();
        this.myPanels.putAll(panels);
    }

    private SingleInspectionProfilePanel getProfilePanel(String name) {
        return this.myPanels.get(name);
    }

    private SingleInspectionProfilePanel getProfilePanel(Profile inspectionProfile) {
        return this.getProfilePanel(InspectionToolsConfigurable.getProfilePrefix(inspectionProfile) + inspectionProfile.getName());
    }

    private void putProfile(Profile profile, SingleInspectionProfilePanel panel) {
        this.myPanels.put(InspectionToolsConfigurable.getProfilePrefix(profile) + profile.getName(), panel);
    }

    private static String getProfilePrefix(Profile profile) {
        return profile.isLocal() ? "L" : "S";
    }

    protected void deleteProfile(String name) {
        if (this.myProfileManager.getProfile(name, false) != null) {
            this.myProfileManager.deleteProfile(name);
        }
        if (this.myProjectProfileManager.getProfile(name, false) != null) {
            this.myProjectProfileManager.deleteProfile(name);
        }
    }

    protected boolean acceptTool(InspectionToolWrapper entry) {
        return true;
    }

    public void reset() {
        this.myDeletedProfiles.clear();
        this.myPanels.clear();
        DefaultComboBoxModel<Profile> model = new DefaultComboBoxModel<Profile>();
        this.myProfiles.setModel(model);
        for (Profile profile : this.getProfiles()) {
            model.addElement(profile);
            String profileName = profile.getName();
            SingleInspectionProfilePanel panel = this.createPanel((InspectionProfileImpl)profile, profileName, false);
            this.putProfile(profile, panel);
            this.myPanel.add(profileName, panel);
        }
        InspectionProfileImpl inspectionProfile = this.getCurrentProfile();
        this.myProfiles.setSelectedItem(inspectionProfile);
        this.myLayout.show(this.myPanel, inspectionProfile.getName());
        this.myDeleteButton.setEnabled(this.isDeleteEnabled(inspectionProfile));
        final SingleInspectionProfilePanel panel = this.getSelectedPanel();
        if (panel != null) {
            panel.setVisible(true);
            this.mySelectionAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (InspectionToolsConfigurable.this.mySelectionAlarm != null) {
                        InspectionToolsConfigurable.this.mySelectionAlarm.addRequest(new Runnable(){

                            @Override
                            public void run() {
                                panel.updateSelection();
                            }
                        }, 200);
                    }
                }
            });
            this.myShareProfileCheckBox.setSelected(panel.isProfileShared());
        }
    }

    private SingleInspectionProfilePanel createPanel(InspectionProfileImpl profile, String profileName, boolean model) {
        return new SingleInspectionProfilePanel(this.myProjectProfileManager, profileName, model ? profile : profile.getModifiableModel()){

            @Override
            protected boolean accept(InspectionToolWrapper entry) {
                return super.accept(entry) && InspectionToolsConfigurable.this.acceptTool(entry);
            }
        };
    }

    private boolean isDeleteEnabled(@NotNull InspectionProfileImpl inspectionProfile) {
        boolean isProjectProfile;
        Profile profile;
        if (inspectionProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/profile/codeInspection/ui/InspectionToolsConfigurable", "isDeleteEnabled"));
        }
        ProfileManager profileManager = inspectionProfile.getProfileManager();
        boolean projectProfileFound = false;
        boolean ideProfileFound = false;
        ComboBoxModel model = this.myProfiles.getModel();
        for (int i = 0; !(i >= model.getSize() || inspectionProfile != (profile = (Profile)model.getElementAt(i)) && (ideProfileFound |= !(isProjectProfile = profile.getProfileManager() == this.myProjectProfileManager)) && (projectProfileFound |= isProjectProfile)); ++i) {
        }
        return profileManager == this.myProjectProfileManager ? projectProfileFound : ideProfileFound;
    }

    protected Collection<Profile> getProfiles() {
        ArrayList<Profile> result = new ArrayList<Profile>();
        result.addAll(new TreeSet(this.myProfileManager.getProfiles()));
        result.addAll(this.myProjectProfileManager.getProfiles());
        return result;
    }

    public void disposeUIResources() {
        for (SingleInspectionProfilePanel panel : this.myPanels.values()) {
            panel.disposeUI();
        }
        this.myPanels.clear();
        if (this.mySelectionAlarm != null) {
            Disposer.dispose((Disposable)this.mySelectionAlarm);
            this.mySelectionAlarm = null;
        }
    }

    @Override
    public void selectProfile(String name) {
        for (int i = 0; i < this.myProfiles.getItemCount(); ++i) {
            if (!Comparing.strEqual((String)((InspectionProfileImpl)this.myProfiles.getItemAt(i)).getName(), (String)name)) continue;
            this.myProfiles.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public void selectInspectionTool(String selectedToolShortName) {
        InspectionProfileImpl inspectionProfile = this.getSelectedObject();
        assert (inspectionProfile != null) : this.configuredProfiles();
        SingleInspectionProfilePanel panel = this.getProfilePanel(inspectionProfile);
        LOG.assertTrue(panel != null, (Object)("No settings panel for: " + inspectionProfile + "; " + this.configuredProfiles()));
        panel.selectInspectionTool(selectedToolShortName);
    }

    protected SingleInspectionProfilePanel getSelectedPanel() {
        InspectionProfileImpl inspectionProfile = this.getSelectedObject();
        assert (inspectionProfile != null) : this.configuredProfiles();
        return this.getProfilePanel(inspectionProfile);
    }

    private String configuredProfiles() {
        return "configured profiles: " + StringUtil.join(this.myPanels.keySet(), (String)", ");
    }

    protected Set<String> getKnownNames() {
        return this.myPanels.keySet();
    }

    @Override
    public InspectionProfileImpl getSelectedObject() {
        return (InspectionProfileImpl)this.myProfiles.getSelectedItem();
    }

    public JComponent getPreferredFocusedComponent() {
        InspectionProfileImpl inspectionProfile = this.getSelectedObject();
        assert (inspectionProfile != null) : this.configuredProfiles();
        return this.getProfilePanel(inspectionProfile).getPreferredFocusedComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JComboBox jComboBox;
        JBScrollPane jBScrollPane;
        JPanel jPanel;
        JPanel jPanel2;
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myJBScrollPane = jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, new Dimension(-1, 45), new Dimension(-1, 45), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        this.myProfiles = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), 5, -1, true, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAddButton = jButton5 = new JButton();
        jButton5.setText("Add");
        jButton5.setMnemonic('D');
        jButton5.setDisplayedMnemonicIndex(1);
        jPanel4.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDeleteButton = jButton4 = new JButton();
        jButton4.setText("Delete");
        jButton4.setMnemonic('L');
        jButton4.setDisplayedMnemonicIndex(2);
        jPanel4.add((Component)jButton4, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myImportButton = jButton3 = new JButton();
        jButton3.setText("Import");
        jButton3.setMnemonic('I');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton3, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myExportButton = jButton2 = new JButton();
        jButton2.setText("Export");
        jButton2.setMnemonic('E');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton2, new GridConstraints(0, 4, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCopyButton = jButton = new JButton();
        jButton.setText("Copy");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myShareProfileCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Share profile");
        jCheckBox.setMnemonic('S');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

