/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.Bits;
import com.intellij.util.io.IntToIntBtree;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.RandomAccessDataFile;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntProcedure;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class PersistentIntList
implements Disposable {
    public static final int MAX_DATA_BYTES = 500000000;
    public static final int MAX_LIST_LENGTH = 100000;
    private final IntToIntBtree index;
    private RandomAccessDataFile data;
    public int gap;
    private final int dataStart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentIntList(@NotNull File indexFile, @NotNull File dataFile, boolean initial) throws IOException {
        if (indexFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexFile", "com/intellij/psi/impl/PersistentIntList", "<init>"));
        }
        if (dataFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFile", "com/intellij/psi/impl/PersistentIntList", "<init>"));
        }
        if (initial) {
            FileUtil.writeToFile((File)dataFile, (byte[])ArrayUtil.EMPTY_BYTE_ARRAY);
        }
        PagedFileStorage.StorageLockContext context = new PagedFileStorage.StorageLockContext(true);
        context.lock();
        try {
            this.data = new RandomAccessDataFile(dataFile);
            this.index = new IntToIntBtree(4096, indexFile, context, initial);
            this.dataStart = this.persistsVarsTo(this.data, initial);
        }
        finally {
            context.unlock();
        }
    }

    private int persistsVarsTo(final @NotNull RandomAccessDataFile data, boolean toDisk) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/psi/impl/PersistentIntList", "persistsVarsTo"));
        }
        return this.index.persistVars(new IntToIntBtree.BtreeDataStorage(){

            public int persistInt(int offset, int value, boolean toDisk) {
                if (toDisk) {
                    data.putInt((long)offset, value);
                    return value;
                }
                return data.getInt((long)offset);
            }
        }, toDisk);
    }

    public void dispose() {
        this.index.withStorageLock(new Runnable(){

            @Override
            public void run() {
                try {
                    PersistentIntList.this.persistsVarsTo(PersistentIntList.this.data, true);
                    PersistentIntList.this.index.doClose();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                PersistentIntList.this.data.dispose();
            }
        });
    }

    @NotNull
    public int[] get(final int id) {
        final Ref res = new Ref();
        this.index.withStorageLock(new Runnable(){

            @Override
            public void run() {
                int pointer;
                int[] ptrPtr = new int[1];
                boolean exists = PersistentIntList.this.index.get(id, ptrPtr);
                if (!exists) {
                    ptrPtr[0] = 0;
                }
                if ((pointer = ptrPtr[0]) == 0) {
                    res.set((Object)ArrayUtil.EMPTY_INT_ARRAY);
                } else {
                    PersistentIntList.assertPointer(pointer);
                    int listLength = PersistentIntList.this.data.getInt((long)pointer);
                    int capacity = PersistentIntList.this.data.getInt((long)(pointer + 4));
                    PersistentIntList.assertListLength(listLength, capacity);
                    int[] result = new int[listLength];
                    byte[] bytes = new byte[listLength * 4];
                    PersistentIntList.this.data.get((long)(pointer + 8), bytes, 0, bytes.length);
                    for (int i = 0; i < listLength; ++i) {
                        result[i] = Bits.getInt((byte[])bytes, (int)(i * 4));
                    }
                    res.set((Object)result);
                }
            }
        });
        int[] nArray = (int[])res.get();
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PersistentIntList", "get"));
        }
        return nArray;
    }

    public boolean add(final int id, final int value) {
        assert (value > 0);
        assert (id > 0);
        final boolean[] added = new boolean[1];
        this.index.withStorageLock(new Runnable(){

            @Override
            public void run() {
                int i;
                int newCapacity;
                int capacity;
                int listLength;
                int[] stored;
                int[] ptrPtr = new int[1];
                PersistentIntList.this.index.get(id, ptrPtr);
                int pointer = ptrPtr[0];
                if (pointer == 0) {
                    stored = ArrayUtil.EMPTY_INT_ARRAY;
                    listLength = 0;
                    capacity = 2;
                } else {
                    PersistentIntList.assertPointer(pointer);
                    listLength = PersistentIntList.this.data.getInt((long)pointer);
                    capacity = PersistentIntList.this.data.getInt((long)(pointer + 4));
                    PersistentIntList.assertListLength(listLength, capacity);
                    stored = new int[listLength];
                    for (int i2 = 0; i2 < listLength; ++i2) {
                        int v;
                        stored[i2] = v = PersistentIntList.this.data.getInt((long)(pointer + (i2 + 2) * 4));
                        if (v != value) continue;
                        return;
                    }
                    if (capacity > listLength) {
                        PersistentIntList.this.data.putInt((long)(pointer + (listLength + 2) * 4), value);
                        PersistentIntList.this.data.putInt((long)pointer, listLength + 1);
                        if (capacity <= listLength) {
                            PersistentIntList.this.data.putInt((long)(pointer + 4), capacity + 1);
                        }
                        added[0] = true;
                        return;
                    }
                    PersistentIntList.this.gap += 8 + 4 * capacity;
                }
                int storePointer = (int)PersistentIntList.this.data.length();
                PersistentIntList.this.data.putInt((long)storePointer, stored.length + 1);
                int n = newCapacity = capacity < 10 ? capacity * 2 : (int)((double)capacity * 1.5);
                assert (newCapacity > stored.length + 1);
                PersistentIntList.this.data.putInt((long)(storePointer + 4), newCapacity);
                for (i = 0; i < stored.length; ++i) {
                    int v = stored[i];
                    PersistentIntList.this.data.putInt((long)(storePointer + (i + 2) * 4), v);
                }
                PersistentIntList.this.data.putInt((long)(storePointer + (stored.length + 2) * 4), value);
                for (i = stored.length + 1; i < newCapacity; ++i) {
                    PersistentIntList.this.data.putInt((long)(storePointer + (i + 2) * 4), 0);
                }
                PersistentIntList.this.index.put(id, storePointer);
                if (storePointer > 10000000) {
                    i = 0;
                }
                added[0] = true;
            }
        });
        return added[0];
    }

    private static void assertListLength(int listLength, int capacity) {
        assert (0 < listLength && listLength <= 100000) : listLength;
        assert (0 < capacity && capacity <= 100000) : capacity;
        assert (capacity >= listLength) : listLength + ", " + capacity;
        assert (capacity <= (listLength + 1) * 2) : listLength + ", " + capacity;
    }

    public void addAll(final int id, final @NotNull int[] values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/psi/impl/PersistentIntList", "addAll"));
        }
        PersistentIntList.assertListLength(values.length, values.length);
        assert (id > 0);
        Arrays.sort(values);
        this.index.withStorageLock(new Runnable(){

            @Override
            public void run() {
                int newCapacity;
                int capacity;
                int newListLength;
                byte[] mergedBytes;
                int[] ptrPtr = new int[1];
                PersistentIntList.this.index.get(id, ptrPtr);
                int pointer = ptrPtr[0];
                if (pointer == 0) {
                    mergedBytes = PersistentIntList.toBytes(values);
                    newListLength = values.length;
                    capacity = 0;
                } else {
                    int[] oldIds = PersistentIntList.this.get(id);
                    PersistentIntList.checkSorted(oldIds);
                    PersistentIntList.assertPointer(pointer);
                    int storedListLength = PersistentIntList.this.data.getInt((long)pointer);
                    capacity = PersistentIntList.this.data.getInt((long)(pointer + 4));
                    PersistentIntList.assertListLength(storedListLength, capacity);
                    byte[] storedBytes = new byte[storedListLength * 4];
                    PersistentIntList.this.data.get((long)(pointer + 8), storedBytes, 0, storedListLength * 4);
                    mergedBytes = new byte[storedBytes.length + values.length * 4];
                    int outPtr = 0;
                    int i = 0;
                    int j = 0;
                    while (i < storedListLength || j < values.length) {
                        int value;
                        int stored = i < storedListLength ? Bits.getInt((byte[])storedBytes, (int)(i * 4)) : Integer.MAX_VALUE;
                        int n = value = j < values.length ? values[j] : Integer.MAX_VALUE;
                        if (stored < value) {
                            Bits.putInt((byte[])mergedBytes, (int)outPtr, (int)stored);
                            outPtr += 4;
                            ++i;
                            continue;
                        }
                        if (stored > value) {
                            Bits.putInt((byte[])mergedBytes, (int)outPtr, (int)value);
                            outPtr += 4;
                            ++j;
                            continue;
                        }
                        Bits.putInt((byte[])mergedBytes, (int)outPtr, (int)value);
                        outPtr += 4;
                        ++j;
                        ++i;
                    }
                    int[] mergedInts = PersistentIntList.fromBytes(mergedBytes, outPtr);
                    PersistentIntList.checkSorted(mergedInts);
                    newListLength = outPtr / 4;
                    PersistentIntList.assertListLength(newListLength, newListLength);
                    if (newListLength <= capacity) {
                        PersistentIntList.storeArray(PersistentIntList.this.data, pointer, newListLength, capacity, mergedBytes);
                        return;
                    }
                    PersistentIntList.this.gap += capacity * 4 + 8;
                }
                int storePointer = (int)PersistentIntList.this.data.length();
                PersistentIntList.assertPointer(storePointer);
                int oldCapacity = Math.max(capacity, newListLength);
                int n = newCapacity = oldCapacity < 10 ? (oldCapacity + 1) * 2 : (int)((double)oldCapacity * 1.5);
                assert (newCapacity > newListLength + 1);
                PersistentIntList.storeArray(PersistentIntList.this.data, storePointer, newListLength, newCapacity, mergedBytes);
                PersistentIntList.this.index.put(id, storePointer);
            }
        });
        int[] ids = this.get(id);
        PersistentIntList.checkSorted(ids);
        TIntHashSet set = new TIntHashSet(ids);
        assert (set.containsAll(values)) : "ids: " + Arrays.toString(ids) + ";\n values:" + Arrays.toString(values);
    }

    private static void checkSorted(int[] oldIds) {
        for (int i = 1; i < oldIds.length; ++i) {
            assert (oldIds[i - 1] < oldIds[i]) : oldIds[i - 1] + ", " + oldIds[i];
        }
    }

    private static byte[] toBytes(@NotNull int[] values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/psi/impl/PersistentIntList", "toBytes"));
        }
        byte[] mergedBytes = new byte[4 * values.length];
        for (int i = 0; i < values.length; ++i) {
            int value = values[i];
            Bits.putInt((byte[])mergedBytes, (int)(i * 4), (int)value);
        }
        return mergedBytes;
    }

    private static int[] fromBytes(@NotNull byte[] bytes, int length) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/psi/impl/PersistentIntList", "fromBytes"));
        }
        assert (length % 4 == 0);
        int[] ints = new int[length / 4];
        for (int i = 0; i < length; i += 4) {
            int value;
            ints[i / 4] = value = Bits.getInt((byte[])bytes, (int)i);
        }
        return ints;
    }

    private static void storeArray(@NotNull RandomAccessDataFile data, int storePointer, int newListLength, int newCapacity, @NotNull byte[] mergedBytes) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/psi/impl/PersistentIntList", "storeArray"));
        }
        if (mergedBytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedBytes", "com/intellij/psi/impl/PersistentIntList", "storeArray"));
        }
        PersistentIntList.assertListLength(newListLength, newCapacity);
        data.putInt((long)storePointer, newListLength);
        data.putInt((long)(storePointer + 4), newCapacity);
        data.put((long)(storePointer + 8), mergedBytes, 0, newListLength * 4);
        byte[] fill = new byte[(newCapacity - newListLength) * 4];
        Arrays.fill(fill, (byte)-1);
        data.put((long)(storePointer + 8 + newListLength * 4), fill, 0, fill.length);
    }

    private static void assertPointer(int pointer) {
        assert (0 < pointer && pointer <= 500000000) : pointer;
    }

    public void flush() {
        this.index.withStorageLock(new Runnable(){

            @Override
            public void run() {
                PersistentIntList.this.persistsVarsTo(PersistentIntList.this.data, true);
                PersistentIntList.this.index.doFlush();
                PersistentIntList.this.data.sync();
            }
        });
    }

    private void compactIfNecessary() {
        if ((long)this.gap < this.data.length() / 2L) {
            return;
        }
        this.index.withStorageLock(new Runnable(){

            @Override
            public void run() {
                PersistentIntList.this.persistsVarsTo(PersistentIntList.this.data, true);
                PersistentIntList.this.index.doFlush();
                PersistentIntList.this.data.sync();
                try {
                    final RandomAccessDataFile newData = new RandomAccessDataFile(new File(PersistentIntList.this.data.getFile().getParentFile(), "newData"));
                    PersistentIntList.this.persistsVarsTo(newData, true);
                    final TIntIntHashMap map = new TIntIntHashMap();
                    PersistentIntList.this.index.processMappings(new IntToIntBtree.KeyValueProcessor(){

                        public boolean process(int key, int value) throws IOException {
                            map.put(key, value);
                            return true;
                        }
                    });
                    map.forEachEntry(new TIntIntProcedure(){

                        public boolean execute(int key, int value) {
                            int[] ids = PersistentIntList.this.get(key);
                            int pointer = (int)newData.length();
                            byte[] bytes = PersistentIntList.toBytes(ids);
                            PersistentIntList.storeArray(newData, pointer, ids.length, (int)((double)ids.length * 1.3), bytes);
                            PersistentIntList.this.index.put(key, pointer);
                            return true;
                        }
                    });
                    PersistentIntList.this.data.dispose();
                    PersistentIntList.this.data = newData;
                    PersistentIntList.this.gap = 0;
                    PersistentIntList.this.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

