/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.psi.impl.source.xml.XmlContentDFA;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XmlContentDFAImpl
extends XmlContentDFA {
    private final XmlElementsGroup myGroup;
    private int myOccurs;
    private XmlContentDFAImpl myLastChild;

    @Nullable
    public static XmlContentDFA createContentDFA(XmlTag parentTag) {
        XmlElementDescriptor descriptor = parentTag.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        XmlElementsGroup topGroup = descriptor.getTopGroup();
        if (topGroup == null) {
            return null;
        }
        return new XmlContentDFAImpl(topGroup);
    }

    private XmlContentDFAImpl(@NotNull XmlElementsGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/psi/impl/source/xml/XmlContentDFAImpl", "<init>"));
        }
        this.myGroup = group;
    }

    @Override
    public List<XmlElementDescriptor> getPossibleElements() {
        ArrayList<XmlElementDescriptor> list = new ArrayList<XmlElementDescriptor>();
        this.getPossibleElements(list);
        return list;
    }

    private void getPossibleElements(List<XmlElementDescriptor> elements) {
        switch (this.myGroup.getGroupType()) {
            case SEQUENCE: {
                this.getLastChild();
                while (this.myLastChild != null) {
                    this.myLastChild.getPossibleElements(elements);
                    if (this.myLastChild.myGroup.getMinOccurs() == 0) {
                        this.myLastChild = this.getNextSubGroup();
                        continue;
                    }
                    return;
                }
                break;
            }
            case CHOICE: 
            case ALL: 
            case GROUP: {
                for (XmlElementsGroup group : this.myGroup.getSubGroups()) {
                    new XmlContentDFAImpl(group).getPossibleElements(elements);
                }
                break;
            }
            case LEAF: {
                ContainerUtil.addIfNotNull(elements, (Object)this.myGroup.getLeafDescriptor());
            }
        }
    }

    @Override
    public void transition(XmlTag xmlTag) {
        XmlElementDescriptor descriptor = xmlTag.getDescriptor();
        if (descriptor != null) {
            this.doTransition(descriptor);
        }
    }

    private Result doTransition(@NotNull XmlElementDescriptor element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlContentDFAImpl", "doTransition"));
        }
        if (this.myGroup.getGroupType() == XmlElementsGroup.Type.LEAF) {
            if (element.equals(this.myGroup.getLeafDescriptor())) {
                return this.consume();
            }
            return Result.NONE;
        }
        return this.processSubGroups(element);
    }

    private Result consume() {
        return ++this.myOccurs >= this.myGroup.getMaxOccurs() ? Result.PROCEED_TO_NEXT : Result.CONSUME;
    }

    private Result processSubGroups(XmlElementDescriptor element) {
        this.getLastChild();
        while (this.myLastChild != null) {
            Result result = this.myLastChild.doTransition(element);
            switch (result) {
                case CONSUME: {
                    return Result.CONSUME;
                }
                case NONE: {
                    this.myLastChild = this.getNextSubGroup();
                    break;
                }
                case PROCEED_TO_NEXT: {
                    this.myLastChild = this.getNextSubGroup();
                    return this.myLastChild == null ? Result.PROCEED_TO_NEXT : Result.CONSUME;
                }
            }
        }
        return Result.NONE;
    }

    private void getLastChild() {
        List subGroups;
        if (this.myLastChild == null && !(subGroups = this.myGroup.getSubGroups()).isEmpty()) {
            this.myLastChild = new XmlContentDFAImpl((XmlElementsGroup)subGroups.get(0));
        }
    }

    @Nullable
    private XmlContentDFAImpl getNextSubGroup() {
        List subGroups = this.myGroup.getSubGroups();
        int i = subGroups.indexOf(this.myLastChild.myGroup) + 1;
        return i == subGroups.size() ? null : new XmlContentDFAImpl((XmlElementsGroup)subGroups.get(i));
    }

    static enum Result {
        NONE,
        CONSUME,
        PROCEED_TO_NEXT;

    }
}

