/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.StructuralSearchUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class MatchOptions
implements JDOMExternalizable,
Cloneable {
    @NonNls
    private static final String TEXT_ATTRIBUTE_NAME = "text";
    private boolean looseMatching;
    private boolean distinct;
    private boolean recursiveSearch;
    private boolean caseSensitiveMatch;
    private boolean resultIsContextMatch = false;
    private FileType myFileType = StructuralSearchUtil.getDefaultFileType();
    private Language myDialect = null;
    private int maxMatches = Integer.MAX_VALUE;
    private SearchScope scope;
    private SearchScope downUpMatchScope;
    private String searchCriteria = "";
    private Map<String, MatchVariableConstraint> variableConstraints;
    private String myPatternContext;
    @NonNls
    private static final String DISTINCT_ATTRIBUTE_NAME = "distinct";
    @NonNls
    private static final String RECURSIVE_ATTRIBUTE_NAME = "recursive";
    @NonNls
    private static final String CASESENSITIVE_ATTRIBUTE_NAME = "caseInsensitive";
    @NonNls
    private static final String CONSTRAINT_TAG_NAME = "constraint";
    @NonNls
    private static final String FILE_TYPE_ATTR_NAME = "type";
    @NonNls
    private static final String DIALECT_ATTR_NAME = "dialect";
    @NonNls
    public static final String INSTANCE_MODIFIER_NAME = "Instance";
    @NonNls
    public static final String MODIFIER_ANNOTATION_NAME = "Modifier";

    public void addVariableConstraint(MatchVariableConstraint constraint) {
        if (this.variableConstraints == null) {
            this.variableConstraints = new LinkedHashMap<String, MatchVariableConstraint>();
        }
        this.variableConstraints.put(constraint.getName(), constraint);
    }

    public boolean hasVariableConstraints() {
        return this.variableConstraints != null;
    }

    public void clearVariableConstraints() {
        this.variableConstraints = null;
    }

    public MatchVariableConstraint getVariableConstraint(String name) {
        if (this.variableConstraints != null) {
            return this.variableConstraints.get(name);
        }
        return null;
    }

    public Iterator<String> getVariableConstraintNames() {
        if (this.variableConstraints == null) {
            return null;
        }
        return this.variableConstraints.keySet().iterator();
    }

    public void setCaseSensitiveMatch(boolean caseSensitiveMatch) {
        this.caseSensitiveMatch = caseSensitiveMatch;
    }

    public boolean isCaseSensitiveMatch() {
        return this.caseSensitiveMatch;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("match options:\n");
        result.append("search pattern:\n");
        result.append(this.searchCriteria);
        result.append("\nsearch scope:\n");
        result.append("\nrecursive:");
        result.append(this.recursiveSearch);
        result.append("\ndistinct:");
        result.append(this.distinct);
        result.append("\ncasesensitive:");
        result.append(this.caseSensitiveMatch);
        return result.toString();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isRecursiveSearch() {
        return this.recursiveSearch;
    }

    public void setRecursiveSearch(boolean recursiveSearch) {
        this.recursiveSearch = recursiveSearch;
    }

    public boolean isLooseMatching() {
        return this.looseMatching;
    }

    public void setLooseMatching(boolean looseMatching) {
        this.looseMatching = looseMatching;
    }

    public void setSearchPattern(String text) {
        this.searchCriteria = text;
    }

    public String getSearchPattern() {
        return this.searchCriteria;
    }

    public int getMaxMatchesCount() {
        return this.maxMatches;
    }

    public boolean isResultIsContextMatch() {
        return this.resultIsContextMatch;
    }

    public void setResultIsContextMatch(boolean resultIsContextMatch) {
        this.resultIsContextMatch = resultIsContextMatch;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public SearchScope getDownUpMatchScope() {
        return this.downUpMatchScope;
    }

    public void setDownUpMatchScope(SearchScope downUpMatchScope) {
        this.downUpMatchScope = downUpMatchScope;
    }

    public void writeExternal(Element element) {
        element.setAttribute(TEXT_ATTRIBUTE_NAME, this.getSearchPattern());
        element.setAttribute(RECURSIVE_ATTRIBUTE_NAME, String.valueOf(this.recursiveSearch));
        if (this.distinct) {
            element.setAttribute(DISTINCT_ATTRIBUTE_NAME, String.valueOf(this.distinct));
        }
        element.setAttribute(CASESENSITIVE_ATTRIBUTE_NAME, String.valueOf(this.caseSensitiveMatch));
        element.setAttribute(FILE_TYPE_ATTR_NAME, this.myFileType.getName());
        if (this.myDialect != null) {
            element.setAttribute(DIALECT_ATTR_NAME, this.myDialect.getID());
        }
        if (this.variableConstraints != null) {
            for (MatchVariableConstraint matchVariableConstraint : this.variableConstraints.values()) {
                if (matchVariableConstraint.isArtificial()) continue;
                Element infoElement = new Element(CONSTRAINT_TAG_NAME);
                element.addContent(infoElement);
                matchVariableConstraint.writeExternal(infoElement);
            }
        }
    }

    public void readExternal(Element element) {
        List elements;
        this.setSearchPattern(element.getAttribute(TEXT_ATTRIBUTE_NAME).getValue());
        Attribute attr = element.getAttribute(RECURSIVE_ATTRIBUTE_NAME);
        if (attr != null) {
            try {
                this.recursiveSearch = attr.getBooleanValue();
            }
            catch (DataConversionException ignored) {
                // empty catch block
            }
        }
        if ((attr = element.getAttribute(DISTINCT_ATTRIBUTE_NAME)) != null) {
            try {
                this.distinct = attr.getBooleanValue();
            }
            catch (DataConversionException ignored) {
                // empty catch block
            }
        }
        if ((attr = element.getAttribute(CASESENSITIVE_ATTRIBUTE_NAME)) != null) {
            try {
                this.caseSensitiveMatch = attr.getBooleanValue();
            }
            catch (DataConversionException ignored) {
                // empty catch block
            }
        }
        if ((attr = element.getAttribute(FILE_TYPE_ATTR_NAME)) != null) {
            String value = attr.getValue();
            this.myFileType = MatchOptions.getFileTypeByName(value);
        }
        if ((attr = element.getAttribute(DIALECT_ATTR_NAME)) != null) {
            this.myDialect = Language.findLanguageByID((String)attr.getValue());
        }
        if ((elements = element.getChildren(CONSTRAINT_TAG_NAME)) != null && !elements.isEmpty()) {
            for (Element element1 : elements) {
                MatchVariableConstraint constraint = new MatchVariableConstraint();
                constraint.readExternal(element1);
                this.addVariableConstraint(constraint);
            }
        }
    }

    private static FileType getFileTypeByName(String value) {
        if (value != null) {
            for (FileType type : StructuralSearchUtil.getSuitableFileTypes()) {
                if (!value.equals(type.getName())) continue;
                return type;
            }
        }
        return StructuralSearchUtil.getDefaultFileType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchOptions)) {
            return false;
        }
        MatchOptions matchOptions = (MatchOptions)o;
        if (this.caseSensitiveMatch != matchOptions.caseSensitiveMatch) {
            return false;
        }
        if (this.distinct != matchOptions.distinct) {
            return false;
        }
        if (this.looseMatching != matchOptions.looseMatching) {
            return false;
        }
        if (this.recursiveSearch != matchOptions.recursiveSearch) {
            return false;
        }
        if (this.searchCriteria != null ? !this.searchCriteria.equals(matchOptions.searchCriteria) : matchOptions.searchCriteria != null) {
            return false;
        }
        if (this.variableConstraints != null ? !((Object)this.variableConstraints).equals(matchOptions.variableConstraints) : matchOptions.variableConstraints != null) {
            return false;
        }
        if (this.myFileType != matchOptions.myFileType) {
            return false;
        }
        if (this.myDialect != null ? !this.myDialect.equals(matchOptions.myDialect) : matchOptions.myDialect != null) {
            return false;
        }
        return !(this.myPatternContext != null ? !this.myPatternContext.equals(matchOptions.myPatternContext) : matchOptions.myPatternContext != null);
    }

    public int hashCode() {
        int result = this.looseMatching ? 1 : 0;
        result = 29 * result + (this.distinct ? 1 : 0);
        result = 29 * result + (this.recursiveSearch ? 1 : 0);
        result = 29 * result + (this.caseSensitiveMatch ? 1 : 0);
        result = 29 * result + (this.searchCriteria != null ? this.searchCriteria.hashCode() : 0);
        result = 29 * result + (this.variableConstraints != null ? ((Object)this.variableConstraints).hashCode() : 0);
        if (this.myFileType != null) {
            result = 29 * result + this.myFileType.hashCode();
        }
        if (this.myDialect != null) {
            result = 29 * result + this.myDialect.hashCode();
        }
        return result;
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    public Language getDialect() {
        return this.myDialect;
    }

    public void setDialect(Language dialect) {
        this.myDialect = dialect;
    }

    public String getPatternContext() {
        return this.myPatternContext;
    }

    public void setPatternContext(String patternContext) {
        this.myPatternContext = patternContext;
    }

    public MatchOptions clone() {
        try {
            return (MatchOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

